/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.env.ConcurrentEnvironment;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.FatalException;
import php.runtime.exceptions.support.ErrorException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.exceptions.support.PhpException;
import php.runtime.ext.support.Extension;
import php.runtime.invoke.InvokeArgumentHelper;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.PropertyCallCache;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.support.MagicSignatureClass;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.CompilePropertyEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.PropertyEntity;
import php.runtime.reflection.support.Entity;
import php.runtime.reflection.support.ReflectionUtils;
import php.runtime.wrap.ClassWrapper;

public class ClassEntity
extends Entity
implements Cloneable {
    private static final int FLAG_GET = 4000;
    private static final int FLAG_SET = 4001;
    private static final int FLAG_ISSET = 4002;
    private static final int FLAG_UNSET = 4003;
    private long id;
    protected int methodCounts = 0;
    protected boolean isInternal = false;
    protected boolean isNotRuntime;
    protected Extension extension;
    protected Class<?> nativeClazz;
    protected Constructor nativeConstructor;
    protected Method nativeInitEnvironment;
    protected ModuleEntity module;
    protected final Map<String, MethodEntity> methods;
    public MethodEntity methodConstruct;
    public MethodEntity methodDestruct;
    public MethodEntity methodMagicSet;
    public MethodEntity methodMagicGet;
    public MethodEntity methodMagicUnset;
    public MethodEntity methodMagicIsset;
    public MethodEntity methodMagicCall;
    public MethodEntity methodMagicCallStatic;
    public MethodEntity methodMagicInvoke;
    public MethodEntity methodMagicToString;
    public MethodEntity methodMagicClone;
    public MethodEntity methodMagicSleep;
    public MethodEntity methodMagicWakeup;
    public MethodEntity methodMagicDebugInfo;
    protected MethodEntity constructor;
    protected final Map<String, ClassEntity> interfaces;
    protected final Map<String, ClassEntity> traits;
    public final Map<String, ConstantEntity> constants;
    public final Map<String, PropertyEntity> properties;
    public final Map<String, PropertyEntity> staticProperties;
    public final Set<String> instanceOfList = new HashSet<String>();
    protected ClassEntity parent;
    protected DocumentComment docComment;
    protected boolean isAbstract = false;
    protected boolean isFinal = false;
    protected Type type = Type.CLASS;
    protected boolean isStatic;
    protected static final ClassEntity magicSignatureClass = new ClassEntity(new ClassWrapper(null, MagicSignatureClass.class));

    public ClassEntity(Context context) {
        super(context);
        this.methods = new LinkedHashMap<String, MethodEntity>();
        this.interfaces = new LinkedHashMap<String, ClassEntity>();
        this.traits = new LinkedHashMap<String, ClassEntity>();
        this.properties = new LinkedHashMap<String, PropertyEntity>();
        this.staticProperties = new LinkedHashMap<String, PropertyEntity>();
        this.constants = new LinkedHashMap<String, ConstantEntity>();
    }

    public ClassEntity(ClassWrapper wrapper) {
        this((Context)null);
        wrapper.onWrap(this);
    }

    public void setExtension(Extension extension) {
        this.extension = extension;
    }

    public String getCompiledInternalName() {
        return super.getInternalName();
    }

    @Override
    public String getInternalName() {
        return super.getInternalName();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isTrait() {
        return this.type == Type.TRAIT;
    }

    public void setInternal(boolean isInternal) {
        this.isInternal = isInternal;
    }

    public boolean isNotRuntime() {
        return this.isNotRuntime;
    }

    public void setNotRuntime(boolean isNotRuntime) {
        this.isNotRuntime = isNotRuntime;
    }

    public void doneDeclare() {
        if (this.isClass()) {
            this.methodConstruct = this.methods.get("__construct");
            if (!(this.methodConstruct == null || this.methodConstruct.getPrototype() != null && this.methodConstruct.getPrototype().isAbstractable())) {
                this.methodConstruct.setDynamicSignature(true);
            }
            this.methodDestruct = this.methods.get("__destruct");
            this.methodMagicSet = this.methods.get("__set");
            this.methodMagicGet = this.methods.get("__get");
            this.methodMagicUnset = this.methods.get("__unset");
            this.methodMagicIsset = this.methods.get("__isset");
            this.methodMagicCall = this.methods.get("__call");
            this.methodMagicCallStatic = this.methods.get("__callstatic");
            this.methodMagicInvoke = this.methods.get("__invoke");
            this.methodMagicToString = this.methods.get("__tostring");
            this.methodMagicClone = this.methods.get("__clone");
            this.methodMagicSleep = this.methods.get("__sleep");
            this.methodMagicWakeup = this.methods.get("__wakeup");
            this.methodMagicDebugInfo = this.methods.get("__debuginfo");
        }
    }

    public Extension getExtension() {
        return this.extension;
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean anAbstract) {
        this.isAbstract = anAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean aFinal) {
        this.isFinal = aFinal;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isInterface() {
        return this.type == Type.INTERFACE;
    }

    public boolean isClass() {
        return this.type == Type.CLASS;
    }

    public boolean isHiddenInCallStack() {
        return false;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Map<String, MethodEntity> getMethods() {
        return this.methods;
    }

    public int getMethodCounts() {
        return this.methodCounts;
    }

    public void __setMethodCounts(int methodCounts) {
        this.methodCounts = methodCounts;
    }

    public List<MethodEntity> getOwnedMethods() {
        ArrayList<MethodEntity> result = new ArrayList<MethodEntity>();
        for (MethodEntity el : this.methods.values()) {
            if (!el.isOwned(this)) continue;
            result.add(el);
        }
        return result;
    }

    public SignatureResult addMethod(MethodEntity method, String realName) {
        MethodEntity systemMethod;
        String name = realName == null ? method.getLowerName() : realName;
        SignatureResult addResult = new SignatureResult();
        if (method.isAbstract && method.isFinal) {
            addResult.add(InvalidMethod.error(InvalidMethod.Kind.FINAL_ABSTRACT, method));
        } else if (method.isAbstractable() && !method.isAbstract && this.type != Type.INTERFACE) {
            addResult.add(InvalidMethod.error(InvalidMethod.Kind.NON_ABSTRACT, method));
        } else if (method.isAbstract && !method.isAbstractable()) {
            addResult.add(InvalidMethod.error(InvalidMethod.Kind.NON_ABSTRACTABLE, method));
        } else if (method.isAbstract && !this.isAbstract && !this.isTrait()) {
            addResult.add(InvalidMethod.error(InvalidMethod.Kind.NON_EXISTS, method));
        } else if (this.type == Type.INTERFACE && (method.modifier != Modifier.PUBLIC || method.isFinal)) {
            addResult.add(InvalidMethod.error(InvalidMethod.Kind.INVALID_ACCESS_FOR_INTERFACE, method));
        }
        if (magicSignatureClass != null && (systemMethod = magicSignatureClass.findMethod(name.toLowerCase())) != null && method.clazz.getId() == this.getId()) {
            if (method.prototype == null) {
                method.setPrototype(systemMethod);
            }
            if (systemMethod.getModifier() == Modifier.PUBLIC && method.getModifier() != Modifier.PUBLIC) {
                addResult.add(InvalidMethod.warning(InvalidMethod.Kind.MAGIC_MUST_BE_PUBLIC, method));
            }
            if (!systemMethod.equalsBySignature(method, false)) {
                addResult.add(InvalidMethod.error(InvalidMethod.Kind.INVALID_SIGNATURE, method));
            } else if (systemMethod.isStatic && !method.isStatic) {
                addResult.add(InvalidMethod.warning(InvalidMethod.Kind.MUST_STATIC, method));
            } else if (!systemMethod.isStatic && method.isStatic) {
                addResult.add(InvalidMethod.warning(InvalidMethod.Kind.MUST_NON_STATIC, method));
            }
        }
        if (this.parent == null || !name.equals(this.parent.lowerName) || !this.methods.containsKey(name)) {
            this.methods.put(name, method);
        }
        if (name.equals(this.lowerName) && !this.isTrait()) {
            this.methods.put("__construct", method);
        }
        return addResult;
    }

    public int nextMethodIndex() {
        return this.methodCounts++;
    }

    public MethodEntity findMethod(String name) {
        return this.methods.get(name);
    }

    public ConstantEntity findConstant(String name) {
        return this.constants.get(name);
    }

    public PropertyEntity findProperty(String name) {
        int pos = name.lastIndexOf(0);
        if (pos > -1 && pos + 1 < name.length()) {
            name = name.substring(pos + 1);
        }
        return this.properties.get(name);
    }

    public PropertyEntity findStaticProperty(String name) {
        return this.staticProperties.get(name);
    }

    public ClassEntity getParent() {
        return this.parent;
    }

    public boolean isInstanceOf(Class<? extends IObject> clazz) {
        return this.isInstanceOf(ReflectionUtils.getClassName(clazz));
    }

    public boolean isInstanceOf(ClassEntity what) {
        return what != null && (this.id == what.id || this.instanceOfList.contains(what.lowerName));
    }

    public boolean isInstanceOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        String lowerName = name.toLowerCase();
        return this.instanceOfList.contains(lowerName) || this.lowerName.equals(lowerName);
    }

    public boolean isInstanceOfLower(String lowerName) {
        if (lowerName == null) {
            throw new IllegalArgumentException();
        }
        return this.instanceOfList.contains(lowerName) || this.lowerName.equals(lowerName);
    }

    public SignatureResult updateParentMethods() {
        SignatureResult result = new SignatureResult();
        if (this.parent != null) {
            for (Map.Entry<String, MethodEntity> entry : this.parent.getMethods().entrySet()) {
                MethodEntity method;
                MethodEntity implMethod = this.findMethod(entry.getKey());
                if (implMethod == (method = entry.getValue())) continue;
                if (implMethod == null) {
                    SignatureResult addResult = this.addMethod(method, entry.getKey());
                    if (this.methodConstruct == null && !this.isTrait() && method.getName().equalsIgnoreCase(this.parent.getName()) && !method.isAbstractable() && !this.methods.containsKey("__construct")) {
                        method.setDynamicSignature(true);
                        this.methods.put("__construct", method);
                    }
                    result.methods.addAll(addResult.methods);
                    continue;
                }
                implMethod.setPrototype(method);
                if (method.isFinal) {
                    result.add(InvalidMethod.error(InvalidMethod.Kind.FINAL, implMethod));
                }
                if (!this.isAbstract && method.isAbstract && implMethod.isAbstract) {
                    result.add(InvalidMethod.error(InvalidMethod.Kind.NON_EXISTS, implMethod));
                }
                if (!implMethod.equalsBySignature(method)) {
                    if (!method.isDynamicSignature() || method.isAbstractable()) {
                        boolean isStrict = true;
                        MethodEntity pr = method;
                        while (pr != null) {
                            if (pr.isAbstractable()) {
                                isStrict = false;
                                break;
                            }
                            pr = method.getPrototype();
                        }
                        result.add(!isStrict ? InvalidMethod.error(InvalidMethod.Kind.INVALID_SIGNATURE, implMethod) : InvalidMethod.strict(InvalidMethod.Kind.INVALID_SIGNATURE, implMethod));
                    }
                } else if (implMethod.isStatic() && !method.isStatic()) {
                    result.add(InvalidMethod.error(InvalidMethod.Kind.MUST_NON_STATIC, implMethod));
                } else if (!implMethod.isStatic() && method.isStatic()) {
                    result.add(InvalidMethod.error(InvalidMethod.Kind.MUST_STATIC, implMethod));
                }
                if (method.isPublic() && !implMethod.isPublic()) {
                    result.add(InvalidMethod.error(InvalidMethod.Kind.MUST_BE_PUBLIC, implMethod));
                    continue;
                }
                if (!method.isProtected() || !implMethod.isPrivate()) continue;
                result.add(InvalidMethod.error(InvalidMethod.Kind.MUST_BE_PROTECTED, implMethod));
            }
            this.doneDeclare();
        }
        return result;
    }

    public ExtendsResult setParent(ClassEntity parent) {
        return this.setParent(parent, true);
    }

    public ExtendsResult setParent(ClassEntity parent, boolean updateParentMethods) {
        ExtendsResult result = new ExtendsResult(parent);
        if (this.parent != null) {
            throw new RuntimeException("Cannot re-assign parent for classes");
        }
        this.parent = parent;
        if (parent != null) {
            if (parent.useJavaLikeNames) {
                this.useJavaLikeNames = true;
            }
            this.methodCounts = parent.methodCounts;
            this.instanceOfList.add(parent.getLowerName());
            this.instanceOfList.addAll(parent.instanceOfList);
            this.interfaces.putAll(parent.interfaces);
            this.properties.putAll(parent.properties);
            this.staticProperties.putAll(parent.staticProperties);
            this.constants.putAll(parent.constants);
        }
        if (updateParentMethods) {
            result.methods = this.updateParentMethods();
        }
        return result;
    }

    public ImplementsResult addInterface(ClassEntity _interface) {
        ImplementsResult result = new ImplementsResult(_interface);
        for (ConstantEntity e : _interface.constants.values()) {
            ConstantEntity origin = this.constants.get(e.getName());
            if (origin == null || e.getClazz().getId() != _interface.getId() || this.parent != null && this.parent.constants.get(e.getName()) != null) continue;
            result.signature.addConstant(InvalidConstant.error(origin, e));
        }
        this.constants.putAll(_interface.constants);
        this.interfaces.put(_interface.getLowerName(), _interface);
        this.instanceOfList.add(_interface.getLowerName());
        this.instanceOfList.addAll(_interface.instanceOfList);
        for (MethodEntity method : _interface.getMethods().values()) {
            MethodEntity implMethod = this.findMethod(method.getLowerName());
            if (implMethod == method) continue;
            if (implMethod == null) {
                this.addMethod(method, null);
                if (this.type != Type.CLASS || this.isAbstract) continue;
                result.signature.add(InvalidMethod.error(InvalidMethod.Kind.NON_EXISTS, method));
                continue;
            }
            implMethod.setPrototype(method);
            if (!implMethod.equalsBySignature(method)) {
                result.signature.add(InvalidMethod.error(InvalidMethod.Kind.INVALID_SIGNATURE, implMethod));
                continue;
            }
            if (implMethod.isStatic() && !method.isStatic()) {
                result.signature.add(InvalidMethod.error(InvalidMethod.Kind.MUST_NON_STATIC, implMethod));
                continue;
            }
            if (implMethod.isStatic() || !method.isStatic()) continue;
            result.signature.add(InvalidMethod.error(InvalidMethod.Kind.MUST_STATIC, implMethod));
        }
        return result;
    }

    public Map<String, ClassEntity> getInterfaces() {
        return this.interfaces;
    }

    public void addTrait(ClassEntity trait) {
        if (!trait.isTrait()) {
            throw new IllegalArgumentException("'" + trait.getName() + "' is not a trait");
        }
        this.traits.put(trait.getLowerName(), trait);
    }

    public boolean hasTrait(String traitLowerName) {
        return this.traits.containsKey(traitLowerName);
    }

    public Map<String, ClassEntity> getTraits() {
        return this.traits;
    }

    public Collection<ConstantEntity> getConstants() {
        return this.constants.values();
    }

    public Collection<PropertyEntity> getProperties() {
        return this.properties.values();
    }

    public Collection<PropertyEntity> getStaticProperties() {
        return this.staticProperties.values();
    }

    public void addConstant(ConstantEntity constant) {
        this.constants.put(constant.getName(), constant);
        constant.setClazz(this);
    }

    public void addDynamicConstant(Environment env, String name, Memory value) {
        ConstantEntity entity = this.constants.get(name);
        env.getOrCreateStatic(entity.getInternalName(), value);
    }

    public void addDynamicStaticProperty(Environment env, String name, Memory value) {
        PropertyEntity prop = this.staticProperties.get(name);
        env.getOrCreateStatic(prop.specificName, value);
    }

    public void addDynamicProperty(Environment env, String name, Memory value) {
        PropertyEntity prop = this.properties.get(name);
        env.getOrCreateStatic(prop.getInternalName(), value);
    }

    public PropertyResult addProperty(PropertyEntity property) {
        PropertyResult result = new PropertyResult();
        PropertyEntity prototype = null;
        if (property.isStatic()) {
            prototype = this.staticProperties.get(property.getLowerName());
            if (prototype != null && prototype.getModifier() != property.getModifier()) {
                property.setPrototype(prototype);
            }
            if (prototype == null) {
                prototype = this.properties.get(property.getName());
            }
            this.staticProperties.put(property.getName(), property);
        } else {
            prototype = this.properties.get(property.getLowerName());
            if (prototype != null && prototype.getModifier() != property.getModifier()) {
                property.setPrototype(prototype);
            }
            if (prototype == null) {
                prototype = this.staticProperties.get(property.getName());
            }
            this.properties.put(property.getName(), property);
        }
        if (prototype != null) {
            boolean overridden;
            if (property.getPrototype() != null) {
                if (prototype.isProtected() && property.isPrivate()) {
                    result.addError(InvalidProperty.Kind.MUST_BE_PROTECTED, property);
                }
                if (prototype.isPublic() && !property.isPublic()) {
                    result.addError(InvalidProperty.Kind.MUST_BE_PUBLIC, property);
                }
            }
            boolean bl = overridden = property.modifier.ordinal() > prototype.modifier.ordinal();
            if (!property.isPrivate() && property.modifier == prototype.modifier) {
                overridden = true;
            }
            if (property.isPublic() && prototype.isProtected()) {
                overridden = true;
            }
            if (prototype.isStatic() && !property.isStatic()) {
                if (overridden) {
                    property.setPrototype(prototype);
                    result.addError(InvalidProperty.Kind.STATIC_AS_NON_STATIC, property);
                }
            } else if (property.isStatic() && !prototype.isStatic() && overridden) {
                property.setPrototype(prototype);
                result.addError(InvalidProperty.Kind.NON_STATIC_AS_STATIC, property);
            }
        }
        property.setClazz(this);
        return result;
    }

    protected void addStaticProperty(PropertyEntity property) {
        if (!property.isStatic()) {
            throw new IllegalArgumentException("Property must be static");
        }
        this.staticProperties.put(property.getLowerName(), property);
        property.setClazz(this);
    }

    public MethodEntity getConstructor() {
        return this.constructor;
    }

    public void setConstructor(MethodEntity constructor) {
        this.constructor = constructor;
        constructor.setClazz(this);
    }

    public DocumentComment getDocComment() {
        return this.docComment;
    }

    public void setDocComment(DocumentComment docComment) {
        this.docComment = docComment;
    }

    public Class<?> getNativeClass() {
        return this.nativeClazz;
    }

    @Deprecated
    public Class<?> getNativeClazz() {
        return this.nativeClazz;
    }

    protected static void invalidAccessToProperty(Environment env, TraceInfo trace, PropertyEntity entity, int accessFlag) {
        switch (accessFlag) {
            case 1: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PROTECTED_PROPERTY.fetch(entity.getClazz().getName(), entity.getName()), new Object[0]);
            }
            case 2: {
                env.error(trace, ErrorType.E_ERROR, Messages.ERR_ACCESS_TO_PRIVATE_PROPERTY.fetch(entity.getClazz().getName(), entity.getName()), new Object[0]);
            }
        }
    }

    public void setNativeClazz(Class<?> nativeClazz) {
        this.nativeClazz = nativeClazz;
        if (nativeClazz.getAnnotation(Reflection.UseJavaLikeNames.class) != null) {
            this.useJavaLikeNames = true;
        }
        if (!nativeClazz.isInterface()) {
            try {
                this.nativeConstructor = nativeClazz.getConstructor(Environment.class, ClassEntity.class);
                this.nativeConstructor.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                this.nativeConstructor = null;
            }
            if (!this.isInternal) {
                try {
                    this.nativeInitEnvironment = this.isTrait() ? nativeClazz.getDeclaredMethod("__$initEnvironment", Environment.class, String.class) : nativeClazz.getDeclaredMethod("__$initEnvironment", Environment.class);
                    this.nativeInitEnvironment.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    this.nativeInitEnvironment = null;
                }
            }
        }
    }

    public ModuleEntity getModule() {
        return this.module;
    }

    public void setModule(ModuleEntity module) {
        this.module = module;
    }

    public void initEnvironment(Environment env) {
        if (this.isClass() && this.nativeInitEnvironment != null) {
            try {
                this.nativeInitEnvironment.invoke(null, env);
            }
            catch (InvocationTargetException e) {
                env.__throwException(e);
            }
            catch (IllegalAccessException e) {
                throw new CriticalException(e);
            }
        }
        if (!this.traits.isEmpty()) {
            HashSet<ClassEntity> used = new HashSet<ClassEntity>();
            try {
                for (ClassEntity trait : this.traits.values()) {
                    trait.initTraitEnvironment(env, this, used);
                }
            }
            catch (Exception e) {
                env.catchUncaught(e);
            }
            catch (Throwable e) {
                throw new CriticalException(e);
            }
        }
    }

    protected void initTraitEnvironment(Environment env, ClassEntity originClass, Set<ClassEntity> used) throws Throwable {
        if (this.nativeInitEnvironment != null) {
            try {
                this.nativeInitEnvironment.invoke(null, env, originClass.getName());
            }
            catch (InvocationTargetException e) {
                env.__throwException(e);
            }
        }
        for (ClassEntity trait : this.traits.values()) {
            if (!used.add(trait)) continue;
            trait.initTraitEnvironment(env, originClass, used);
        }
    }

    public <T extends IObject> T newObjectWithoutConstruct(Environment env) {
        IObject object = null;
        try {
            if (this.nativeConstructor != null) {
                object = (IObject)this.nativeConstructor.newInstance(env, this);
            }
        }
        catch (InvocationTargetException e) {
            env.__throwException(e);
            return null;
        }
        catch (InstantiationException e) {
            throw new CriticalException(e);
        }
        catch (IllegalAccessException e) {
            throw new CriticalException(e);
        }
        return (T)object;
    }

    public <T extends IObject> T newMock(Environment env) throws Throwable {
        if (this.nativeConstructor == null) {
            env.error(env.trace(), ErrorType.E_CORE_ERROR, "Cannot find a java constructor %s(Environment, ClassEntity)", this.getName());
        }
        try {
            IObject object = (IObject)this.nativeConstructor.newInstance(env, this);
            object.setAsMock();
            return (T)object;
        }
        catch (InstantiationException e) {
            return null;
        }
    }

    public <T extends IObject> T newObject(Environment env, TraceInfo trace, boolean doConstruct, Memory ... args) throws Throwable {
        IObject object;
        if (this.isAbstract) {
            env.error(trace, "Cannot instantiate abstract class %s", this.name);
        } else if (this.type == Type.INTERFACE) {
            env.error(trace, "Cannot instantiate interface %s", this.name);
        } else if (this.type == Type.TRAIT) {
            env.error(trace, "Cannot instantiate trait %s", this.name);
        }
        try {
            if (this.nativeConstructor == null) {
                env.error(trace, ErrorType.E_CORE_ERROR, "Cannot find a java constructor %s(Environment, ClassEntity)", this.getName());
            }
            object = (IObject)this.nativeConstructor.newInstance(env, this);
        }
        catch (InvocationTargetException e) {
            env.__throwException(e);
            return null;
        }
        ArrayMemory props = object.getProperties();
        for (PropertyEntity property : this.getProperties()) {
            if (this.id != property.clazz.getId() || property.getGetter() != null) continue;
            props.putAsKeyString(property.getSpecificName(), property.getDefaultValue(env).toImmutable());
        }
        ClassEntity tmp = this.parent;
        while (tmp != null) {
            long otherId = tmp.getId();
            for (PropertyEntity property : tmp.getProperties()) {
                if (property.getClazz().getId() != otherId || property.getGetter() != null || property.modifier == Modifier.PROTECTED && props.getByScalar(property.getName()) != null) continue;
                props.getByScalarOrCreate(property.getSpecificName(), property.getDefaultValue(env).toImmutable());
            }
            tmp = tmp.parent;
        }
        if (doConstruct && this.methodConstruct != null) {
            ObjectInvokeHelper.invokeMethod(object, this.methodConstruct, env, trace, args, true);
        }
        return (T)object;
    }

    public <T extends IObject> T cloneObject(T value, Environment env, TraceInfo trace) throws Throwable {
        T copy = this.newObjectWithoutConstruct(env);
        ForeachIterator iterator = value.getProperties().foreachIterator(false, false);
        ArrayMemory props = copy.getProperties();
        while (iterator.next()) {
            Object key = iterator.getKey();
            if (key instanceof String) {
                PropertyEntity entity;
                String name = (String)key;
                if (name.indexOf(0) > -1) {
                    name = name.substring(name.lastIndexOf(0) + 1);
                }
                if ((entity = this.properties.get(name)) != null) {
                    if (props.getByScalar(entity.getSpecificName()) != null) continue;
                    props.put(entity.getSpecificName(), iterator.getValue().toImmutable());
                    continue;
                }
                props.put(key, iterator.getValue().toImmutable());
                continue;
            }
            props.put(key, iterator.getValue().toImmutable());
        }
        if (this.methodMagicClone != null) {
            ObjectInvokeHelper.invokeMethod(copy, this.methodMagicClone, env, trace, null, true);
        }
        return copy;
    }

    public Memory concatProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return new StringMemory(o1.concat(o2));
            }
        }, callCache, cacheIndex);
    }

    public Memory plusProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, final ReferenceMemory oldValue) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                if (oldValue != null) {
                    oldValue.assign(o1);
                }
                return o1.plus(o2);
            }
        }, null, 0);
    }

    public Memory minusProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, final ReferenceMemory oldValue) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                if (oldValue != null) {
                    oldValue.assign(o1);
                }
                return o1.minus(o2);
            }
        }, null, 0);
    }

    public Memory mulProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.mul(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory divProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.div(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory modProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.mod(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory bitAndProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.bitAnd(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory bitOrProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.bitOr(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory bitXorProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.bitXor(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory bitShrProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.bitShr(o2);
            }
        }, callCache, cacheIndex);
    }

    public Memory bitShlProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        return this.setProperty(env, trace, object, property, memory, new SetterCallback(){

            @Override
            public Memory invoke(Memory o1, Memory o2) {
                return o1.bitShl(o2);
            }
        }, callCache, cacheIndex);
    }

    public void appendProperty(IObject object, String property, Memory value) {
        object.getProperties().put(property, value);
    }

    public Memory refOfProperty(ArrayMemory props, String name) {
        PropertyEntity entity = this.properties.get(name);
        return props.refOfIndex(entity == null ? name : entity.getSpecificName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Memory setProperty(Environment env, TraceInfo trace, IObject object, String property, Memory memory, SetterCallback callback, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        ReferenceMemory value;
        PropertyEntity staticEntity;
        PropertyEntity entity;
        PropertyEntity propertyEntity = entity = callCache == null ? null : (PropertyEntity)callCache.get(env, cacheIndex);
        if (entity == null) {
            ClassEntity context = env.getLastClassOnStack();
            PropertyEntity propertyEntity2 = entity = this.isInstanceOf(context) ? context.properties.get(property) : this.properties.get(property);
            if (callCache != null && entity != null) {
                callCache.put(env, cacheIndex, entity);
            }
        }
        if (entity == null && (staticEntity = this.staticProperties.get(property)) != null) {
            ClassEntity.invalidAccessToProperty(env, trace, staticEntity, staticEntity.canAccess(env));
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_ACCESSING_STATIC_PROPERTY_AS_NON_STATIC, staticEntity.getClazz().getName(), staticEntity.getName());
        }
        int accessFlag = entity == null ? 0 : entity.canAccess(env);
        ArrayMemory props = object.getProperties();
        if (entity != null) {
            if (entity.setter != null) {
                if (callback != null) {
                    memory = callback.invoke(this.getProperty(env, trace, object, property, null, 0), memory);
                }
                try {
                    ObjectInvokeHelper.invokeMethod(object, entity.setter, env, trace, new Memory[]{memory}, false);
                    return memory;
                }
                catch (IllegalArgumentException e) {
                    if (object.getReflection().isInstanceOf(entity.setter.getClazz())) throw e;
                    return this.setProperty(env, trace, object, property, memory, callback, null, 0);
                }
            }
            if (entity.getter != null) {
                env.error(trace, ErrorType.E_RECOVERABLE_ERROR, Messages.ERR_READONLY_PROPERTY.fetch(entity.getClazz().getName(), property), new Object[0]);
            }
        }
        ReferenceMemory referenceMemory = props == null || accessFlag != 0 ? null : (value = props.getByScalar(entity == null ? property : entity.specificName));
        if (value == null) {
            boolean recursive = false;
            ClassEntity context = env.getLastClassOnStack();
            if (context != null && this.methodMagicSet != null && context.getId() == this.methodMagicSet.getClazz().getId()) {
                boolean bl = recursive = env.peekCall((int)0).flags == 4001;
            }
            if (this.methodMagicSet != null && !recursive) {
                StringMemory memoryProperty = new StringMemory(property);
                if (callback != null) {
                    Memory o1 = Memory.NULL;
                    if (this.methodMagicGet != null) {
                        try {
                            Memory[] args = new Memory[]{memoryProperty};
                            env.pushCall(trace, object, args, this.methodMagicGet.getName(), this.methodMagicSet.getClazz().getName(), this.name);
                            env.peekCall((int)0).flags = 4000;
                            InvokeArgumentHelper.checkType(env, trace, this.methodMagicGet, args);
                            o1 = this.methodMagicGet.invokeDynamic(object, env, memoryProperty);
                        }
                        finally {
                            env.popCall();
                        }
                    }
                    memory = callback.invoke(o1, memory);
                }
                try {
                    Memory[] args = new Memory[]{memoryProperty, memory};
                    env.pushCall(trace, object, args, this.methodMagicSet.getName(), this.methodMagicSet.getClazz().getName(), this.name);
                    env.peekCall((int)0).flags = 4001;
                    InvokeArgumentHelper.checkType(env, trace, this.methodMagicSet, args);
                    this.methodMagicSet.invokeDynamic(object, env, args);
                    return memory;
                }
                finally {
                    env.popCall();
                }
            }
            if (callback != null) {
                memory = callback.invoke(Memory.NULL, memory);
            }
            String name = property;
            if (entity == null) return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
            if (accessFlag != 0 && context == null) {
                switch (accessFlag) {
                    case 2: {
                        if (object.getReflection().getId() != entity.getClazz().getId()) break;
                        ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
                        return Memory.NULL;
                    }
                    case 1: {
                        ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
                        return Memory.NULL;
                    }
                }
            }
            if (context == null) return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
            switch (entity.modifier) {
                case PRIVATE: {
                    if (entity.getClazz().getId() != context.getId()) return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
                    name = entity.specificName;
                    return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
                }
                case PROTECTED: {
                    if (!context.isInstanceOf(entity.getClazz())) return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
                    name = entity.specificName;
                }
            }
            return props == null ? Memory.NULL : (entity == null ? props.refOfIndex(name).assign(memory) : entity.assignValue(env, trace, object, name, memory));
        }
        if (callback != null) {
            memory = callback.invoke(value, memory);
        }
        if (!(entity instanceof CompilePropertyEntity)) return value.assign(memory);
        return entity.assignValue(env, trace, object, property, memory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory unsetProperty(Environment env, TraceInfo trace, IObject object, String property, PropertyCallCache callCache, int index) throws Throwable {
        ArrayMemory props;
        PropertyEntity staticEntity;
        int accessFlag;
        ClassEntity context = env.getLastClassOnStack();
        PropertyEntity entity = this.isInstanceOf(context) ? context.properties.get(property) : this.properties.get(property);
        int n = accessFlag = entity == null ? 0 : entity.canAccess(env);
        if (entity == null && (staticEntity = this.staticProperties.get(property)) != null) {
            ClassEntity.invalidAccessToProperty(env, trace, staticEntity, staticEntity.canAccess(env));
        }
        if (((props = object.getProperties()) == null || accessFlag != 0 || props.removeByScalar(entity == null ? property : entity.specificName) == null) && this.methodMagicUnset != null) {
            if (context != null && context.getId() == this.methodMagicUnset.getClazz().getId() && env.peekCall((int)0).flags == 4003) {
                return Memory.NULL;
            }
            try {
                Memory[] args = new Memory[]{new StringMemory(property)};
                env.pushCall(trace, object, args, this.methodMagicUnset.getName(), this.methodMagicUnset.getClazz().getName(), this.name);
                env.peekCall((int)0).flags = 4003;
                InvokeArgumentHelper.checkType(env, trace, this.methodMagicUnset, args);
                this.methodMagicUnset.invokeDynamic(object, env, args);
            }
            finally {
                env.popCall();
            }
            return Memory.NULL;
        }
        if (accessFlag != 0) {
            ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
        }
        if ((entity = this.staticProperties.get(property)) != null) {
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_ACCESSING_STATIC_PROPERTY_AS_NON_STATIC, entity.getClazz().getName(), entity.getName());
        }
        return Memory.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory emptyProperty(Environment env, TraceInfo trace, IObject object, String property) throws Throwable {
        ClassEntity contex = env.getLastClassOnStack();
        PropertyEntity entity = this.isInstanceOf(contex) ? contex.properties.get(property) : this.properties.get(property);
        int accessFlag = entity == null ? 0 : entity.canAccess(env);
        ArrayMemory props = object.getProperties();
        if (props != null && accessFlag == 0) {
            ReferenceMemory tmp = props.getByScalar(entity == null ? property : entity.specificName);
            if (tmp != null) {
                return ((Memory)tmp).toBoolean() ? Memory.TRUE : Memory.NULL;
            }
            return Memory.NULL;
        }
        if (this.methodMagicIsset != null) {
            Memory result;
            if (contex != null && contex.getId() == this.methodMagicIsset.getClazz().getId() && env.peekCall((int)0).flags == 4002) {
                return object.getProperties().getByScalar(property) != null ? Memory.TRUE : Memory.NULL;
            }
            try {
                Memory[] args = new Memory[]{new StringMemory(property)};
                env.pushCall(trace, object, args, this.methodMagicIsset.getName(), this.methodMagicIsset.getClazz().getName(), this.name);
                env.peekCall((int)0).flags = 4002;
                InvokeArgumentHelper.checkType(env, trace, this.methodMagicIsset, new StringMemory(property));
                result = this.methodMagicIsset.invokeDynamic(object, env, new StringMemory(property)).toBoolean() ? Memory.TRUE : Memory.NULL;
            }
            finally {
                env.popCall();
            }
            return result;
        }
        return Memory.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory issetProperty(Environment env, TraceInfo trace, IObject object, String property, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        Memory tmp;
        PropertyEntity entity;
        PropertyEntity propertyEntity = entity = callCache == null || env instanceof ConcurrentEnvironment ? null : (PropertyEntity)callCache.get(env, cacheIndex);
        if (entity == null) {
            ClassEntity contex = env.getLastClassOnStack();
            PropertyEntity propertyEntity2 = entity = this.isInstanceOf(contex) ? contex.properties.get(property) : this.properties.get(property);
            if (entity != null && callCache != null) {
                callCache.put(env, cacheIndex, entity);
            }
        }
        int accessFlag = entity == null ? 0 : entity.canAccess(env);
        ArrayMemory props = object.getProperties();
        Memory memory = props == null || accessFlag != 0 ? null : (tmp = props.getByScalar(entity == null ? property : entity.specificName));
        if (tmp != null) {
            return tmp.isNull() ? tmp : Memory.TRUE;
        }
        if (this.methodMagicIsset != null) {
            Memory result;
            ClassEntity contex = env.getLastClassOnStack();
            if (contex != null && contex.getId() == this.methodMagicIsset.getClazz().getId() && env.peekCall((int)0).flags == 4002) {
                return object.getProperties().getByScalar(property) != null ? Memory.TRUE : Memory.NULL;
            }
            try {
                Memory[] args = new Memory[]{new StringMemory(property)};
                env.pushCall(trace, object, args, this.methodMagicIsset.getName(), this.methodMagicIsset.getClazz().getName(), this.name);
                env.peekCall((int)0).flags = 4002;
                InvokeArgumentHelper.checkType(env, trace, this.methodMagicIsset, new StringMemory(property));
                result = this.methodMagicIsset.invokeDynamic(object, env, new StringMemory(property)).toBoolean() ? Memory.TRUE : Memory.NULL;
            }
            finally {
                env.popCall();
            }
            return result;
        }
        return Memory.NULL;
    }

    public Memory getStaticProperty(Environment env, TraceInfo trace, String property, boolean errorIfNotExists, boolean checkAccess, ClassEntity context, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        int accessFlag;
        PropertyEntity entity;
        PropertyEntity propertyEntity = entity = callCache == null || env instanceof ConcurrentEnvironment || context != null ? null : (PropertyEntity)callCache.get(env, cacheIndex);
        if (entity == null) {
            boolean saveCache = context == null && callCache != null;
            context = context == null ? env.getLastClassOnStack() : context;
            PropertyEntity propertyEntity2 = entity = this.isInstanceOf(context) ? context.findStaticProperty(property) : this.findStaticProperty(property);
            if (saveCache && entity != null) {
                callCache.put(env, cacheIndex, entity);
            }
        }
        if (entity == null) {
            if (errorIfNotExists) {
                env.error(trace, Messages.ERR_ACCESS_TO_UNDECLARED_STATIC_PROPERTY.fetch(this.name, property), new Object[0]);
            }
            return Memory.NULL;
        }
        if (checkAccess && (accessFlag = entity.canAccess(env, context)) != 0) {
            ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
            return Memory.NULL;
        }
        return entity.getStaticValue(env, trace);
    }

    public Memory getRefProperty(Environment env, TraceInfo trace, IObject object, String property, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        ReferenceMemory value;
        PropertyEntity staticEntity;
        PropertyEntity entity;
        PropertyEntity propertyEntity = entity = callCache == null || env instanceof ConcurrentEnvironment ? null : (PropertyEntity)callCache.get(env, cacheIndex);
        if (entity == null) {
            ClassEntity context = env.getLastClassOnStack();
            PropertyEntity propertyEntity2 = entity = this.isInstanceOf(context) ? context.properties.get(property) : this.properties.get(property);
            if (callCache != null) {
                callCache.put(env, cacheIndex, entity);
            }
        }
        if (entity == null && (staticEntity = this.staticProperties.get(property)) != null) {
            ClassEntity.invalidAccessToProperty(env, trace, staticEntity, staticEntity.canAccess(env));
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_ACCESSING_STATIC_PROPERTY_AS_NON_STATIC, staticEntity.getClazz().getName(), staticEntity.getName());
        }
        int accessFlag = entity == null ? 0 : entity.canAccess(env);
        ArrayMemory props = object.getProperties();
        ReferenceMemory referenceMemory = props == null || accessFlag != 0 ? null : (value = props.getByScalar(entity == null ? property : entity.specificName));
        if (accessFlag != 0) {
            ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
        }
        if (value == null) {
            Memory memory = value = props == null ? new ReferenceMemory() : object.getProperties().refOfIndex(property);
            if (this.methodMagicGet != null || this.methodMagicSet != null) {
                env.error(trace, props == null ? ErrorType.E_ERROR : ErrorType.E_NOTICE, Messages.ERR_INDIRECT_MODIFICATION_OVERLOADED_PROPERTY, this.name, property);
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory getProperty(Environment env, TraceInfo trace, IObject object, String property, PropertyCallCache callCache, int cacheIndex) throws Throwable {
        Memory value;
        int accessFlag;
        PropertyEntity staticEntity;
        PropertyEntity entity;
        PropertyEntity propertyEntity = entity = callCache == null || env instanceof ConcurrentEnvironment ? null : (PropertyEntity)callCache.get(env, cacheIndex);
        if (entity == null) {
            ClassEntity context = env.getLastClassOnStack();
            PropertyEntity propertyEntity2 = entity = this.isInstanceOf(context) ? context.properties.get(property) : this.properties.get(property);
            if (callCache != null && entity != null) {
                callCache.put(env, cacheIndex, entity);
            }
        }
        if (entity == null && (staticEntity = this.staticProperties.get(property)) != null) {
            ClassEntity.invalidAccessToProperty(env, trace, staticEntity, staticEntity.canAccess(env));
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_ACCESSING_STATIC_PROPERTY_AS_NON_STATIC, staticEntity.getClazz().getName(), staticEntity.getName());
        }
        int n = accessFlag = entity == null ? 0 : entity.canAccess(env);
        if (entity != null && accessFlag != 0) {
            value = null;
        } else if (entity != null) {
            value = entity.getValue(env, trace, object);
        } else {
            ArrayMemory props = object.getProperties();
            Memory memory = value = props == null ? null : props.getByScalar(property);
        }
        if (value != null) {
            return value;
        }
        if (this.methodMagicGet != null) {
            Memory result;
            ClassEntity context = env.getLastClassOnStack();
            if (context != null && context.getId() == this.methodMagicGet.getClazz().getId() && env.peekCall((int)0).flags == 4000) {
                env.error(trace, ErrorType.E_NOTICE, Messages.ERR_UNDEFINED_PROPERTY, this.name, property);
                return Memory.NULL;
            }
            try {
                Memory[] args = new Memory[]{new StringMemory(property)};
                env.pushCall(trace, object, args, this.methodMagicGet.getName(), this.methodMagicGet.getClazz().getName(), this.name);
                env.peekCall((int)0).flags = 4000;
                InvokeArgumentHelper.checkType(env, trace, this.methodMagicGet, args);
                result = this.methodMagicGet.invokeDynamic(object, env, args);
            }
            finally {
                env.popCall();
            }
            return result;
        }
        if (accessFlag != 0) {
            ClassEntity.invalidAccessToProperty(env, trace, entity, accessFlag);
        }
        env.error(trace, ErrorType.E_NOTICE, Messages.ERR_UNDEFINED_PROPERTY, this.name, property);
        return Memory.NULL;
    }

    public void setProperty(IObject object, String name, Memory value) {
        PropertyEntity prop = this.findProperty(name);
        if (prop == null) {
            throw new RuntimeException("Property '" + name + "' not found");
        }
        object.getProperties().put(prop.specificName, value == null ? Memory.NULL : value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassEntity)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClassEntity entity = (ClassEntity)o;
        return this.id == entity.id;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public class SignatureResult {
        private final Set<InvalidMethod> methods = new HashSet<InvalidMethod>();
        private Set<InvalidConstant> overrideConstants_;

        SignatureResult() {
        }

        public void add(InvalidMethod el) {
            this.methods.add(el);
        }

        public void addConstant(InvalidConstant el) {
            if (this.overrideConstants_ == null) {
                this.overrideConstants_ = new HashSet<InvalidConstant>();
            }
            this.overrideConstants_.add(el);
        }

        public void check() {
            this.check(null);
        }

        private ErrorException getException(Environment env, InvalidMethod el, Messages.Item message) {
            return this.getException(env, el, message, false);
        }

        private ErrorException getException(Environment env, InvalidMethod el, Messages.Item message, boolean prototype) {
            FatalException e = prototype ? new FatalException(message.fetch(el.method.getPrototype().getSignatureString(false), el.method.getSignatureString(false)), el.method.getTrace()) : new FatalException(message.fetch(el.method.getSignatureString(false)), el.method.getTrace());
            return e;
        }

        public void check(Environment env) {
            if (this.overrideConstants_ != null) {
                for (InvalidConstant invalidConstant : this.overrideConstants_) {
                    if (env == null) continue;
                    env.error(ClassEntity.this.getTrace(), invalidConstant.errorType, Messages.ERR_CANNOT_INHERIT_OVERRIDE_CONSTANT, invalidConstant.constant.getName(), invalidConstant.prototype.getClazz().getName());
                }
            }
            HashSet<InvalidMethod> nonExists = null;
            for (InvalidMethod el : this.methods) {
                ErrorException e = null;
                switch (el.kind) {
                    case INVALID_SIGNATURE: {
                        MethodEntity prototype = el.method.getPrototype();
                        if (!prototype.isAbstractable()) {
                            while (prototype.prototype != null && prototype.prototype.isAbstractable()) {
                                prototype = prototype.prototype;
                            }
                        }
                        e = new FatalException(Messages.ERR_INVALID_METHOD_SIGNATURE.fetch(el.method.getSignatureString(false), prototype.getSignatureString(true)), el.method.getTrace());
                        break;
                    }
                    case MUST_STATIC: {
                        e = new FatalException(Messages.ERR_CANNOT_MAKE_STATIC_TO_NON_STATIC.fetch(el.method.getPrototype().getSignatureString(false), ClassEntity.this.getName()), el.method.getTrace());
                        break;
                    }
                    case MUST_NON_STATIC: {
                        e = new FatalException(Messages.ERR_CANNOT_MAKE_NON_STATIC_TO_STATIC.fetch(el.method.getPrototype().getSignatureString(false), ClassEntity.this.getName()), el.method.getTrace());
                        break;
                    }
                    case MAGIC_MUST_BE_PUBLIC: {
                        env.error(el.method.getTrace(), el.errorType, "The magic method %s must have public visibility", el.method.getSignatureString(false));
                        break;
                    }
                    case MUST_BE_PROTECTED: {
                        e = new FatalException(Messages.ERR_ACCESS_LEVEL_METHOD_MUST_BE_PROTECTED_OR_WEAKER.fetch(el.method.clazz.getName(), el.method.getName(), el.method.getPrototype().getClazz().getName()), el.method.getTrace());
                        break;
                    }
                    case MUST_BE_PUBLIC: {
                        e = new FatalException(Messages.ERR_ACCESS_LEVEL_METHOD_MUST_BE_PUBLIC.fetch(el.method.clazz.getName(), el.method.getName(), el.method.getPrototype().getClazz().getName()), el.method.getTrace());
                        break;
                    }
                    case FINAL_ABSTRACT: {
                        e = this.getException(env, el, Messages.ERR_CANNOT_USE_FINAL_ON_ABSTRACT);
                        break;
                    }
                    case FINAL: {
                        e = this.getException(env, el, Messages.ERR_CANNOT_OVERRIDE_FINAL_METHOD, true);
                        break;
                    }
                    case NON_ABSTRACT: {
                        e = this.getException(env, el, Messages.ERR_NON_ABSTRACT_METHOD_MUST_CONTAIN_BODY);
                        break;
                    }
                    case NON_ABSTRACTABLE: {
                        e = this.getException(env, el, Messages.ERR_ABSTRACT_METHOD_CANNOT_CONTAIN_BODY);
                        break;
                    }
                    case INVALID_ACCESS_FOR_INTERFACE: {
                        e = this.getException(env, el, Messages.ERR_ACCESS_TYPE_FOR_INTERFACE_METHOD);
                        break;
                    }
                    case NON_EXISTS: {
                        if (nonExists == null) {
                            nonExists = new HashSet<InvalidMethod>();
                        }
                        nonExists.add(el);
                    }
                }
                if (e == null) continue;
                if (env == null) {
                    throw e;
                }
                env.error(e.getTraceInfo(), el.errorType, e.getMessage(), new Object[0]);
            }
            if (nonExists != null) {
                StringBuilder stringBuilder = new StringBuilder();
                Iterator iterator = nonExists.iterator();
                int size = 0;
                ErrorType errorType = ErrorType.E_NOTICE;
                while (iterator.hasNext()) {
                    InvalidMethod el = (InvalidMethod)iterator.next();
                    if (el.errorType.value < errorType.value) {
                        errorType = el.errorType;
                    }
                    stringBuilder.append(el.method.getClazz().getName()).append("::").append(el.method.getName());
                    if (iterator.hasNext()) {
                        stringBuilder.append(", ");
                    }
                    ++size;
                }
                FatalException e = new FatalException(Messages.ERR_IMPLEMENT_METHOD.fetch(ClassEntity.this.getName(), size, stringBuilder), ClassEntity.this.getTrace());
                if (env == null) {
                    throw e;
                }
                env.error(e.getTraceInfo(), errorType, e.getMessage(), new Object[0]);
            }
        }
    }

    public class ExtendsResult {
        ClassEntity parent;
        SignatureResult methods;

        ExtendsResult(ClassEntity parent) {
            this.parent = parent;
            this.methods = new SignatureResult();
        }

        public void check(Environment env) {
            if (this.parent != null) {
                FatalException e;
                if (this.parent.isNotRuntime && !ClassEntity.this.isInternal()) {
                    e = new FatalException(Messages.ERR_CANNOT_USE_SYSTEM_CLASS.fetch(this.parent.getName(), ClassEntity.this.getName()), ClassEntity.this.trace);
                    if (env != null) {
                        env.error(e.getTraceInfo(), e.getType(), e.getMessage(), new Object[0]);
                    } else {
                        throw e;
                    }
                }
                if (this.parent.isFinal) {
                    e = new FatalException(Messages.ERR_CLASS_MAY_NOT_INHERIT_FINAL_CLASS.fetch(ClassEntity.this.getName(), this.parent.getName()), ClassEntity.this.trace);
                    if (env != null) {
                        env.error(e.getTraceInfo(), e.getType(), e.getMessage(), new Object[0]);
                    } else {
                        throw e;
                    }
                }
                if (ClassEntity.this.type == Type.CLASS && this.parent.type != Type.CLASS) {
                    e = new FatalException(Messages.ERR_CANNOT_EXTENDS.fetch(ClassEntity.this.getName(), this.parent.getName()), ClassEntity.this.trace);
                    if (env != null) {
                        env.error(e.getTraceInfo(), e.getType(), e.getMessage(), new Object[0]);
                    } else {
                        throw e;
                    }
                }
            }
            if (this.methods != null) {
                this.methods.check(env);
            }
        }
    }

    public class ImplementsResult {
        ClassEntity parent;
        SignatureResult signature;

        ImplementsResult(ClassEntity parent) {
            this.parent = parent;
            this.signature = new SignatureResult();
        }

        public void check(Environment env) {
            if (this.parent != null && this.parent.isNotRuntime && !ClassEntity.this.isInternal()) {
                FatalException e = new FatalException(Messages.ERR_CANNOT_USE_SYSTEM_CLASS.fetch(this.parent.getName(), ClassEntity.this.getName()), ClassEntity.this.trace);
                if (env != null) {
                    env.error(e.getTraceInfo(), e.getType(), e.getMessage(), new Object[0]);
                } else {
                    throw e;
                }
            }
            if (this.signature != null) {
                this.signature.check(env);
            }
        }
    }

    public class PropertyResult {
        private final Set<InvalidProperty> properties = new HashSet<InvalidProperty>();

        public void add(InvalidProperty prop) {
            this.properties.add(prop);
        }

        public void addError(InvalidProperty.Kind kind, PropertyEntity prop) {
            this.add(InvalidProperty.error(kind, prop));
        }

        public void check(Environment env) {
            for (InvalidProperty el : this.properties) {
                PhpException e = null;
                switch (el.kind) {
                    case MUST_BE_PROTECTED: {
                        e = new FatalException(Messages.ERR_ACCESS_LEVEL_MUST_BE_PROTECTED_OR_WEAKER.fetch(el.property.clazz.getName(), el.property.getName(), el.property.getPrototype().getClazz().getName()), el.property.getTrace());
                        break;
                    }
                    case MUST_BE_PUBLIC: {
                        e = new FatalException(Messages.ERR_ACCESS_LEVEL_MUST_BE_PUBLIC.fetch(el.property.clazz.getName(), el.property.getName(), el.property.getPrototype().getClazz().getName()), el.property.getTrace());
                        break;
                    }
                    case STATIC_AS_NON_STATIC: {
                        e = new FatalException(Messages.ERR_CANNOT_REDECLARE_STATIC_AS_NON_STATIC.fetch(el.property.getPrototype().getClazz().getName(), el.property.getPrototype().getName(), el.property.clazz.getName(), el.property.getName()), el.property.getTrace());
                        break;
                    }
                    case NON_STATIC_AS_STATIC: {
                        e = new FatalException(Messages.ERR_CANNOT_REDECLARE_NON_STATIC_AS_STATIC.fetch(el.property.getPrototype().getClazz().getName(), el.property.getPrototype().getName(), el.property.clazz.getName(), el.property.getName()), el.property.getTrace());
                    }
                }
                if (e == null) continue;
                if (env == null) {
                    throw e;
                }
                env.error(e.getTraceInfo(), el.errorType, e.getMessage(), new Object[0]);
            }
        }
    }

    public static class InvalidProperty {
        public final Kind kind;
        public final PropertyEntity property;
        public final ErrorType errorType;

        protected InvalidProperty(Kind kind, PropertyEntity property, ErrorType errorType) {
            this.kind = kind;
            this.property = property;
            this.errorType = errorType;
        }

        public static InvalidProperty warning(Kind kind, PropertyEntity property) {
            return new InvalidProperty(kind, property, ErrorType.E_WARNING);
        }

        public static InvalidProperty error(Kind kind, PropertyEntity property) {
            return new InvalidProperty(kind, property, ErrorType.E_ERROR);
        }

        public static InvalidProperty strict(Kind kind, PropertyEntity property) {
            return new InvalidProperty(kind, property, ErrorType.E_STRICT);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvalidProperty)) {
                return false;
            }
            InvalidProperty that = (InvalidProperty)o;
            return this.property.equals(that.property) && this.kind.equals((Object)that.kind);
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = 31 * result + this.property.hashCode();
            return result;
        }

        public static enum Kind {
            MUST_BE_PROTECTED,
            MUST_BE_PUBLIC,
            STATIC_AS_NON_STATIC,
            NON_STATIC_AS_STATIC;

        }
    }

    public static class InvalidMethod {
        public final Kind kind;
        public final MethodEntity method;
        public final ErrorType errorType;

        protected InvalidMethod(Kind kind, MethodEntity method, ErrorType errorType) {
            this.kind = kind;
            this.method = method;
            this.errorType = errorType;
        }

        public static InvalidMethod warning(Kind kind, MethodEntity method) {
            return new InvalidMethod(kind, method, ErrorType.E_WARNING);
        }

        public static InvalidMethod error(Kind kind, MethodEntity method) {
            return new InvalidMethod(kind, method, ErrorType.E_ERROR);
        }

        public static InvalidMethod strict(Kind kind, MethodEntity method) {
            return new InvalidMethod(kind, method, ErrorType.E_STRICT);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvalidMethod)) {
                return false;
            }
            InvalidMethod that = (InvalidMethod)o;
            return this.method.equals(that.method) && this.kind.equals((Object)that.kind);
        }

        public int hashCode() {
            int result = this.kind.hashCode();
            result = 31 * result + this.method.hashCode();
            return result;
        }

        public static enum Kind {
            NON_EXISTS,
            INVALID_SIGNATURE,
            MUST_STATIC,
            MUST_NON_STATIC,
            MAGIC_MUST_BE_PUBLIC,
            MUST_BE_PUBLIC,
            MUST_BE_PROTECTED,
            FINAL,
            NON_ABSTRACT,
            NON_ABSTRACTABLE,
            INVALID_ACCESS_FOR_INTERFACE,
            FINAL_ABSTRACT,
            OVERRIDE_CONSTANTS;

        }
    }

    public static class InvalidConstant {
        public final ConstantEntity constant;
        public final ConstantEntity prototype;
        public final ErrorType errorType;

        protected InvalidConstant(ConstantEntity constant, ConstantEntity prototype, ErrorType errorType) {
            this.constant = constant;
            this.errorType = errorType;
            this.prototype = prototype;
        }

        public static InvalidConstant error(ConstantEntity constant, ConstantEntity prototype) {
            return new InvalidConstant(constant, prototype, ErrorType.E_ERROR);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof InvalidConstant)) {
                return false;
            }
            InvalidConstant that = (InvalidConstant)o;
            return this.constant.equals(that.constant);
        }

        public int hashCode() {
            return this.constant.hashCode();
        }
    }

    private static interface SetterCallback {
        public Memory invoke(Memory var1, Memory var2);
    }

    public static enum Type {
        CLASS,
        INTERFACE,
        TRAIT;

    }
}

