/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import java.util.Locale;
import php.runtime.Memory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.support.MemoryStringUtils;

public class DoubleMemory
extends Memory {
    double value;

    public DoubleMemory(double value) {
        super(Memory.Type.DOUBLE);
        this.value = value;
    }

    public static Memory valueOf(double value) {
        return new DoubleMemory(value);
    }

    public static Memory valueOf(float value) {
        return new DoubleMemory(value);
    }

    @Override
    public long toLong() {
        if (this.value == Double.POSITIVE_INFINITY) {
            return 0L;
        }
        return (long)this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public boolean toBoolean() {
        return this.value != 0.0;
    }

    @Override
    public String toString() {
        block14: {
            int digits;
            int pr;
            int exp;
            block15: {
                long longValue = (long)this.value;
                double abs = this.value < 0.0 ? -this.value : this.value;
                exp = (int)Math.log10(abs);
                if ((double)longValue == this.value && exp < 18) {
                    return longValue > Integer.MAX_VALUE ? Double.toString(longValue) : String.valueOf(longValue);
                }
                if (-5 >= exp || exp >= 18) break block14;
                pr = 13;
                char[] tmp = Double.toString(this.value).toCharArray();
                block5: for (int i = 0; i < tmp.length; ++i) {
                    switch (tmp[i]) {
                        case '-': {
                            if (i == 0) {
                                continue block5;
                            }
                            break block15;
                        }
                        case '0': {
                            ++pr;
                        }
                        case '.': {
                            continue block5;
                        }
                    }
                }
            }
            if ((digits = pr - exp) > pr) {
                digits = pr;
            } else if (digits < 0) {
                digits = 0;
            }
            String v = String.format(Locale.ENGLISH, "%." + digits + "f", this.value);
            int len = v.length();
            int nonzero = -1;
            boolean dot = false;
            for (int i = len - 1; i >= 0; --i) {
                char ch = v.charAt(i);
                if (ch == '.') {
                    dot = true;
                }
                if (ch == '0' || nonzero >= 0) continue;
                nonzero = ch == '.' ? i - 1 : i;
            }
            if (dot && nonzero > 0) {
                return v.substring(0, nonzero + 1);
            }
            return v;
        }
        return String.format(Locale.ENGLISH, "%.13E", this.value);
    }

    @Override
    public Memory inc() {
        return new DoubleMemory(this.value + 1.0);
    }

    @Override
    public Memory dec() {
        return new DoubleMemory(this.value - 1.0);
    }

    @Override
    public Memory negative() {
        return new DoubleMemory(-this.value);
    }

    @Override
    public Memory toNumeric() {
        return this;
    }

    @Override
    public Memory plus(Memory memory) {
        switch (memory.type) {
            case INT: {
                return new DoubleMemory(this.value + (double)((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory(this.value + ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.plus(memory.toValue());
            }
        }
        return this.plus(memory.toNumeric());
    }

    @Override
    public Memory minus(Memory memory) {
        switch (memory.type) {
            case INT: {
                return new DoubleMemory(this.value - (double)((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory(this.value - ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.minus(memory.toValue());
            }
        }
        return this.minus(memory.toNumeric());
    }

    @Override
    public Memory mul(Memory memory) {
        switch (memory.type) {
            case INT: {
                return new DoubleMemory(this.value * (double)((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory(this.value * ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.mul(memory.toValue());
            }
        }
        return this.mul(memory.toNumeric());
    }

    @Override
    public Memory pow(Memory memory) {
        switch (memory.type) {
            case INT: {
                return new DoubleMemory(Math.pow(this.value, ((LongMemory)memory).value));
            }
            case DOUBLE: {
                return new DoubleMemory(Math.pow(this.value, ((LongMemory)memory).value));
            }
            case REFERENCE: {
                return this.mul(memory.toImmutable());
            }
        }
        return this.pow(memory.toNumeric());
    }

    @Override
    public Memory div(Memory memory) {
        switch (memory.type) {
            case INT: {
                if (((LongMemory)memory).value == 0L) {
                    return FALSE;
                }
                return new DoubleMemory(this.value / (double)((LongMemory)memory).value);
            }
            case DOUBLE: {
                if (((DoubleMemory)memory).value == 0.0) {
                    return FALSE;
                }
                return new DoubleMemory(this.value / ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.div(memory.toValue());
            }
        }
        return this.div(memory.toNumeric());
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case INT: {
                return DoubleMemory.almostEqual(this.value, ((LongMemory)memory).value);
            }
            case DOUBLE: {
                return DoubleMemory.almostEqual(this.value, ((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return DoubleMemory.almostEqual(this.value, memory.toDouble());
    }

    @Override
    public boolean identical(Memory memory) {
        return memory.getRealType() == Memory.Type.DOUBLE && ((DoubleMemory)memory).value == this.value;
    }

    @Override
    public boolean equal(double value) {
        return DoubleMemory.almostEqual(this.value, value);
    }

    @Override
    public boolean equal(long value) {
        return DoubleMemory.almostEqual(this.value, value);
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public boolean not() {
        return DoubleMemory.almostEqual(this.value, 0.0);
    }

    @Override
    public String concat(Memory memory) {
        return this.toString().concat(memory.toString());
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return this.value < ((DoubleMemory)memory).value;
            }
            case INT: {
                return this.value < (double)((LongMemory)memory).value;
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.smaller(memory.toDouble());
    }

    @Override
    public boolean smallerEq(Memory memory) {
        return this.smaller(memory) || this.equal(memory);
    }

    @Override
    public boolean greater(Memory memory) {
        return memory.smaller(this);
    }

    @Override
    public boolean greaterEq(Memory memory) {
        return memory.smallerEq(this);
    }

    @Override
    public Memory minus(long value) {
        return new DoubleMemory(this.value - (double)value);
    }

    @Override
    public Memory plus(long value) {
        return new DoubleMemory(this.value + (double)value);
    }

    @Override
    public Memory mul(long value) {
        return new DoubleMemory(this.value * (double)value);
    }

    @Override
    public Memory mul(boolean value) {
        if (value) {
            return this;
        }
        return CONST_DOUBLE_0;
    }

    @Override
    public Memory plus(boolean value) {
        if (value) {
            return new DoubleMemory(this.value + 1.0);
        }
        return this;
    }

    @Override
    public Memory div(long value) {
        if (value == 0L) {
            return FALSE;
        }
        return new DoubleMemory(this.value / (double)value);
    }

    @Override
    public Memory div(double value) {
        if (value == 0.0) {
            return FALSE;
        }
        return new DoubleMemory(this.value / value);
    }

    @Override
    public Memory div(boolean value) {
        if (!value) {
            return FALSE;
        }
        return this;
    }

    public static boolean almostEqual(double o1, double o2, double eps) {
        return Math.abs(o1 - o2) < eps;
    }

    public static boolean almostEqual(double o1, double o2) {
        return DoubleMemory.almostEqual(o1, o2, 1.0E-10);
    }

    public int hashCode() {
        long temp = (long)this.value;
        return (int)(temp ^ temp >>> 32);
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return MemoryStringUtils.getBinaryBytes(this);
    }
}

