/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.env.CompileScope;
import php.runtime.env.ConcurrentEnvironment;
import php.runtime.env.Environment;
import php.runtime.env.ModuleManager;
import php.runtime.env.SplClassLoader;
import php.runtime.ext.core.classes.WrapModule;
import php.runtime.ext.core.classes.WrapSourceMap;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.loader.sourcemap.SourceMap;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;

@Reflection.Name(value="php\\lang\\Environment")
public class WrapEnvironment
extends BaseObject {
    public static final int CONCURRENT = 1;
    public static final int HOT_RELOAD = 2;
    protected Environment environment;
    protected Invoker onMessage;

    public WrapEnvironment(Environment env, Environment wrapEnv) {
        super(env);
        this.setEnvironment(wrapEnv);
    }

    public WrapEnvironment(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Environment getWrapEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="parent", nativeType=WrapEnvironment.class, optional=@Reflection.Optional(value="NULL")), @Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0", type=HintType.INT))})
    public Memory __construct(Environment env, Memory ... args) {
        boolean concurrent;
        CompileScope scope = env.scope;
        int flags = args[1].toInteger();
        boolean hotReload = (flags & 2) == 2;
        boolean bl = concurrent = (flags & 1) == 1;
        if (hotReload) {
            scope = new CompileScope(scope);
        }
        if (args[0].isNull()) {
            if (concurrent) {
                this.setEnvironment(new ConcurrentEnvironment(scope, env.getDefaultBuffer().getOutput()));
            } else {
                this.setEnvironment(new Environment(scope, env.getDefaultBuffer().getOutput()));
            }
        } else {
            if (hotReload) {
                env.exception("Environment cannot be hot-reloadable with parent", new Object[0]);
            }
            if (concurrent) {
                this.setEnvironment(new ConcurrentEnvironment(args[0].toObject(WrapEnvironment.class).getWrapEnvironment()));
            } else {
                this.setEnvironment(new Environment(args[0].toObject(WrapEnvironment.class).getWrapEnvironment()));
            }
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="runnable")})
    public Memory execute(Environment env, Memory ... args) throws Throwable {
        Invoker invoker = Invoker.valueOf(this.environment, null, args[0]);
        if (invoker == null) {
            env.exception("Argument 1 must be callable in environment", new Object[0]);
            return Memory.NULL;
        }
        invoker.setTrace(env.trace());
        return invoker.call(new Memory[0]);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="sourceMap", nativeType=WrapSourceMap.class)})
    public Memory registerSourceMap(Environment env, Memory ... args) {
        this.environment.registerSourceMap((SourceMap)args[0].toObject(WrapSourceMap.class).getWrappedObject());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="sourceMap", nativeType=WrapSourceMap.class)})
    public Memory unregisterSourceMap(Environment env, Memory ... args) {
        this.environment.unregisterSourceMap((SourceMap)args[0].toObject(WrapSourceMap.class).getWrappedObject());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="className")})
    public Memory exportClass(Environment env, Memory ... args) throws Throwable {
        ClassEntity classEntity = this.environment.fetchClass(args[0].toString());
        if (classEntity == null) {
            env.exception(Messages.ERR_CLASS_NOT_FOUND.fetch(args[0]), new Object[0]);
            return Memory.NULL;
        }
        env.registerClass(classEntity);
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory importAutoLoaders(Environment env, Memory ... args) {
        for (SplClassLoader loader : env.getClassLoaders()) {
            this.environment.registerAutoloader(loader.forEnvironment(this.environment), false);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="className")})
    public Memory importClass(Environment env, Memory ... args) throws Throwable {
        ClassEntity classEntity = env.fetchClass(args[0].toString());
        if (classEntity == null) {
            env.exception(Messages.ERR_CLASS_NOT_FOUND.fetch(args[0]), new Object[0]);
            return Memory.NULL;
        }
        this.environment.registerClass(classEntity);
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="functionName")})
    public Memory importFunction(Environment env, Memory ... args) {
        FunctionEntity functionEntity = env.fetchFunction(args[0].toString());
        if (functionEntity == null) {
            env.exception(Messages.ERR_FUNCTION_NOT_FOUND.fetch(args[0]), new Object[0]);
            return Memory.NULL;
        }
        this.environment.registerFunction(functionEntity);
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="functionName")})
    public Memory exportFunction(Environment env, Memory ... args) {
        FunctionEntity functionEntity = this.environment.fetchFunction(args[0].toString());
        if (functionEntity == null) {
            env.exception(Messages.ERR_FUNCTION_NOT_FOUND.fetch(args[0]), new Object[0]);
            return Memory.NULL;
        }
        env.registerFunction(functionEntity);
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="name"), @Reflection.Arg(value="value"), @Reflection.Arg(value="caseSensitive", optional=@Reflection.Optional(value="true", type=HintType.BOOLEAN))})
    public Memory defineConstant(Environment env, Memory ... args) {
        Memory val = args[1].toValue();
        if (val.isArray() || val.isObject()) {
            env.exception("Argument 2 must be a scalar value", new Object[0]);
        }
        if (!this.environment.defineConstant(args[0].toString(), val, args[2].toBoolean())) {
            env.exception("Constant '%s' already registered", args[0]);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback")})
    public Memory onOutput(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            Invoker invoker = Invoker.valueOf(this.environment, null, args[0]);
            if (invoker == null) {
                env.exception("Argument 1 must be callable in environment", new Object[0]);
                return Memory.NULL;
            }
            invoker.setTrace(env.trace());
            this.environment.getDefaultBuffer().setCallback(args[0], invoker);
        } else {
            this.environment.getDefaultBuffer().setCallback(null);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback")})
    public Memory onMessage(Environment env, Memory ... args) {
        Invoker invoker = Invoker.valueOf(this.environment, null, args[0]);
        if (invoker == null) {
            env.exception("Argument 1 must be callable in environment", new Object[0]);
            return Memory.NULL;
        }
        this.onMessage = invoker;
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="message")})
    public Memory sendMessage(Environment env, Memory ... args) throws Throwable {
        if (this.onMessage == null) {
            env.exception("Environment cannot receive messages, onMessage callback is NULL", new Object[0]);
            return Memory.NULL;
        }
        return this.onMessage.call(args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="path")})
    public Memory findModule(Environment env, Memory ... args) throws Throwable {
        ModuleManager moduleManager = this.environment.getModuleManager();
        boolean hasModule = moduleManager.hasModule(args[0].toString());
        if (hasModule) {
            return ObjectMemory.valueOf(new WrapModule(env, moduleManager.fetchModule(args[0].toString())));
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __destruct(Environment env, Memory ... args) throws Throwable {
        this.environment.doFinal();
        return Memory.NULL;
    }

    @Reflection.Signature
    public static Memory current(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapEnvironment(env, env));
    }
}

