/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import java.util.Date;
import java.util.TimeZone;
import php.runtime.Memory;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.StringMemory;

public class DateFunctions
extends FunctionsContainer {
    public static final int MSEC_IN_MIN = 60000;

    public static Memory microtime(boolean getAsFloat) {
        double now = (double)System.currentTimeMillis() / 1000.0;
        int s = (int)now;
        return getAsFloat ? new DoubleMemory(now) : new StringMemory(Math.round((now - (double)s) * 1000.0) / 1000L + " " + s);
    }

    public static Memory microtime() {
        return DateFunctions.microtime(false);
    }

    public static Memory gettimeofday(boolean getAsFloat) {
        long msec_time = System.currentTimeMillis();
        if (getAsFloat) {
            double now = (double)msec_time / 1000.0;
            return new DoubleMemory(now);
        }
        ArrayMemory result = new ArrayMemory();
        TimeZone timeZone = TimeZone.getDefault();
        long sec = msec_time / 1000L;
        long usec = msec_time % 1000L * 1000L;
        long minuteswest = -timeZone.getOffset(msec_time) / 60000;
        boolean is_dst = timeZone.inDaylightTime(new Date(msec_time));
        result.refOfIndex("sec").assign(sec);
        result.refOfIndex("usec").assign(usec);
        result.refOfIndex("minuteswest").assign(minuteswest);
        result.refOfIndex("dsttime").assign(is_dst ? 1L : 0L);
        return result.toConstant();
    }

    public static Memory gettimeofday() {
        return DateFunctions.gettimeofday(false);
    }
}

