/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes.text;

import com.sun.javafx.tk.Toolkit;
import java.io.InputStream;
import java.util.List;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseWrapper;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\text\\UXFont")
public class UXFont
extends BaseWrapper<Font> {
    public UXFont(Environment env, Font wrappedObject) {
        super(env, wrappedObject);
    }

    public UXFont(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public void __construct(double size) {
        this.__wrappedObject = new Font(size);
    }

    @Reflection.Signature
    public void __construct(double size, String name) {
        this.__wrappedObject = new Font(name, size);
    }

    @Reflection.Signature
    public static List<String> getFamilies() {
        return Font.getFamilies();
    }

    @Reflection.Signature
    public static List<String> getFontNames() {
        return Font.getFontNames();
    }

    @Reflection.Signature
    public static List<String> getFontNames(String family) {
        return Font.getFontNames((String)family);
    }

    @Reflection.Signature
    public static Font getDefault() {
        return Font.getDefault();
    }

    @Reflection.Signature
    public Font withItalic() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), null, true);
    }

    @Reflection.Signature
    public Font withRegular() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), null, false);
    }

    @Reflection.Signature
    public Font withBold() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), true, null);
    }

    @Reflection.Signature
    public Font withThin() {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), ((Font)this.getWrappedObject()).getSize(), false, null);
    }

    @Reflection.Signature
    public Font withName(String name) {
        return this.withNameAndSize(name, ((Font)this.getWrappedObject()).getSize());
    }

    @Reflection.Signature
    public Font withSize(int size) {
        return this.withNameAndSize(((Font)this.getWrappedObject()).getName(), size);
    }

    @Reflection.Signature
    public Font withNameAndSize(String name, double size) {
        return this.withNameAndSize(name, size, null, null);
    }

    protected Font withNameAndSize(String name, double size, Boolean bold, Boolean italic) {
        FontPosture posture;
        Font font = (Font)this.getWrappedObject();
        FontWeight weight = bold != null && bold != false ? FontWeight.BOLD : FontWeight.THIN;
        FontPosture fontPosture = posture = italic != null && italic != false ? FontPosture.ITALIC : FontPosture.REGULAR;
        if (font.getStyle().toUpperCase().contains("BOLD")) {
            weight = FontWeight.BOLD;
        }
        if (font.getStyle().toUpperCase().contains("ITALIC")) {
            posture = FontPosture.ITALIC;
        }
        return Font.font((String)name, (FontWeight)weight, (FontPosture)posture, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size) {
        return Font.font((String)family, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size, FontWeight fontWeight) {
        return Font.font((String)family, (FontWeight)fontWeight, (double)size);
    }

    @Reflection.Signature
    public static Font of(String family, int size, FontWeight fontWeight, boolean italic) {
        return Font.font((String)family, (FontWeight)fontWeight, (FontPosture)(italic ? FontPosture.ITALIC : FontPosture.REGULAR), (double)size);
    }

    @Reflection.Signature
    public static Font load(InputStream stream, double size) {
        return Font.loadFont((InputStream)stream, (double)size);
    }

    @Reflection.Getter
    public float getLineHeight() {
        return Toolkit.getToolkit().getFontLoader().getFontMetrics((Font)this.getWrappedObject()).getLineHeight();
    }

    public static double getLineHeight(Font font) {
        Text text = new Text("A");
        text.setFont(font);
        return text.getLayoutBounds().getHeight();
    }

    @Reflection.Signature
    public double calculateTextWidth(String atext) {
        Text text = new Text(atext);
        text.setFont((Font)this.getWrappedObject());
        return text.getLayoutBounds().getWidth();
    }

    public static double calculateTextWidth(String atext, Font font) {
        Text text = new Text(atext);
        text.setFont(font);
        return text.getLayoutBounds().getWidth();
    }

    static interface WrappedInterface {
        @Reflection.Property
        public String name();

        @Reflection.Property
        public String family();

        @Reflection.Property
        public String size();

        @Reflection.Property
        public String style();
    }
}

