/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.TextInputDialog;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\UXDialog")
public class UXDialog
extends BaseObject {
    public UXDialog(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public static void show(String text) {
        UXDialog.show(text, Alert.AlertType.INFORMATION);
    }

    @Reflection.Signature
    public static void show(final String text, final Alert.AlertType type) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                UXDialog.showAndWait(text, type);
            }
        });
    }

    @Reflection.Signature
    public static String showAndWait(String text, Alert.AlertType type) {
        Alert alert = new Alert(type);
        alert.setResizable(false);
        alert.setContentText(text);
        alert.setHeaderText(null);
        ButtonType result = alert.showAndWait().orElse(null);
        return result == null ? null : result.getButtonData().getTypeCode();
    }

    @Reflection.Signature
    public static String showAndWait(String text) {
        return UXDialog.showAndWait(text, Alert.AlertType.INFORMATION);
    }

    @Reflection.Signature
    public static String showExpanded(String text, Node content, boolean expanded) {
        return UXDialog.showExpanded(text, content, expanded, Alert.AlertType.NONE);
    }

    @Reflection.Signature
    public static String showExpanded(String text, Node content, boolean expanded, Alert.AlertType type) {
        Alert alert = new Alert(type);
        alert.setTitle(null);
        alert.setHeaderText(text);
        alert.getDialogPane().setExpanded(expanded);
        alert.getDialogPane().setExpandableContent(content);
        ButtonType result = alert.showAndWait().orElse(null);
        return result == null ? null : result.getButtonData().getTypeCode();
    }

    @Reflection.Signature
    public static boolean confirm(String question) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setResizable(false);
        alert.setContentText(question);
        alert.setHeaderText(null);
        ButtonType result = alert.showAndWait().orElse(null);
        return result != ButtonType.CANCEL;
    }

    @Reflection.Signature
    public static String input(String text) {
        return UXDialog.input(text, "");
    }

    @Reflection.Signature
    public static String input(String text, String defaultValue) {
        TextInputDialog dialog = new TextInputDialog(defaultValue);
        dialog.setContentText(text);
        Optional result = dialog.showAndWait();
        if (result.isPresent()) {
            return (String)result.get();
        }
        return null;
    }
}

