/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.value;

import java.util.ArrayList;
import java.util.List;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayGetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.ArrayPushExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.CallableExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import org.develnext.jphp.core.tokenizer.token.stmt.ExprStmtToken;

public class ListExprToken
extends ValueExprToken
implements CallableExprToken {
    protected final List<Variable> variables = new ArrayList<Variable>();
    protected ExprStmtToken value;

    public ListExprToken(TokenMeta meta) {
        super(meta, TokenType.T_LIST);
    }

    public ExprStmtToken getValue() {
        return this.value;
    }

    public void setValue(ExprStmtToken value) {
        this.value = value;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public Variable addVariable(ExprStmtToken v, int index, List<Integer> indexes) {
        Variable var = new Variable(v, index, indexes);
        this.variables.add(var);
        return var;
    }

    public void addList(ListExprToken list) {
        for (Variable v : list.variables) {
            this.variables.add(v);
        }
    }

    @Override
    public boolean isNamedToken() {
        return true;
    }

    public class Variable {
        public final ExprStmtToken var;
        public final int index;
        public final List<Integer> indexes;

        public Variable(ExprStmtToken var, int index, List<Integer> indexes) {
            this.var = var;
            this.index = index;
            this.indexes = indexes;
        }

        public boolean isArrayPush() {
            return this.var.getLast() instanceof ArrayPushExprToken;
        }

        public boolean isVariable() {
            return this.var.isSingle() && this.var.getSingle() instanceof VariableExprToken;
        }

        public boolean isArray() {
            return this.var.getLast() instanceof ArrayGetExprToken;
        }

        public boolean isDynamicProperty() {
            return this.var.getLast() instanceof DynamicAccessExprToken;
        }

        public boolean isStaticProperty() {
            return this.var.getLast() instanceof StaticAccessExprToken;
        }

        public String getVariableName() {
            return this.isVariable() ? ((VariableExprToken)this.var.getSingle()).getName() : null;
        }
    }
}

