/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public class FalseMemory
extends Memory {
    public static final FalseMemory INSTANCE = new FalseMemory();

    protected FalseMemory() {
        super(Memory.Type.BOOL);
    }

    FalseMemory(Memory.Type type) {
        super(type);
    }

    @Override
    public long toLong() {
        return 0L;
    }

    @Override
    public double toDouble() {
        return 0.0;
    }

    @Override
    public boolean toBoolean() {
        return false;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public Memory inc() {
        return this;
    }

    @Override
    public Memory dec() {
        return this;
    }

    @Override
    public Memory negative() {
        return CONST_INT_0;
    }

    @Override
    public Memory toNumeric() {
        return Memory.CONST_INT_0;
    }

    @Override
    public boolean identical(Memory memory) {
        return memory.toValue() == FALSE;
    }

    @Override
    public boolean equal(long value) {
        return value == 0L;
    }

    @Override
    public boolean equal(double value) {
        return value == 0.0;
    }

    @Override
    public boolean equal(boolean value) {
        return !value;
    }

    @Override
    public boolean equal(String value) {
        return value.isEmpty() || value.equals("0");
    }

    @Override
    public boolean notEqual(long value) {
        return value != 0L;
    }

    @Override
    public boolean notEqual(double value) {
        return value != 0.0;
    }

    @Override
    public boolean notEqual(boolean value) {
        return value;
    }

    @Override
    public boolean notEqual(String value) {
        return !value.isEmpty() && !value.equals("0");
    }

    @Override
    public Memory plus(Memory memory) {
        switch (memory.type) {
            case INT: 
            case DOUBLE: {
                return memory;
            }
            case REFERENCE: {
                return this.plus(memory.toValue());
            }
        }
        return memory.toNumeric();
    }

    @Override
    public Memory minus(Memory memory) {
        switch (memory.type) {
            case INT: {
                return new LongMemory(-((LongMemory)memory).value);
            }
            case DOUBLE: {
                return new DoubleMemory(-((DoubleMemory)memory).value);
            }
            case REFERENCE: {
                return this.minus(memory.toValue());
            }
        }
        return this.minus(memory.toNumeric());
    }

    @Override
    public Memory mul(Memory memory) {
        switch (memory.type) {
            case INT: {
                return Memory.CONST_INT_0;
            }
            case DOUBLE: {
                return Memory.CONST_DOUBLE_0;
            }
            case STRING: {
                return this.mul(memory.toNumeric());
            }
            case REFERENCE: {
                return this.mul(memory.toValue());
            }
        }
        return Memory.CONST_INT_0;
    }

    @Override
    public Memory pow(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return Memory.CONST_INT_0;
            }
            case REFERENCE: {
                return this.pow(memory.toImmutable());
            }
        }
        return Memory.CONST_INT_0;
    }

    @Override
    public Memory div(Memory memory) {
        switch (memory.type) {
            case DOUBLE: {
                return CONST_DOUBLE_0;
            }
            case INT: {
                if (((LongMemory)memory).value == 0L) {
                    throw new RuntimeException("Zero division denied");
                }
                return CONST_INT_0;
            }
            case REFERENCE: {
                return this.div(memory.toValue());
            }
            case STRING: {
                return this.div(memory.toNumeric());
            }
        }
        return CONST_INT_0;
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case INT: {
                return ((LongMemory)memory).value == 0L;
            }
            case NULL: {
                return true;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return !memory.toBoolean();
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public String concat(Memory memory) {
        switch (memory.type) {
            case REFERENCE: {
                return this.concat(memory.toValue());
            }
        }
        return memory.toString();
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case INT: {
                return 0L < ((LongMemory)memory).value;
            }
            case DOUBLE: {
                return 0.0 < ((DoubleMemory)memory).value;
            }
            case BOOL: {
                return 0L < memory.toLong();
            }
            case NULL: {
                return false;
            }
            case REFERENCE: {
                return this.smaller(memory.toValue());
            }
        }
        return this.smaller(memory.toBoolean());
    }

    @Override
    public boolean smallerEq(Memory memory) {
        switch (memory.type) {
            case INT: {
                return 0L <= ((LongMemory)memory).value;
            }
            case DOUBLE: {
                return 0.0 <= ((DoubleMemory)memory).value;
            }
            case BOOL: {
                return 0L <= memory.toLong();
            }
            case NULL: {
                return true;
            }
            case REFERENCE: {
                return this.smallerEq(memory.toValue());
            }
        }
        return this.smallerEq(memory.toBoolean());
    }

    @Override
    public boolean greater(Memory memory) {
        switch (memory.type) {
            case STRING: {
                String str = memory.toString();
                if (str.isEmpty()) {
                    return false;
                }
                Memory value = StringMemory.toNumeric(str, true, null);
                return value != null && 0L > value.toLong();
            }
            case REFERENCE: {
                return this.greater(memory.toValue());
            }
        }
        return 0L > memory.toLong();
    }

    @Override
    public boolean greaterEq(Memory memory) {
        switch (memory.type) {
            case STRING: {
                String str = memory.toString();
                if (str.isEmpty()) {
                    return true;
                }
                Memory value = StringMemory.toNumeric(str, true, null);
                return value != null && 0L >= value.toLong();
            }
            case REFERENCE: {
                return this.greater(memory.toValue());
            }
        }
        return 0L >= memory.toLong();
    }

    @Override
    public Memory minus(long value) {
        return new LongMemory(-value);
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return new byte[0];
    }

    @Override
    public boolean identical(long value) {
        return false;
    }

    @Override
    public boolean identical(double value) {
        return false;
    }

    @Override
    public boolean identical(boolean value) {
        return !value;
    }

    @Override
    public boolean identical(String value) {
        return false;
    }

    @Override
    public Invoker toInvoker(Environment env) {
        return null;
    }
}

