/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import php.runtime.Memory;
import php.runtime.env.TraceInfo;
import php.runtime.memory.StringMemory;

public class BinaryMemory
extends StringMemory {
    private byte[] bytes;

    public BinaryMemory(String value) {
        super((String)null);
        this.bytes = value.getBytes();
    }

    public BinaryMemory(char ch) {
        super((String)null);
        this.bytes = String.valueOf(ch).getBytes();
    }

    public BinaryMemory(byte ... bytes) {
        super((String)null);
        this.bytes = bytes;
    }

    public static Memory valueOf(String value) {
        return new BinaryMemory(value);
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return this.bytes;
    }

    @Override
    public char toChar() {
        return (char)((this.bytes == null || this.bytes.length == 0 ? 0 : this.bytes[0]) & 0xFF);
    }

    @Override
    public String toString() {
        return new String(this.bytes, Charset.forName("UTF-8"));
    }

    @Override
    public String toBinaryString() {
        StringBuilder sb = new StringBuilder(this.bytes.length);
        for (byte e : this.bytes) {
            sb.append((char)(e & 0xFF));
        }
        return sb.toString();
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        int i = index.toInteger();
        if (i < 0 || i >= this.bytes.length) {
            return FALSE;
        }
        return new StringMemory((char)(this.bytes[i] & 0xFF));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        int i = (int)index;
        if (i < 0 || i >= this.bytes.length) {
            return FALSE;
        }
        return new StringMemory((char)(this.bytes[i] & 0xFF));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        int i = (int)index;
        if (i < 0 || i >= this.bytes.length) {
            return FALSE;
        }
        return new StringMemory((char)(this.bytes[i] & 0xFF));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        int i;
        int n = i = index ? 1 : 0;
        if (i < 0 || i >= this.bytes.length) {
            return FALSE;
        }
        return new StringMemory((char)(this.bytes[i] & 0xFF));
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        Memory i = StringMemory.toLong(index);
        if (i == null) {
            return FALSE;
        }
        if (i.toInteger() < 0 || i.toInteger() >= this.bytes.length) {
            return FALSE;
        }
        return new StringMemory((char)(this.bytes[i.toInteger()] & 0xFF));
    }

    @Override
    public boolean toBoolean() {
        return this.bytes != null && this.bytes.length > 0 && this.bytes[0] != 48;
    }
}

