/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.common.collections.map.LinkedMap;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.RecursiveException;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.StdClass;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.KeyValueMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.memory.helper.ArrayKeyMemory;
import php.runtime.memory.helper.ArrayValueMemory;
import php.runtime.memory.helper.ShortcutMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.memory.support.MemoryStringUtils;
import php.runtime.memory.support.MemoryUtils;
import php.runtime.reflection.support.ReflectionUtils;

public class ArrayMemory
extends Memory
implements Iterable<ReferenceMemory> {
    protected long lastLongIndex;
    protected int size;
    protected int copies;
    protected ArrayMemory original;
    protected List<ReferenceMemory> list;
    protected LinkedMap<Object, ReferenceMemory> map;
    protected ForeachIterator foreachIterator;

    public ArrayMemory(boolean asMap) {
        super(Memory.Type.ARRAY);
        if (asMap) {
            this.convertToMap();
        } else {
            this.list = new ArrayList<ReferenceMemory>();
        }
        this.lastLongIndex = -1L;
    }

    public ArrayMemory() {
        this(false);
    }

    @Deprecated
    public ArrayMemory(Collection collection) {
        this();
        for (Object el : collection) {
            if (el == null) {
                this.add(NULL);
                continue;
            }
            MemoryOperation operation = MemoryOperation.get(el.getClass(), null);
            if (operation == null) continue;
            this.add(operation.unconvertNoThow(null, null, el));
        }
    }

    @Deprecated
    public ArrayMemory(Object ... array) {
        this();
        for (Object el : array) {
            if (el == null) {
                this.list.add(new ReferenceMemory());
                continue;
            }
            MemoryOperation operation = MemoryOperation.get(el.getClass(), null);
            if (operation == null) continue;
            this.list.add(new ReferenceMemory(operation.unconvertNoThow(null, null, el)));
        }
        this.size = array.length;
        this.lastLongIndex = this.size - 1;
    }

    @Deprecated
    public ArrayMemory(boolean toImmutable, Memory ... array) {
        this();
        if (array != null) {
            for (Memory el : array) {
                this.list.add(new ReferenceMemory(toImmutable ? el.toImmutable() : el));
            }
            this.size = array.length;
            this.lastLongIndex = this.size - 1;
        }
    }

    @Deprecated
    public ArrayMemory(String[] array) {
        this();
        for (String el : array) {
            this.list.add(new ReferenceMemory(StringMemory.valueOf(el)));
        }
        this.size = array.length;
        this.lastLongIndex = this.size - 1;
    }

    @Deprecated
    public ArrayMemory(Map map) {
        this();
        for (Object key : map.keySet()) {
            Object el = map.get(key);
            this.put(ArrayMemory.toKey(MemoryUtils.valueOf(key)), MemoryUtils.valueOf(el));
        }
    }

    public static Memory valueOf() {
        return new ArrayMemory();
    }

    public static ArrayMemory valueOfRef(ArrayMemory value) {
        if (value == null) {
            return new ArrayMemory();
        }
        return value;
    }

    public Set<Object> keySet() {
        if (this.list != null) {
            HashSet<Object> set = new HashSet<Object>(this.size());
            for (int i = 0; i < this.size(); ++i) {
                set.add(i);
            }
            return set;
        }
        return this.map.keySet();
    }

    public ArrayMemory duplicate() {
        ArrayMemory result = new ArrayMemory();
        result.lastLongIndex = this.lastLongIndex;
        result.size = this.size;
        if (this.list != null) {
            for (ReferenceMemory item : this.list) {
                result.list.add(item.duplicate());
            }
        } else {
            result.list = null;
            result.map = new LinkedMap<Object, ReferenceMemory>(this.map);
            for (Map.Entry entry : this.map.entrySet()) {
                result.map.put(entry.getKey(), ((ReferenceMemory)entry.getValue()).duplicate());
            }
        }
        return result;
    }

    public ArrayMemory checkCopied() {
        if (this.original != null || this.copies > 0) {
            ArrayMemory dup = this.duplicate();
            this.map = dup.map;
            this.list = dup.list;
            this.lastLongIndex = dup.lastLongIndex;
            if (this.original == null) {
                --this.copies;
            } else {
                --this.original.copies;
                this.original = null;
                this.copies = 0;
            }
            return dup;
        }
        return null;
    }

    public static Object toKey(Memory key) {
        switch (key.type) {
            case STRING: {
                String key1 = key.toString();
                Memory number = StringMemory.toLong(key1);
                if (number == null) {
                    return key1;
                }
                return number;
            }
            case INT: {
                return key;
            }
            case NULL: {
                return Memory.CONST_EMPTY_STRING;
            }
            case REFERENCE: {
                return ArrayMemory.toKey(key.toValue());
            }
        }
        return LongMemory.valueOf(key.toLong());
    }

    public boolean containsLongKey(long key) {
        return this.containsKey(LongMemory.valueOf(key));
    }

    public boolean containsKey(Object key) {
        if (this.size() == 0) {
            return false;
        }
        if (this.list != null) {
            long t = MemoryUtils.valueOf(key).toLong();
            return t >= 0L && t < (long)this.list.size();
        }
        return this.map.containsKey(key);
    }

    private void convertToMap() {
        this.map = new LinkedMap();
        if (this.list != null) {
            int i = 0;
            for (ReferenceMemory memory : this.list) {
                if (memory != null) {
                    this.map.put(LongMemory.valueOf(i), memory);
                }
                ++i;
            }
        }
        this.list = null;
    }

    public void renameKey(Memory oldKey, Memory newKey) {
        this.checkCopied();
        if (this.list != null) {
            this.convertToMap();
        }
        Object key1 = ArrayMemory.toKey(oldKey);
        Object key2 = ArrayMemory.toKey(newKey);
        this.map.put(key2, (ReferenceMemory)this.map.remove(key1));
    }

    public ReferenceMemory get(Memory key) {
        return this.getByScalar(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getOrCreate(Memory key) {
        return this.getByScalarOrCreate(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getOrCreateAsShortcut(Memory key) {
        return this.getByScalarOrCreateAsShortcut(ArrayMemory.toKey(key));
    }

    public ReferenceMemory getByScalarOrCreate(Object sKey, Memory initValue) {
        ReferenceMemory value = this.getByScalar(sKey);
        if (value == null) {
            return this.put(sKey, initValue);
        }
        return value;
    }

    public ReferenceMemory getByScalarOrCreateAsShortcut(Object sKey) {
        ReferenceMemory value = this.getByScalar(sKey);
        if (value == null) {
            value = new ReferenceMemory(UNDEFINED);
            return this.put(sKey, new ShortcutMemory(value));
        }
        if (value instanceof ShortcutMemory) {
            return (ShortcutMemory)value.value;
        }
        this.put(sKey, new ShortcutMemory(value));
        return value;
    }

    public ReferenceMemory getByScalarOrCreate(Object sKey) {
        return this.getByScalarOrCreate(sKey, UNDEFINED);
    }

    public ReferenceMemory getByScalar(Object key) {
        if (this.list != null) {
            if (key instanceof Memory) {
                int index = (int)((Memory)key).toLong();
                if (index >= 0 && index < this.list.size()) {
                    return this.list.get(index);
                }
                return null;
            }
            return null;
        }
        return (ReferenceMemory)this.map.get(key);
    }

    public void add(IObject object) {
        this.add(new ObjectMemory(object));
    }

    public void add(long value) {
        this.add(LongMemory.valueOf(value));
    }

    public void add(String value) {
        this.add(StringMemory.valueOf(value));
    }

    public void add(double value) {
        this.add(new DoubleMemory(value));
    }

    public void add(boolean value) {
        this.add(value ? TRUE : FALSE);
    }

    public void addNull() {
        this.add(NULL);
    }

    public ReferenceMemory add(Memory value) {
        ReferenceMemory ref;
        if (value instanceof KeyValueMemory) {
            KeyValueMemory keyValue = (KeyValueMemory)value;
            return this.put(ArrayMemory.toKey(keyValue.key), keyValue.value.toImmutable());
        }
        if (this.list != null) {
            ++this.lastLongIndex;
            ref = new ReferenceMemory(value);
            this.list.add(ref);
            ++this.size;
        } else {
            ref = this.put(LongMemory.valueOf(++this.lastLongIndex), value);
        }
        return ref;
    }

    public void merge(ArrayMemory array, boolean recursive, Set<Integer> done) {
        this.checkCopied();
        if (recursive && done == null) {
            done = new HashSet<Integer>();
        }
        if (this.list != null && array.list != null) {
            for (ReferenceMemory reference : array.list) {
                this.list.add(new ReferenceMemory(reference.toImmutable()));
            }
            this.size = this.list.size();
            this.lastLongIndex = this.size - 1;
        } else {
            if (this.list != null) {
                this.convertToMap();
            }
            if (array.list != null) {
                for (ReferenceMemory reference : array.list) {
                    this.add(reference.toImmutable());
                }
            } else {
                for (Map.Entry entry : array.map.entrySet()) {
                    Object key = entry.getKey();
                    if (key instanceof LongMemory) {
                        this.add(((ReferenceMemory)entry.getValue()).toImmutable());
                        continue;
                    }
                    Memory value = (Memory)entry.getValue();
                    if (recursive && value.isArray()) {
                        if (done.contains(value.getPointer())) {
                            throw new RecursiveException();
                        }
                        Memory current = this.getByScalar(key).toImmutable();
                        if (current.isArray()) {
                            value = value.toImmutable();
                            int pointer = value.getPointer();
                            done.add(pointer);
                            ArrayMemory result = (ArrayMemory)value;
                            result.merge((ArrayMemory)current, recursive, done);
                            this.put(key, result);
                            done.remove(pointer);
                            continue;
                        }
                        this.put(key, value.toImmutable());
                        continue;
                    }
                    this.put(key, value.toImmutable());
                }
            }
        }
    }

    public void putAll(ArrayMemory array) {
        if (array.list != null) {
            int i = 0;
            for (ReferenceMemory memory : array.list) {
                if (memory != null) {
                    this.put(LongMemory.valueOf(i), memory.toImmutable());
                }
                ++i;
            }
        } else {
            if (this.list != null) {
                this.convertToMap();
            }
            if (array.lastLongIndex > this.lastLongIndex) {
                this.lastLongIndex = array.lastLongIndex;
            }
            for (Map.Entry entry : array.map.entrySet()) {
                this.put(entry.getKey(), ((ReferenceMemory)entry.getValue()).toImmutable());
            }
        }
    }

    public void putAllRef(ArrayMemory array) {
        if (array.list != null) {
            int i = 0;
            for (ReferenceMemory memory : array.list) {
                if (memory != null) {
                    this.put(LongMemory.valueOf(i), memory);
                }
                ++i;
            }
        } else {
            if (this.list != null) {
                this.convertToMap();
            }
            if (array.lastLongIndex > this.lastLongIndex) {
                this.lastLongIndex = array.lastLongIndex;
            }
            this.map.putAll(array.map);
        }
    }

    public ReferenceMemory putAsKeyString(String key, Memory value) {
        Memory last;
        ReferenceMemory mem = new ReferenceMemory(value);
        if (this.list != null) {
            this.convertToMap();
        }
        if ((last = (Memory)this.map.put(key, mem)) == null) {
            ++this.size;
        }
        return mem;
    }

    public ReferenceMemory put(Object key, Memory value) {
        ReferenceMemory mem = new ReferenceMemory(value);
        if (key instanceof LongMemory) {
            int index = (int)((LongMemory)key).value;
            if ((long)index > this.lastLongIndex) {
                this.lastLongIndex = index;
            }
            if (this.list != null) {
                int size = this.list.size();
                if (index >= 0) {
                    if (index < size) {
                        this.list.set(index, mem);
                        return mem;
                    }
                    if (index == size) {
                        this.list.add(mem);
                        ++this.size;
                        return mem;
                    }
                    this.convertToMap();
                } else {
                    this.convertToMap();
                }
            }
        } else {
            if (!(key instanceof String)) {
                key = key.toString();
            }
            if (this.list != null) {
                this.convertToMap();
            }
        }
        Memory last = this.map.put(key, mem);
        if (last == null) {
            ++this.size;
        }
        return mem;
    }

    public Memory removeByScalar(Object key) {
        Memory tmp;
        if (this.list != null) {
            Memory tmp2;
            int index = -1;
            if (key instanceof Long) {
                index = ((Long)key).intValue();
            } else if (key instanceof Integer) {
                index = (Integer)key;
            } else if (key instanceof String && (tmp2 = StringMemory.toLong((String)key)) != null) {
                index = (int)tmp2.toLong();
            }
            if (index < 0 || index >= this.list.size()) {
                return null;
            }
            if (index == this.size - 1) {
                --this.size;
                this.lastLongIndex = this.size - 1;
                return this.list.remove(index);
            }
            key = (long)index;
            this.convertToMap();
        }
        if (key instanceof Long) {
            key = LongMemory.valueOf((Long)key);
        } else if (key instanceof Integer) {
            key = LongMemory.valueOf((Integer)key);
        } else if (key instanceof String && (tmp = StringMemory.toLong((String)key)) != null) {
            key = tmp;
        }
        Memory memory = (Memory)this.map.remove(key);
        if (memory != null) {
            --this.size;
        }
        return memory;
    }

    public Memory remove(Memory key) {
        Memory memory;
        Object _key = ArrayMemory.toKey(key);
        if (this.list != null) {
            int index;
            int n = index = _key instanceof LongMemory ? (int)key.toLong() : -1;
            if (index < 0 || index >= this.list.size()) {
                return null;
            }
            if (index == this.size - 1) {
                --this.size;
                this.lastLongIndex = index - 1;
                return this.list.remove(index);
            }
            this.convertToMap();
        }
        if ((memory = (Memory)this.map.remove(_key)) != null) {
            --this.size;
        }
        return memory;
    }

    public int size() {
        return this.size;
    }

    public void unshift(Memory value, int count) {
        this.checkCopied();
        if (this.size == 0) {
            for (int i = 0; i < count; ++i) {
                this.add(value);
            }
        } else if (this.list != null) {
            ArrayList<ReferenceMemory> tmp = new ArrayList<ReferenceMemory>();
            for (int i = 0; i < count; ++i) {
                tmp.add(new ReferenceMemory(value));
            }
            this.list.addAll(0, tmp);
            this.size = this.list.size();
        } else {
            ArrayMemory tmp = new ArrayMemory();
            tmp.convertToMap();
            for (int i = 0; i < count; ++i) {
                tmp.add(value);
            }
            ForeachIterator iterator = this.getNewIterator(null, false, false);
            while (iterator.next()) {
                Object key = iterator.getKey();
                if (key instanceof String) {
                    tmp.put(key, iterator.getValue());
                    continue;
                }
                this.add(iterator.getValue());
            }
            this.lastLongIndex = tmp.lastLongIndex;
            this.map = tmp.map;
            this.size = tmp.size;
        }
    }

    public void unshift(Memory ... values) {
        this.checkCopied();
        if (values == null) {
            throw new NullPointerException();
        }
        if (this.size == 0) {
            for (Memory value : values) {
                this.add(value);
            }
        } else if (this.list != null) {
            if (values.length > 1) {
                ArrayList<ReferenceMemory> tmp = new ArrayList<ReferenceMemory>();
                for (Memory value : values) {
                    tmp.add(new ReferenceMemory(value));
                }
                this.list.addAll(0, tmp);
                this.size = this.list.size();
            } else if (values.length == 1) {
                this.list.add(0, new ReferenceMemory(values[0]));
                this.size = this.list.size();
            }
        } else {
            ArrayMemory tmp = new ArrayMemory();
            tmp.convertToMap();
            for (Memory el : values) {
                tmp.add(el);
            }
            ForeachIterator iterator = this.getNewIterator(null, false, false);
            while (iterator.next()) {
                Object key = iterator.getKey();
                if (key instanceof String) {
                    tmp.put(key, iterator.getValue());
                    continue;
                }
                this.add(iterator.getValue());
            }
            this.lastLongIndex = tmp.lastLongIndex;
            this.map = tmp.map;
            this.size = tmp.size;
        }
    }

    public Memory shift() {
        Memory value;
        this.checkCopied();
        if (this.size < 1) {
            return null;
        }
        --this.size;
        if (this.list != null) {
            value = this.list.get(0);
            this.list.remove(0);
        } else {
            value = (Memory)this.map.remove(this.map.firstKey());
        }
        return value.toValue();
    }

    public Memory pop() {
        Memory value;
        this.checkCopied();
        if (this.size < 1) {
            return null;
        }
        if (this.list != null) {
            value = this.list.get(this.size - 1);
            this.list.remove(this.size - 1);
        } else {
            value = (Memory)this.map.remove(this.map.lastKey());
        }
        --this.size;
        return value.toValue();
    }

    public Memory peek() {
        if (this.size < 1) {
            return null;
        }
        Memory value = this.list != null ? (Memory)this.list.get(this.size - 1) : (Memory)this.map.get(this.map.lastKey());
        return value.toValue();
    }

    public Memory getRandomElementKey(Random rnd) {
        int index = rnd.nextInt(this.size);
        if (this.list != null) {
            return LongMemory.valueOf(index);
        }
        Iterator keys = this.map.keySet().iterator();
        for (int i = 0; i < index; ++i) {
            keys.next();
        }
        Object key = keys.next();
        if (key instanceof LongMemory) {
            return (LongMemory)key;
        }
        return new StringMemory((String)key);
    }

    public void shuffle(Random rnd) {
        this.checkCopied();
        if (this.list != null) {
            Collections.shuffle(this.list, rnd);
        } else {
            Set keys = this.map.keySet();
            ArrayList values = new ArrayList(this.map.values());
            Collections.shuffle(values, rnd);
            int i = 0;
            for (Object key : keys) {
                this.map.put(key, (ReferenceMemory)values.get(i));
                ++i;
            }
        }
    }

    public void clear() {
        if (this.list != null) {
            this.list = new ArrayList<ReferenceMemory>();
        }
        if (this.map != null) {
            this.map = new LinkedMap();
        }
        this.size = 0;
    }

    public int compare(ArrayMemory otherRef, boolean strict) {
        return this.compare(otherRef, strict, null);
    }

    public int compare(ArrayMemory otherRef, boolean strict, Set<Integer> used) {
        int size2;
        int size1 = this.size();
        if (size1 < (size2 = otherRef.size())) {
            return -1;
        }
        if (size1 > size2) {
            return 1;
        }
        ForeachIterator iterator = this.foreachIterator(false, false);
        ForeachIterator iterator2 = null;
        if (strict) {
            iterator2 = otherRef.foreachIterator(false, false);
        }
        if (used == null) {
            used = new HashSet<Integer>();
        }
        while (iterator.next()) {
            Memory value2;
            Memory value1 = iterator.getValue();
            Memory key = iterator.getMemoryKey();
            if (iterator2 == null) {
                value2 = otherRef.get(key);
            } else {
                if (!iterator2.next()) {
                    return -2;
                }
                Object key2 = iterator2.getKey();
                if (!iterator.getKey().equals(key2)) {
                    return -2;
                }
                value2 = iterator2.getValue();
            }
            if (value2 == null) {
                return -2;
            }
            if (value1.isArray() && value2.isArray()) {
                ArrayMemory arr1 = value1.toValue(ArrayMemory.class);
                if (used.add(value2.getPointer())) {
                    int r = arr1.compare(value2.toValue(ArrayMemory.class), strict, used);
                    if (r == 0) {
                        used.remove(value2.getPointer());
                        continue;
                    }
                    return r;
                }
                used.remove(value2.getPointer());
                continue;
            }
            if (value1.isObject() && value2.isObject()) {
                ObjectMemory o1 = value1.toValue(ObjectMemory.class);
                ObjectMemory o2 = value2.toValue(ObjectMemory.class);
                return o1.compare(o2.value, strict, used);
            }
            if (strict && value1.identical(value2) || !strict && value1.equal(value2)) continue;
            if (value1.smaller(value2)) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public Memory toImmutable() {
        if (this.copies >= 0) {
            ArrayMemory mem = new ArrayMemory();
            mem.list = this.list;
            mem.original = this;
            mem.size = this.size;
            mem.list = this.list;
            mem.map = this.map;
            mem.lastLongIndex = this.lastLongIndex;
            ++this.copies;
            this.reset();
            return mem;
        }
        ++this.copies;
        return this;
    }

    public ArrayMemory toConstant() {
        if (this.copies == 0) {
            --this.copies;
        } else {
            throw new RuntimeException("Cannot convert array to a constant value with copies != 0");
        }
        return this;
    }

    public Memory[] values(boolean asImmutable) {
        Memory[] result = new Memory[this.size];
        int i = 0;
        for (ReferenceMemory el : this) {
            result[i++] = asImmutable ? el.toImmutable() : el.toValue();
        }
        return result;
    }

    public Memory[] values() {
        return this.values(false);
    }

    @Override
    public long toLong() {
        return this.size == 0 ? 0L : 1L;
    }

    @Override
    public double toDouble() {
        return this.size == 0 ? 0.0 : 1.0;
    }

    @Override
    public boolean toBoolean() {
        return this.size != 0;
    }

    @Override
    public Memory toNumeric() {
        return this.size == 0 ? CONST_INT_0 : CONST_INT_1;
    }

    @Override
    public String toString() {
        return "Array";
    }

    @Override
    public Memory inc() {
        return this.toNumeric().inc();
    }

    @Override
    public Memory dec() {
        return this.toNumeric().dec();
    }

    @Override
    public Memory negative() {
        return this.toNumeric().negative();
    }

    @Override
    public Memory plus(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                ArrayMemory left = (ArrayMemory)this.toImmutable();
                ArrayMemory other = (ArrayMemory)memory;
                ForeachIterator iterator = other.foreachIterator(false, false);
                while (iterator.next()) {
                    Object key = iterator.getKey();
                    ReferenceMemory origin = this.getByScalar(key);
                    if (origin != null) continue;
                    left.checkCopied();
                    left.put(key, iterator.getValue().toImmutable());
                }
                return left;
            }
            case REFERENCE: {
                return this.plus(memory.toValue());
            }
        }
        return this.toNumeric().plus(memory);
    }

    @Override
    public Memory minus(Memory memory) {
        return this.toNumeric().minus(memory);
    }

    @Override
    public Memory mul(Memory memory) {
        return this.toNumeric().mul(memory);
    }

    @Override
    public Memory pow(Memory memory) {
        return this.toNumeric().pow(memory);
    }

    @Override
    public Memory div(Memory memory) {
        return this.toNumeric().div(memory);
    }

    @Override
    public boolean equal(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == 0;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean notEqual(Memory memory) {
        return !this.equal(memory);
    }

    @Override
    public boolean smaller(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == -1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean smallerEq(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                int r = this.compare((ArrayMemory)memory, false);
                return r == 0 || r == -1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean greater(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, false) == 1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean greaterEq(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                int r = this.compare((ArrayMemory)memory, false);
                return r == 0 || r == 1;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public void unset() {
        if (this.original != null) {
            --this.original.copies;
            this.original = null;
        } else {
            --this.copies;
        }
        if (this.list != null) {
            for (ReferenceMemory memory : this.list) {
                if (memory.type != this.type) continue;
                memory.unset();
            }
        }
        if (this.map != null) {
            for (ReferenceMemory memory : this.map.values()) {
                if (memory.type != this.type) continue;
                memory.unset();
            }
        }
        this.clear();
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return UNDEFINED;
            }
        }
        ReferenceMemory e = this.get(index);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, long index) {
        ReferenceMemory e = this.getByScalar(LongMemory.valueOf(index));
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, double index) {
        ReferenceMemory e = this.getByScalar(LongMemory.valueOf((long)index));
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, boolean index) {
        ReferenceMemory e = this.getByScalar(index ? CONST_INT_0 : CONST_INT_1);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public Memory valueOfIndex(TraceInfo trace, String index) {
        Memory number = StringMemory.toLong(index);
        ReferenceMemory e = number == null ? this.getByScalar(index) : this.getByScalar(number);
        return e == null ? UNDEFINED : e;
    }

    @Override
    public void unsetOfIndex(TraceInfo trace, Memory index) {
        this.checkCopied();
        this.remove(index);
    }

    @Override
    public Memory issetOfIndex(TraceInfo trace, Memory index) {
        ReferenceMemory value = this.get(index);
        return value == null ? NULL : value;
    }

    @Override
    public Memory refOfPush(TraceInfo trace) {
        this.checkCopied();
        return this.add(UNDEFINED);
    }

    @Override
    public Memory refOfIndexAsShortcut(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return new ReferenceMemory();
            }
        }
        this.checkCopied();
        return this.getOrCreateAsShortcut(index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, Memory index) {
        switch (index.getRealType()) {
            case ARRAY: 
            case OBJECT: {
                return new ReferenceMemory();
            }
        }
        this.checkCopied();
        return this.getOrCreate(index);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, long index) {
        this.checkCopied();
        return this.getOrCreate(LongMemory.valueOf(index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, double index) {
        return this.refOfIndex(null, LongMemory.valueOf((long)index));
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, boolean index) {
        this.checkCopied();
        return this.getOrCreate(index ? CONST_INT_1 : CONST_INT_0);
    }

    @Override
    public Memory refOfIndex(TraceInfo trace, String index) {
        this.checkCopied();
        Memory number = StringMemory.toLong(index);
        return number == null ? this.getByScalarOrCreate(index) : this.getByScalarOrCreate(number);
    }

    @Override
    public boolean identical(Memory memory) {
        switch (memory.type) {
            case ARRAY: {
                return this.compare((ArrayMemory)memory, true) == 0;
            }
            case REFERENCE: {
                return this.equal(memory.toValue());
            }
        }
        return false;
    }

    @Override
    public boolean identical(long value) {
        return false;
    }

    @Override
    public boolean identical(double value) {
        return false;
    }

    @Override
    public boolean identical(boolean value) {
        return false;
    }

    @Override
    public boolean identical(String value) {
        return false;
    }

    @Override
    public Iterator<ReferenceMemory> iterator() {
        if (this.list != null) {
            return this.list.iterator();
        }
        return this.map.values().iterator();
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean withPrevious) {
        return this.foreachIterator(getReferences, false, withPrevious, true);
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean getKeyReferences, boolean withPrevious) {
        return this.foreachIterator(getReferences, getKeyReferences, withPrevious, true);
    }

    public ForeachIterator foreachIterator(boolean getReferences, boolean getKeyReferences, boolean withPrevious, final boolean freeze) {
        return new ForeachIterator(getReferences, getKeyReferences, withPrevious){
            protected int cursor;
            protected int listMax;
            protected Iterator<Object> keys;
            {
                super(getReferences, getKeyReferences, withPrevious);
                this.cursor = 0;
            }

            @Override
            public void reset() {
                if (this.getKeyReferences && ArrayMemory.this.list != null) {
                    ArrayMemory.this.convertToMap();
                }
                if (ArrayMemory.this.list == null) {
                    this.keys = this.withPrevious || this.getKeyReferences ? new ArrayList(ArrayMemory.this.map.keySet()).listIterator() : (freeze ? new ArrayList(ArrayMemory.this.map.keySet()).iterator() : ArrayMemory.this.map.keySet().iterator());
                } else {
                    this.listMax = ArrayMemory.this.list.size();
                }
            }

            @Override
            protected boolean init() {
                if (this.getKeyReferences && ArrayMemory.this.list != null) {
                    ArrayMemory.this.convertToMap();
                }
                if (ArrayMemory.this.list == null) {
                    this.keys = this.withPrevious || this.getKeyReferences ? new ArrayList(ArrayMemory.this.map.keySet()).listIterator() : new ArrayList(ArrayMemory.this.map.keySet()).iterator();
                } else {
                    this.listMax = ArrayMemory.this.list.size();
                }
                return true;
            }

            private void setCurrentValue(ReferenceMemory value) {
                this.currentValue = this.getReferences ? (this.plainReferences ? value : new ArrayValueMemory(this.getMemoryKey(), ArrayMemory.this, value)) : value.value;
                if (this.getKeyReferences) {
                    this.currentKeyMemory = new ArrayKeyMemory(ArrayMemory.this, this.getMemoryKey());
                }
            }

            @Override
            public boolean end() {
                if (ArrayMemory.this.size == 0) {
                    return false;
                }
                if (ArrayMemory.this.list != null) {
                    this.cursor = ArrayMemory.this.size - 1;
                    this.currentKey = (long)this.cursor;
                    this.setCurrentValue(ArrayMemory.this.list.get(this.cursor));
                    return true;
                }
                this.init = true;
                ArrayList tmp = new ArrayList(ArrayMemory.this.map.keySet());
                this.keys = tmp.listIterator(tmp.size() - 1);
                return this.keys.hasNext() && this.next();
            }

            @Override
            protected boolean prevValue() {
                if (ArrayMemory.this.list != null) {
                    if (this.cursor <= 0) {
                        this.currentKey = null;
                        this.currentValue = null;
                        --this.cursor;
                        this.keys = null;
                        return false;
                    }
                    --this.cursor;
                    this.currentKey = LongMemory.valueOf((long)this.cursor);
                    this.setCurrentValue(ArrayMemory.this.list.get(this.cursor));
                    return true;
                }
                ListIterator keyIterator = (ListIterator)this.keys;
                if (keyIterator.hasPrevious()) {
                    this.currentKey = keyIterator.previous();
                    this.setCurrentValue((ReferenceMemory)ArrayMemory.this.map.get(this.currentKey));
                    return true;
                }
                this.currentKey = null;
                this.currentValue = null;
                this.keys = null;
                this.cursor = -1;
                return false;
            }

            @Override
            protected boolean nextValue() {
                if (this.withPrevious && this.keys == null && this.cursor < 0) {
                    return false;
                }
                if (ArrayMemory.this.list != null) {
                    if (this.cursor >= this.listMax && freeze || this.cursor >= ArrayMemory.this.size && !freeze || ArrayMemory.this.size < this.listMax) {
                        this.currentKey = null;
                        this.currentValue = null;
                        return false;
                    }
                    this.currentKey = LongMemory.valueOf((long)this.cursor);
                    this.setCurrentValue(ArrayMemory.this.list.get(this.cursor));
                    ++this.cursor;
                    return true;
                }
                if (this.keys == null) {
                    ArrayList tmp = new ArrayList(ArrayMemory.this.map.keySet());
                    this.keys = tmp.listIterator(this.cursor - 1);
                }
                if (this.keys.hasNext()) {
                    this.currentKey = this.keys.next();
                    this.setCurrentValue((ReferenceMemory)ArrayMemory.this.map.get(this.currentKey));
                    return true;
                }
                this.currentKey = null;
                this.currentValue = null;
                return false;
            }
        };
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return this.foreachIterator(getReferences, getKeyReferences, false);
    }

    public ForeachIterator getCurrentIterator() {
        if (this.foreachIterator == null) {
            this.foreachIterator = this.foreachIterator(false, true);
        }
        return this.foreachIterator;
    }

    protected void reset() {
        this.foreachIterator = null;
    }

    public Memory resetCurrentIterator() {
        this.reset();
        ForeachIterator iterator = this.getCurrentIterator();
        if (this.size == 0) {
            return FALSE;
        }
        iterator.next();
        Memory tmp = iterator.getValue();
        iterator.prev();
        return tmp;
    }

    @Override
    public byte[] getBinaryBytes(Charset charset) {
        return MemoryStringUtils.getBinaryBytes(this);
    }

    public boolean isList() {
        return this.list != null;
    }

    @Override
    public Memory toArray() {
        return this;
    }

    @Override
    public Memory toObject(Environment env) {
        StdClass stdClass = new StdClass(env);
        ArrayMemory props = stdClass.getProperties();
        ForeachIterator iterator = this.getNewIterator(env, false, false);
        while (iterator.next()) {
            props.refOfIndex(null, iterator.getMemoryKey()).assign(iterator.getValue());
        }
        return new ObjectMemory(stdClass);
    }

    public int[] toIntArray() {
        int[] r = new int[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toInteger();
            ++i;
        }
        return r;
    }

    public long[] toLongArray() {
        long[] r = new long[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toLong();
            ++i;
        }
        return r;
    }

    public String[] toStringArray() {
        String[] r = new String[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toString();
            ++i;
        }
        return r;
    }

    public float[] toFloatArray() {
        float[] r = new float[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toFloat();
            ++i;
        }
        return r;
    }

    public double[] toDoubleArray() {
        double[] r = new double[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toDouble();
            ++i;
        }
        return r;
    }

    public boolean[] toBoolArray() {
        boolean[] r = new boolean[this.size];
        int i = 0;
        for (Memory e : this) {
            r[i] = e.toBoolean();
            ++i;
        }
        return r;
    }

    public <T extends IObject> List<T> toObjectArray(Class<T> clazz) {
        ArrayList<T> r = new ArrayList<T>();
        boolean i = false;
        for (Memory e : this) {
            if (e.instanceOf(clazz)) {
                r.add(e.toObject(clazz));
                continue;
            }
            throw new IllegalArgumentException(Messages.ERR_INVALID_ARRAY_ELEMENT_TYPE.fetch(ReflectionUtils.getClassName(clazz), ReflectionUtils.getGivenName(e)));
        }
        return r;
    }

    public Map<String, String> toStringMap() {
        LinkedHashMap<String, String> r = new LinkedHashMap<String, String>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toString());
        }
        return r;
    }

    public Map<String, Integer> toIntMap() {
        LinkedHashMap<String, Integer> r = new LinkedHashMap<String, Integer>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toInteger());
        }
        return r;
    }

    public Map<String, Long> toLongMap() {
        LinkedHashMap<String, Long> r = new LinkedHashMap<String, Long>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toLong());
        }
        return r;
    }

    public Map<String, Double> toDoubleMap() {
        LinkedHashMap<String, Double> r = new LinkedHashMap<String, Double>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toDouble());
        }
        return r;
    }

    public Map<String, Boolean> toBooleanMap() {
        LinkedHashMap<String, Boolean> r = new LinkedHashMap<String, Boolean>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            r.put(iterator.getKey().toString(), iterator.getValue().toBoolean());
        }
        return r;
    }

    public <T extends IObject> Map<String, T> toObjectMap(Class<T> clazz) {
        LinkedHashMap<String, T> r = new LinkedHashMap<String, T>();
        ForeachIterator iterator = this.foreachIterator(false, false);
        while (iterator.next()) {
            Memory e = iterator.getValue();
            if (e.instanceOf(clazz)) {
                r.put(iterator.getKey().toString(), e.toObject(clazz));
                continue;
            }
            throw new IllegalArgumentException(Messages.ERR_INVALID_ARRAY_ELEMENT_TYPE.fetch(ReflectionUtils.getClassName(clazz), ReflectionUtils.getGivenName(e)));
        }
        return r;
    }

    public static ArrayMemory ofPair(String key, Memory value) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex(key).assign(value.toImmutable());
        return r;
    }

    public static ArrayMemory ofPair(String key, String value) {
        return ArrayMemory.ofPair(key, StringMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, long value) {
        return ArrayMemory.ofPair(key, LongMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, double value) {
        return ArrayMemory.ofPair(key, DoubleMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, boolean value) {
        return ArrayMemory.ofPair(key, TrueMemory.valueOf(value));
    }

    public static ArrayMemory ofPair(String key, IObject value) {
        return ArrayMemory.ofPair(key, ObjectMemory.valueOf(value));
    }

    public static ArrayMemory ofShorts(short ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (short el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofIntegers(int ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (int el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofBytes(byte ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (byte el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofLongs(long ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (long el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofFloats(float ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (float el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofDoubles(double ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (double el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofBooleans(boolean ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (boolean el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofChars(char ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (char el : array) {
                result.add(StringMemory.valueOf(el));
            }
        }
        return result;
    }

    public static ArrayMemory ofStrings(String ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (String el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory ofStringCollection(Collection<String> list) {
        ArrayMemory result = new ArrayMemory();
        for (String el : list) {
            result.add(el);
        }
        return result;
    }

    public static ArrayMemory ofObjects(IObject ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (IObject el : array) {
                result.add(el);
            }
        }
        return result;
    }

    public static ArrayMemory of(Memory ... array) {
        ArrayMemory result = new ArrayMemory();
        if (array != null) {
            for (Memory el : array) {
                result.add(el.toImmutable());
            }
        }
        return result;
    }

    public static ArrayMemory ofCollection(Collection<Memory> list) {
        ArrayMemory result = new ArrayMemory();
        for (Memory el : list) {
            result.add(el.toImmutable());
        }
        return result;
    }

    public static ArrayMemory ofMap(Map<String, Memory> map) {
        ArrayMemory result = new ArrayMemory();
        for (Map.Entry<String, Memory> entry : map.entrySet()) {
            result.putAsKeyString(entry.getKey(), entry.getValue().toImmutable());
        }
        return result;
    }

    public static ArrayMemory ofStringMap(Map<String, String> map) {
        ArrayMemory result = new ArrayMemory();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.putAsKeyString(entry.getKey(), StringMemory.valueOf(entry.getValue()));
        }
        return result;
    }

    public ArrayMemory slice(int offset) {
        return this.slice(offset, false);
    }

    public ArrayMemory slice(int offset, int length) {
        return this.slice(offset, length, false);
    }

    public ArrayMemory slice(int offset, boolean saveKeys) {
        ArrayMemory result = new ArrayMemory();
        if (offset < 0) {
            offset = this.size() + offset;
        }
        if (this.isList()) {
            int i = 0;
            try {
                for (ReferenceMemory referenceMemory : this.list.subList(offset, this.list.size())) {
                    if (saveKeys) {
                        result.refOfIndex(i + offset).assign(referenceMemory.toImmutable());
                    } else {
                        result.add(referenceMemory.toImmutable());
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        } else {
            int i = 0;
            ForeachIterator iterator = this.foreachIterator(false, false);
            while (iterator.next()) {
                if (i >= offset) {
                    if (saveKeys || !iterator.isLongKey()) {
                        result.put(iterator.getKey(), iterator.getValue().toImmutable());
                    } else {
                        result.add(iterator.getValue().toImmutable());
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public ArrayMemory slice(int offset, int length, boolean saveKeys) {
        ArrayMemory result = new ArrayMemory();
        if (offset < 0) {
            offset = this.size() + offset;
        }
        if (length < 0) {
            length = this.size() + length - offset;
        }
        if (this.isList()) {
            int i = 0;
            try {
                for (ReferenceMemory referenceMemory : this.list.subList(offset, offset + length)) {
                    if (saveKeys) {
                        result.refOfIndex(i + offset).assign(referenceMemory.toImmutable());
                    } else {
                        result.add(referenceMemory.toImmutable());
                    }
                    ++i;
                }
            }
            catch (IllegalArgumentException e) {
                throw new IndexOutOfBoundsException(e.getMessage());
            }
        } else {
            int i = 0;
            int count = 0;
            ForeachIterator iterator = this.foreachIterator(false, false);
            while (iterator.next()) {
                if (i >= offset) {
                    ++count;
                    if (saveKeys || !iterator.isLongKey()) {
                        result.put(iterator.getKey(), iterator.getValue().toImmutable());
                    } else {
                        result.add(iterator.getValue().toImmutable());
                    }
                    if (count >= length) break;
                }
                ++i;
            }
        }
        return result;
    }
}

