/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.invoke.cache;

import java.lang.ref.WeakReference;
import php.runtime.env.Environment;
import php.runtime.reflection.support.Entity;

public abstract class CallCache<T extends Entity> {
    protected Item[][] cache;

    public T get(Environment env, int index) {
        Item[] data;
        if (this.cache == null) {
            return null;
        }
        Item[] itemArray = data = env.id < this.cache.length ? this.cache[env.id] : null;
        if (data == null) {
            return null;
        }
        if (index >= data.length) {
            return null;
        }
        Item item = data[index];
        if (item == null) {
            return null;
        }
        if (item.env.get() != env) {
            data[index] = null;
            return null;
        }
        return (T)item.data;
    }

    public abstract Item[] newArrayData(int var1);

    public abstract Item[][] newArrayArrayData(int var1);

    public synchronized void put(Environment env, int index, T entity) {
        Item[] data;
        int id = env.id;
        if (this.cache == null) {
            this.cache = this.newArrayArrayData(id + 1);
        }
        if (id >= this.cache.length) {
            Item[][] newCache = this.newArrayArrayData(id + 1);
            System.arraycopy(this.cache, 0, newCache, 0, this.cache.length);
            this.cache = newCache;
        }
        if ((data = this.cache[id]) == null) {
            data = this.newArrayData(index + 1 + 10);
            this.cache[id] = data;
        } else if (index >= data.length) {
            Item[] newData = this.newArrayData(index + 1 + 10);
            System.arraycopy(data, 0, newData, 0, data.length);
            data = newData;
            this.cache[id] = newData;
        }
        data[index] = new Item((Entity)entity, env);
    }

    protected static class Item {
        Entity data;
        WeakReference<Environment> env;

        public Item(Entity data, Environment env) {
            this.data = data;
            this.env = new WeakReference<Environment>(env);
        }
    }
}

