/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.java;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaClass;
import php.runtime.ext.java.JavaObject;
import php.runtime.lang.BaseException;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.util.JVMStackTracer;

@Reflection.Name(value="php\\lang\\JavaException")
public class JavaException
extends BaseException {
    protected Throwable throwable;

    public JavaException(Environment env, Throwable throwable) {
        super(env);
        this.setThrowable(throwable);
    }

    public JavaException(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getMessage() {
        return this.throwable != null ? this.throwable.getMessage() : super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        return this.throwable != null ? this.throwable.getLocalizedMessage() : super.getLocalizedMessage();
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
        this.clazz.setProperty(this, "message", new StringMemory(throwable.toString()));
    }

    @Reflection.Signature
    public Memory isIllegalArgumentException(Environment env, Memory ... args) {
        return this.throwable instanceof IllegalArgumentException ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isRuntimeException(Environment env, Memory ... args) {
        return this.throwable instanceof RuntimeException ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isNullPointerException(Environment env, Memory ... args) {
        return this.throwable instanceof NullPointerException ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isNumberFormatException(Environment env, Memory ... args) {
        return this.throwable instanceof NumberFormatException ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory getJavaException(Environment env, Memory ... args) {
        if (this.throwable == null) {
            return Memory.NULL;
        }
        return new ObjectMemory(JavaObject.of(env, this.throwable));
    }

    @Reflection.Signature
    public Memory getExceptionClass(Environment env, Memory ... args) {
        if (this.throwable == null) {
            return Memory.NULL;
        }
        return new ObjectMemory(JavaClass.of(env, this.throwable.getClass()));
    }

    @Reflection.Signature
    public Memory printJVMStackTrace(Environment env, Memory ... args) {
        if (this.throwable == null) {
            return Memory.NULL;
        }
        JVMStackTracer tracer = new JVMStackTracer(env.scope.getClassLoader(), this.throwable.getStackTrace());
        for (JVMStackTracer.Item el : tracer) {
            env.echo(el.toString() + "\n");
        }
        return Memory.NULL;
    }
}

