/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import php.runtime.Memory;
import php.runtime.Startup;
import php.runtime.common.AbstractCompiler;
import php.runtime.common.CompilerFactory;
import php.runtime.common.LangMode;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.handler.EntityFetchHandler;
import php.runtime.env.handler.ProgramShutdownHandler;
import php.runtime.env.handler.TickHandler;
import php.runtime.exceptions.ConflictException;
import php.runtime.exceptions.CriticalException;
import php.runtime.ext.CoreExtension;
import php.runtime.ext.JavaExtension;
import php.runtime.ext.NetExtension;
import php.runtime.ext.java.JavaException;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileClass;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.ext.support.compile.CompileFunction;
import php.runtime.ext.support.compile.CompileFunctionSpec;
import php.runtime.lang.BaseException;
import php.runtime.lang.Closure;
import php.runtime.lang.Generator;
import php.runtime.lang.IObject;
import php.runtime.lang.StdClass;
import php.runtime.lang.exception.BaseArithmeticError;
import php.runtime.lang.exception.BaseDivisionByZeroError;
import php.runtime.lang.exception.BaseError;
import php.runtime.lang.exception.BaseParseError;
import php.runtime.lang.exception.BaseThrowable;
import php.runtime.lang.exception.BaseTypeError;
import php.runtime.lang.spl.ArrayAccess;
import php.runtime.lang.spl.ErrorException;
import php.runtime.lang.spl.Serializable;
import php.runtime.lang.spl.Traversable;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.lang.spl.iterator.IteratorAggregate;
import php.runtime.loader.RuntimeClassLoader;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.CompileFunctionEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.support.ReflectionUtils;
import php.runtime.util.JVMStackTracer;
import php.runtime.wrap.ClassWrapper;

public class CompileScope {
    public final int id;
    protected RuntimeClassLoader classLoader;
    public final Set<String> superGlobals;
    protected static final AtomicInteger scopeCount = new AtomicInteger(0);
    protected final AtomicInteger moduleCount = new AtomicInteger(0);
    protected final AtomicLong classCount = new AtomicLong(0L);
    protected final AtomicLong methodCount = new AtomicLong(0L);
    public final ConcurrentHashMap<String, ModuleEntity> moduleMap;
    public final ConcurrentHashMap<String, ModuleEntity> moduleIndexMap;
    protected final Map<String, ClassEntity> classMap;
    protected final Map<String, FunctionEntity> functionMap;
    protected final Map<String, ConstantEntity> constantMap;
    protected final Map<Class<? extends Throwable>, Class<? extends JavaException>> exceptionMap;
    protected final Map<String, Class<? extends JavaException>> exceptionMapForContext;
    protected Map<String, Extension> extensions;
    protected Map<String, CompileConstant> compileConstantMap;
    protected Map<String, CompileFunction> compileFunctionMap;
    protected Map<String, CompileClass> compileClassMap;
    protected Map<String, CompileFunctionSpec> compileFunctionSpecMap;
    protected CompilerFactory compilerFactory;
    protected List<EntityFetchHandler> classEntityFetchHandler;
    protected List<EntityFetchHandler> functionEntityFetchHandler;
    protected List<EntityFetchHandler> constantEntityFetchHandler;
    protected TickHandler tickHandler;
    protected List<ProgramShutdownHandler> programShutdownHandlers;
    public Map<String, Memory> configuration;
    public boolean debugMode = false;
    protected LangMode langMode = LangMode.MODERN;

    public CompileScope(CompileScope parent) {
        this.id = scopeCount.getAndIncrement();
        this.classLoader = parent.classLoader;
        this.langMode = parent.langMode;
        this.moduleMap = new ConcurrentHashMap();
        this.moduleIndexMap = new ConcurrentHashMap();
        this.classMap = new HashMap<String, ClassEntity>();
        this.functionMap = new HashMap<String, FunctionEntity>();
        this.constantMap = new HashMap<String, ConstantEntity>();
        this.exceptionMap = new HashMap<Class<? extends Throwable>, Class<? extends JavaException>>();
        this.exceptionMapForContext = new HashMap<String, Class<? extends JavaException>>();
        this.extensions = new LinkedHashMap<String, Extension>();
        this.compileConstantMap = new HashMap<String, CompileConstant>();
        this.compileFunctionMap = new HashMap<String, CompileFunction>();
        this.compileFunctionSpecMap = new HashMap<String, CompileFunctionSpec>();
        this.compileClassMap = new HashMap<String, CompileClass>();
        this.superGlobals = new HashSet<String>();
        this.superGlobals.addAll(parent.superGlobals);
        this.classMap.putAll(parent.classMap);
        this.compileClassMap.putAll(parent.compileClassMap);
        this.functionMap.putAll(parent.functionMap);
        this.compileFunctionMap.putAll(parent.compileFunctionMap);
        this.compileFunctionSpecMap.putAll(parent.compileFunctionSpecMap);
        this.constantMap.putAll(parent.constantMap);
        this.compileConstantMap.putAll(parent.compileConstantMap);
        this.exceptionMap.putAll(parent.exceptionMap);
        this.moduleMap.putAll(parent.moduleMap);
        this.moduleIndexMap.putAll(parent.moduleIndexMap);
        this.classCount.set(parent.classCount.longValue());
        this.moduleCount.set(parent.moduleCount.intValue());
        this.methodCount.set(parent.methodCount.longValue());
        this.compilerFactory = parent.compilerFactory;
        this.classEntityFetchHandler = new ArrayList<EntityFetchHandler>(parent.classEntityFetchHandler);
        this.functionEntityFetchHandler = new ArrayList<EntityFetchHandler>(parent.functionEntityFetchHandler);
        this.constantEntityFetchHandler = new ArrayList<EntityFetchHandler>(parent.constantEntityFetchHandler);
        this.extensions.putAll(parent.extensions);
        this.tickHandler = parent.tickHandler;
        this.programShutdownHandlers = new ArrayList<ProgramShutdownHandler>(parent.programShutdownHandlers);
    }

    public CompileScope() {
        this(new RuntimeClassLoader(Thread.currentThread().getContextClassLoader()));
    }

    public CompileScope(RuntimeClassLoader classLoader) {
        this.id = scopeCount.getAndIncrement();
        this.classLoader = classLoader;
        this.moduleMap = new ConcurrentHashMap();
        this.moduleIndexMap = new ConcurrentHashMap();
        this.classMap = new HashMap<String, ClassEntity>();
        this.functionMap = new HashMap<String, FunctionEntity>();
        this.constantMap = new HashMap<String, ConstantEntity>();
        this.extensions = new LinkedHashMap<String, Extension>();
        this.compileConstantMap = new HashMap<String, CompileConstant>();
        this.compileFunctionMap = new HashMap<String, CompileFunction>();
        this.compileFunctionSpecMap = new HashMap<String, CompileFunctionSpec>();
        this.compileClassMap = new HashMap<String, CompileClass>();
        this.exceptionMap = new HashMap<Class<? extends Throwable>, Class<? extends JavaException>>();
        this.exceptionMapForContext = new HashMap<String, Class<? extends JavaException>>();
        this.classEntityFetchHandler = new ArrayList<EntityFetchHandler>();
        this.constantEntityFetchHandler = new ArrayList<EntityFetchHandler>();
        this.functionEntityFetchHandler = new ArrayList<EntityFetchHandler>();
        this.programShutdownHandlers = new ArrayList<ProgramShutdownHandler>();
        this.superGlobals = new HashSet<String>();
        this.superGlobals.add("GLOBALS");
        this.superGlobals.add("_ENV");
        try {
            Class<?> jvmCompilerClass = Class.forName("org.develnext.jphp.core.compiler.jvm.JvmCompiler");
            final Constructor<?> jvmConstructor = jvmCompilerClass.getConstructor(Environment.class, Context.class);
            this.compilerFactory = new CompilerFactory(){

                @Override
                public AbstractCompiler getCompiler(Environment env, Context context) throws Throwable {
                    return (AbstractCompiler)jvmConstructor.newInstance(env, context);
                }
            };
        }
        catch (ClassNotFoundException | NoSuchMethodException jvmCompilerClass) {
            // empty catch block
        }
        CoreExtension extension = new CoreExtension();
        this.registerLazyClass(extension, Closure.class);
        this.registerLazyClass(extension, Generator.class);
        this.registerLazyClass(extension, StdClass.class);
        this.registerLazyClass(extension, BaseThrowable.class);
        this.registerLazyClass(extension, BaseException.class);
        this.registerLazyClass(extension, BaseError.class);
        this.registerLazyClass(extension, BaseParseError.class);
        this.registerLazyClass(extension, BaseTypeError.class);
        this.registerLazyClass(extension, BaseArithmeticError.class);
        this.registerLazyClass(extension, BaseDivisionByZeroError.class);
        this.registerLazyClass(extension, ErrorException.class);
        this.registerLazyClass(extension, ArrayAccess.class);
        this.registerLazyClass(extension, Traversable.class);
        this.registerLazyClass(extension, Iterator.class);
        this.registerLazyClass(extension, IteratorAggregate.class);
        this.registerLazyClass(extension, Serializable.class);
        this.registerExtension(new JavaExtension());
        this.registerExtension(new NetExtension());
        this.registerExtension(extension);
    }

    public AbstractCompiler createCompiler(Environment env, Context context) throws Throwable {
        if (this.compilerFactory == null) {
            throw new NullPointerException("compilerFactory is not set");
        }
        try {
            return this.compilerFactory.getCompiler(env, context);
        }
        catch (InvocationTargetException e) {
            env.__throwException(e);
            return null;
        }
    }

    public RuntimeClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setNativeClassLoader(ClassLoader classLoader) {
        this.classLoader = new RuntimeClassLoader(classLoader);
    }

    public LangMode getLangMode() {
        return this.langMode;
    }

    public void setLangMode(LangMode langMode) {
        this.langMode = langMode;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(boolean debugMode) {
        this.debugMode = debugMode;
    }

    public Map<String, ClassEntity> getClassMap() {
        return this.classMap;
    }

    public Map<String, FunctionEntity> getFunctionMap() {
        return this.functionMap;
    }

    public Map<String, ConstantEntity> getConstantMap() {
        return this.constantMap;
    }

    public int nextModuleIndex() {
        return this.moduleCount.incrementAndGet();
    }

    public long nextClassIndex() {
        return this.classCount.incrementAndGet();
    }

    public long nextMethodIndex() {
        return this.methodCount.incrementAndGet();
    }

    public void setTickHandler(TickHandler tickHandler) {
        this.tickHandler = tickHandler;
    }

    public TickHandler getTickHandler() {
        return this.tickHandler;
    }

    public void registerLazyClass(Extension extension, Class<?> clazz) {
        CompileClass el = new CompileClass(extension, clazz);
        this.compileClassMap.put(el.getLowerName(), el);
    }

    public void registerExtension(String extClass) {
        try {
            this.registerExtension(Class.forName(extClass));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerExtension(Class<? extends Extension> extClass) {
        try {
            this.registerExtension(extClass.newInstance());
        }
        catch (Exception e) {
            throw new CriticalException(e);
        }
    }

    public void registerExtension(Extension extension) {
        long t = System.currentTimeMillis();
        if (this.extensions.containsKey(extension.getName())) {
            return;
        }
        for (String dep : extension.getRequiredExtensions()) {
            try {
                Extension el = (Extension)Class.forName(dep).newInstance();
                this.registerExtension(el);
            }
            catch (Exception e) {
                throw new CriticalException(e);
            }
        }
        for (String dep : extension.getOptionalExtensions()) {
            try {
                Extension el2 = (Extension)Class.forName(dep).newInstance();
                this.registerExtension(el2);
            }
            catch (ClassNotFoundException el2) {
            }
            catch (Exception e) {
                throw new CriticalException(e);
            }
        }
        for (String dep : extension.getConflictExtensions()) {
            if (!this.extensions.containsKey(dep)) continue;
            throw new ConflictException("'" + dep + "' extension conflicts with '" + extension.getClass().getName() + "'");
        }
        extension.onRegister(this);
        this.compileConstantMap.putAll(extension.getConstants());
        this.compileFunctionSpecMap.putAll(extension.getFunctions());
        for (Class clazz : extension.getClasses().values()) {
            this.registerLazyClass(extension, clazz);
        }
        for (CompileFunctionSpec compileFunctionSpec : extension.getFunctions().values()) {
            this.functionMap.put(compileFunctionSpec.getLowerName(), new CompileFunctionEntity(extension, compileFunctionSpec));
        }
        this.extensions.put(extension.getName().toLowerCase(), extension);
        if (Startup.isTracing()) {
            Startup.traceWithTime("Register extension '" + extension.getName() + "'", t);
        }
    }

    public Extension getExtension(String name) {
        return this.extensions.get(name.toLowerCase());
    }

    public Set<String> getExtensions() {
        return this.extensions.keySet();
    }

    public void addClassEntityFetchHandler(EntityFetchHandler classEntityFetchHandler) {
        this.classEntityFetchHandler.add(classEntityFetchHandler);
    }

    public void addFunctionEntityFetchHandler(EntityFetchHandler functionEntityFetchHandler) {
        this.functionEntityFetchHandler.add(functionEntityFetchHandler);
    }

    public void addConstantEntityFetchHandler(EntityFetchHandler constantEntityFetchHandler) {
        this.constantEntityFetchHandler.add(constantEntityFetchHandler);
    }

    public void registerJavaException(Class<? extends JavaException> clazz, Class<? extends Throwable> throwClazz) {
        this.exceptionMap.put(throwClazz, clazz);
    }

    public void registerJavaExceptionForContext(Class<? extends JavaException> clazz, Class<? extends IObject> context) {
        this.exceptionMapForContext.put(ReflectionUtils.getClassName(context).toLowerCase(), clazz);
    }

    public void registerClass(String name, ClassEntity entity) {
        this.classMap.put(name.toLowerCase(), entity);
    }

    public void registerClass(ClassEntity clazz) {
        this.classMap.put(clazz.getLowerName(), clazz);
    }

    public void registerModule(ModuleEntity module) {
        this.addUserModule(module);
        for (ClassEntity classEntity : module.getClasses()) {
            if (!classEntity.isStatic() || this.classMap.put(classEntity.getLowerName(), classEntity) == null) continue;
            throw new CriticalException(Messages.ERR_CANNOT_REDECLARE_CLASS.fetch(classEntity.getName()));
        }
        for (FunctionEntity functionEntity : module.getFunctions()) {
            if (!functionEntity.isStatic() || this.functionMap.put(functionEntity.getLowerName(), functionEntity) == null) continue;
            throw new CriticalException(Messages.ERR_CANNOT_REDECLARE_FUNCTION.fetch(functionEntity.getName()));
        }
        for (ConstantEntity constantEntity : module.getConstants()) {
            if (this.constantMap.put(constantEntity.getLowerName(), constantEntity) == null) continue;
            throw new CriticalException(Messages.ERR_CANNOT_REDECLARE_CONSTANT.fetch(constantEntity.getName()));
        }
    }

    public void registerProgramShutdownHandler(ProgramShutdownHandler shutdownHandler) {
        this.programShutdownHandlers.add(shutdownHandler);
    }

    public void addUserModule(ModuleEntity module) {
        this.moduleMap.put(module.getName(), module);
        this.moduleIndexMap.put(module.getInternalName(), module);
    }

    public void registerFunction(FunctionEntity function) {
        this.functionMap.put(function.getLowerName(), function);
    }

    public void registerConstant(ConstantEntity constant) {
        this.constantMap.put(constant.getLowerName(), constant);
    }

    public ModuleEntity findUserModule(String name) {
        return this.moduleMap.get(name);
    }

    public ClassEntity fetchUserClass(Class<? extends IObject> clazz) {
        return this.fetchUserClass(ReflectionUtils.getClassName(clazz));
    }

    public ClassEntity fetchUserClass(String name) {
        return this.fetchUserClass(name, name.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassEntity fetchUserClass(String name, String nameLower) {
        ClassEntity entity;
        if (this.classEntityFetchHandler != null) {
            for (EntityFetchHandler handler : this.classEntityFetchHandler) {
                handler.fetch(this, name, nameLower);
            }
        }
        if ((entity = this.classMap.get(nameLower)) != null) {
            return entity;
        }
        CompileClass compileClass = this.compileClassMap.get(nameLower);
        if (compileClass == null) {
            return null;
        }
        entity = new ClassEntity(new ClassWrapper(compileClass.getExtension(), this, compileClass.getNativeClass()));
        entity.setId(this.nextClassIndex());
        Map<String, ClassEntity> map = this.classMap;
        synchronized (map) {
            this.classMap.put(name, entity);
        }
        return entity;
    }

    public FunctionEntity findUserFunction(String name) {
        String originName = name;
        FunctionEntity entity = this.functionMap.get(name = name.toLowerCase());
        if (entity == null && this.functionEntityFetchHandler != null) {
            for (EntityFetchHandler handler : this.functionEntityFetchHandler) {
                handler.fetch(this, originName, name);
            }
            entity = this.functionMap.get(name);
        }
        return entity;
    }

    public ConstantEntity findUserConstant(String name) {
        String originName = name;
        ConstantEntity entity = this.constantMap.get((name = name.toLowerCase()).toLowerCase());
        if (entity == null && this.constantEntityFetchHandler != null) {
            for (EntityFetchHandler handler : this.constantEntityFetchHandler) {
                handler.fetch(this, originName, name);
            }
            entity = this.constantMap.get(name);
        }
        return entity;
    }

    public Collection<ConstantEntity> getConstants() {
        return this.constantMap.values();
    }

    public CompileConstant findCompileConstant(String name) {
        return this.compileConstantMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompileFunction findCompileFunction(String name) {
        CompileFunction function = this.compileFunctionMap.get(name = name.toLowerCase());
        if (function != null) {
            return function;
        }
        CompileScope compileScope = this;
        synchronized (compileScope) {
            CompileFunctionSpec functionSpec = this.compileFunctionSpecMap.get(name);
            if (functionSpec == null) {
                return null;
            }
            function = functionSpec.toFunction();
            this.compileFunctionMap.put(name, function);
        }
        return function;
    }

    public CompileClass findCompileClass(String name) {
        return this.compileClassMap.get(name.toLowerCase());
    }

    public Class<? extends JavaException> findJavaException(Class<? extends Throwable> clazz) {
        return this.exceptionMap.get(clazz);
    }

    public Class<? extends JavaException> findJavaExceptionForContext(String className) {
        return this.exceptionMapForContext.get(className);
    }

    public ModuleEntity loadModule(String name, boolean withBytecode) {
        ModuleEntity entity = this.findUserModule(name);
        if (entity == null) {
            return null;
        }
        this.classLoader.loadModule(entity, withBytecode);
        return entity;
    }

    public ModuleEntity loadModule(String name) {
        return this.loadModule(name, true);
    }

    public void loadModule(ModuleEntity module, boolean withBytecode) {
        this.classLoader.loadModule(module, withBytecode);
    }

    public void loadModule(ModuleEntity module) {
        this.loadModule(module, true);
    }

    public JVMStackTracer getStackTracer(StackTraceElement[] elements) {
        return new JVMStackTracer(this.classLoader, elements);
    }

    public JVMStackTracer getStackTracer(Throwable throwable) {
        return this.getStackTracer(throwable.getStackTrace());
    }

    public JVMStackTracer getStackTracer() {
        return this.getStackTracer(Thread.currentThread().getStackTrace());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompileScope)) {
            return false;
        }
        CompileScope that = (CompileScope)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return this.id;
    }

    public void triggerProgramShutdown(Environment env) {
        for (ProgramShutdownHandler handler : this.programShutdownHandlers) {
            handler.onShutdown(this, env);
        }
    }
}

