/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.common.StringUtils;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;

public class FileFunctions
extends FunctionsContainer {
    @Runtime.Immutable
    public static String basename(String path, String suffix) {
        String result = new File(path).getName();
        if (suffix != null && !suffix.isEmpty() && result.endsWith(suffix)) {
            result = result.substring(0, result.length() - suffix.length());
        }
        return result;
    }

    @Runtime.Immutable
    public static String basename(String path) {
        return FileFunctions.basename(path, null);
    }

    public static boolean chgrp(String fileName, Memory group) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copy(Environment env, TraceInfo trace, String source, String dest) throws Throwable {
        RandomAccessFile outputStream;
        Stream stream = Stream.create(env, source, "r");
        if (stream == null) {
            env.warning("copy(): Invalid source path", new Object[0]);
            return false;
        }
        Memory value = stream.readFully(env, new Memory[0]);
        try {
            outputStream = new RandomAccessFile(dest, "rw");
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            outputStream.setLength(0L);
            outputStream.write(value.getBinaryBytes(env.getDefaultCharset()));
            boolean e = true;
            return e;
        }
        catch (IOException e) {
            env.warning("copy(): " + e.getMessage(), new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    @Runtime.Immutable
    public static String dirname(String path) {
        String r = new File(path).getParent();
        if (r == null) {
            return "";
        }
        return r;
    }

    public static Memory disk_free_space(String path) {
        return LongMemory.valueOf(new File(path).getFreeSpace());
    }

    public static Memory disk_total_space(String path) {
        return LongMemory.valueOf(new File(path).getTotalSpace());
    }

    public static Memory diskfreespace(String path) {
        return FileFunctions.disk_free_space(path);
    }

    public static boolean file_exists(String path) {
        return new File(path).getAbsoluteFile().exists();
    }

    public static Memory file(Environment env, TraceInfo trace, String path, int flags) throws Throwable {
        return FileFunctions.file(env, trace, path, flags, Memory.NULL);
    }

    public static Memory file(Environment env, TraceInfo trace, String path) throws Throwable {
        return FileFunctions.file(env, trace, path, 0, Memory.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory file(Environment env, TraceInfo trace, String path, int flags, Memory context) throws Throwable {
        Stream stream = null;
        try {
            int i;
            stream = Stream.create(env, path, "r");
            if (stream == null) {
                env.warning(trace, "file(): failed to open stream", new Object[0]);
                Memory memory = Memory.FALSE;
                return memory;
            }
            stream.setContext(env, context);
            Memory value = env.invokeMethod(trace, stream, "readFully", new Memory[0]);
            byte[] bytes = value.getBinaryBytes(env.getDefaultCharset());
            ArrayMemory result = new ArrayMemory();
            int prev = 0;
            boolean ignoreNewLines = (flags & 2) == 2;
            for (i = 0; i < bytes.length; ++i) {
                byte ch = bytes[i];
                if (ch != 10) continue;
                if (prev == i && (flags & 4) == 4) {
                    ++prev;
                    continue;
                }
                byte[] chunk = ignoreNewLines ? Arrays.copyOfRange(bytes, prev, i - 1) : Arrays.copyOfRange(bytes, prev, i);
                prev = i + 1;
                result.add(new BinaryMemory(chunk));
            }
            if (prev != i) {
                byte[] chunk = Arrays.copyOfRange(bytes, prev, i);
                result.add(new BinaryMemory(chunk));
            }
            ArrayMemory arrayMemory = result.toConstant();
            return arrayMemory;
        }
        catch (WrapIOException e) {
            if (stream == null && (flags & 1) == 1 && (path = env.findInIncludePaths(path)) != null) {
                Memory memory = FileFunctions.file(env, trace, path, flags ^ 1, context);
                return memory;
            }
            env.warning(trace, "file(): " + e.getMessage(), new Object[0]);
            Memory memory = Memory.FALSE;
            return memory;
        }
        finally {
            if (stream != null) {
                stream.close(env, new Memory[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory file_get_contents(Environment env, TraceInfo trace, String path, boolean useIncludePaths, Memory context, Memory offset, Memory maxLength) throws Throwable {
        Stream stream = null;
        try {
            stream = Stream.create(env, path, "r");
            if (stream == null) {
                env.warning(trace, "file_get_contents(): failed to open stream", new Object[0]);
                Memory memory = Memory.FALSE;
                return memory;
            }
            stream.setContext(env, context);
            if (offset.toLong() > 0L) {
                stream.seek(env, offset);
            }
            if (maxLength.isNull()) {
                Memory memory = stream.readFully(env, LongMemory.valueOf(4096));
                return memory;
            }
            Memory memory = stream.read(env, maxLength);
            return memory;
        }
        catch (IOException | WrapIOException e) {
            if (stream == null && useIncludePaths && (path = env.findInIncludePaths(path)) != null) {
                Memory memory = FileFunctions.file_get_contents(env, trace, path, false, context, offset, maxLength);
                return memory;
            }
            env.warning(trace, "file_get_contents(): " + e.getMessage(), new Object[0]);
            Memory memory = Memory.FALSE;
            return memory;
        }
        finally {
            if (stream != null) {
                stream.close(env, new Memory[0]);
            }
        }
    }

    public static Memory file_get_contents(Environment env, TraceInfo trace, String path, boolean useIncludePaths, Memory context, Memory offset) throws Throwable {
        return FileFunctions.file_get_contents(env, trace, path, useIncludePaths, context, offset, Memory.NULL);
    }

    public static Memory file_get_contents(Environment env, TraceInfo trace, String path, boolean useIncludePaths, Memory context) throws Throwable {
        return FileFunctions.file_get_contents(env, trace, path, useIncludePaths, context, Memory.CONST_INT_M1, Memory.NULL);
    }

    public static Memory file_get_contents(Environment env, TraceInfo trace, String path, boolean useIncludePaths) throws Throwable {
        return FileFunctions.file_get_contents(env, trace, path, useIncludePaths, Memory.NULL, Memory.CONST_INT_M1, Memory.NULL);
    }

    public static Memory file_get_contents(Environment env, TraceInfo trace, String path) throws Throwable {
        return FileFunctions.file_get_contents(env, trace, path, true, Memory.NULL, Memory.CONST_INT_M1, Memory.NULL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Memory file_put_contents(Environment env, TraceInfo trace, String path, Memory data, int flags, Memory context) throws Throwable {
        Stream stream = null;
        try {
            String mode = "w";
            if ((flags & 8) == 8) {
                mode = "a";
            }
            if ((stream = Stream.create(env, path, mode)) == null) {
                env.warning(trace, "file_put_contents(): failed to open stream", new Object[0]);
                Memory memory = Memory.FALSE;
                return memory;
            }
            stream.setContext(env, context);
            if (data.instanceOf("php\\io\\Stream")) {
                data = env.invokeMethod(trace, data, "readFully", new Memory[0]);
            }
            Memory memory = stream.write(env, data, Memory.NULL);
            return memory;
        }
        catch (WrapIOException e) {
            env.warning(trace, "file_put_contents(): " + e.getMessage(), new Object[0]);
            Memory memory = Memory.FALSE;
            return memory;
        }
        finally {
            if (stream != null) {
                stream.close(env, new Memory[0]);
            }
        }
    }

    public static Memory file_put_contents(Environment env, TraceInfo trace, String path, Memory data, int flags) throws Throwable {
        return FileFunctions.file_put_contents(env, trace, path, data, flags, Memory.NULL);
    }

    public static Memory file_put_contents(Environment env, TraceInfo trace, String path, Memory data) throws Throwable {
        return FileFunctions.file_put_contents(env, trace, path, data, 0, Memory.NULL);
    }

    public static boolean is_dir(String path) {
        return new File(path).isDirectory();
    }

    public static boolean is_file(String path) {
        return new File(path).isFile();
    }

    public static boolean is_link(String path) {
        try {
            File canon;
            File file = new File(path);
            if (file.getParent() == null) {
                canon = file;
            } else {
                File canonDir = file.getParentFile().getCanonicalFile();
                canon = new File(canonDir, file.getName());
            }
            return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean is_executable(String path) {
        return new File(path).canExecute();
    }

    public static boolean is_readable(String path) {
        return new File(path).canRead();
    }

    public static boolean is_writable(String path) {
        return new File(path).canWrite();
    }

    public static boolean is_writeable(String path) {
        return new File(path).canWrite();
    }

    public static boolean mkdir(String path, int mode, boolean recursive) {
        if (recursive) {
            return new File(path).mkdirs();
        }
        return new File(path).mkdir();
    }

    public static boolean mkdir(String path, int mode) {
        return FileFunctions.mkdir(path, mode, false);
    }

    public static boolean mkdir(String path) {
        return FileFunctions.mkdir(path, 777, false);
    }

    public static Memory filemtime(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            return LongMemory.valueOf(Files.getLastModifiedTime(file, new LinkOption[0]).toMillis() / 1000L);
        }
        catch (IOException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory fileatime(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return LongMemory.valueOf(attributes.lastAccessTime().toMillis() / 1000L);
        }
        catch (IOException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory filectime(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            return LongMemory.valueOf(attributes.creationTime().toMillis() / 1000L);
        }
        catch (IOException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory filesize(Environment env, TraceInfo trace, String path) {
        try {
            return LongMemory.valueOf(new File(path).length());
        }
        catch (Exception e) {
            env.warning(trace, "filesize(): file not found - %s", path);
            return Memory.FALSE;
        }
    }

    public static Memory filetype(Environment env, TraceInfo trace, String path) {
        File file = new File(path);
        if (file.isFile()) {
            return new StringMemory("file");
        }
        if (file.isDirectory()) {
            return new StringMemory("dir");
        }
        try {
            BasicFileAttributes attributes = Files.readAttributes(Paths.get(path, new String[0]), BasicFileAttributes.class, new LinkOption[0]);
            if (attributes.isSymbolicLink()) {
                return new StringMemory("link");
            }
            return new StringMemory("unknown");
        }
        catch (IOException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    public static Memory filegroup(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            int attribute = (Integer)Files.getAttribute(file, "unix:gid", new LinkOption[0]);
            return LongMemory.valueOf(attribute);
        }
        catch (IOException | SecurityException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory fileowner(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            int attribute = (Integer)Files.getAttribute(file, "unix:uid", new LinkOption[0]);
            return LongMemory.valueOf(attribute);
        }
        catch (IOException | SecurityException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory fileperms(Environment env, TraceInfo trace, String path) {
        Path file = Paths.get(path, new String[0]);
        try {
            int attribute = (Integer)Files.getAttribute(file, "unix:mode", new LinkOption[0]);
            return LongMemory.valueOf(attribute);
        }
        catch (IOException | SecurityException e) {
            env.warning(trace, e.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
        catch (UnsupportedOperationException e) {
            return Memory.FALSE;
        }
    }

    public static Memory pathinfo(String path, int options) {
        File file = new File(path);
        ArrayMemory result = new ArrayMemory();
        String basename = file.getName();
        int pos = basename.lastIndexOf(46);
        String ext = null;
        if (pos > -1) {
            ext = basename.substring(pos + 1);
        }
        if ((options & 1) == 1) {
            result.refOfIndex("dirname").assign(file.getParent());
        }
        if ((options & 1) == 1) {
            result.refOfIndex("basename").assign(file.getName());
        }
        if (ext != null && (options & 3) == 3) {
            result.refOfIndex("extension").assign(ext);
        }
        if ((options & 4) == 4) {
            result.refOfIndex("filename").assign(pos > -1 ? basename.substring(0, pos) : basename);
        }
        return result.toConstant();
    }

    public static Memory pathinfo(String path) {
        return FileFunctions.pathinfo(path, 7);
    }

    public static boolean rename(String oldname, String newname) {
        try {
            return new File(oldname).renameTo(new File(newname));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean rmdir(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            try {
                return file.delete();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean unlink(String path) {
        File file = new File(path);
        if (file.isDirectory()) {
            return false;
        }
        try {
            return file.delete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean touch(Environment env, TraceInfo trace, String path, long time, long atime) {
        File file = new File(path);
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    return false;
                }
            }
            catch (IOException e) {
                env.warning(trace, e.getMessage(), new Object[0]);
                return false;
            }
        }
        return file.setLastModified(time * 1000L);
    }

    public static boolean touch(Environment env, TraceInfo trace, String path, long time) {
        return FileFunctions.touch(env, trace, path, time, 0L);
    }

    public static boolean touch(Environment env, TraceInfo trace, String path) {
        return FileFunctions.touch(env, trace, path, System.currentTimeMillis() / 1000L, 0L);
    }

    public static Memory tempnam(String dir, String prefix) {
        try {
            return new StringMemory(File.createTempFile(prefix, "", new File(dir)).getPath());
        }
        catch (IOException e) {
            return Memory.FALSE;
        }
    }

    public static Memory realpath(String path) {
        try {
            return new StringMemory(new File(path).getCanonicalPath());
        }
        catch (IOException e) {
            return Memory.FALSE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Memory readfile(Environment env, TraceInfo trace, String path, boolean useIncludePaths, Memory stream) throws Throwable {
        File file = new File(path);
        if (useIncludePaths && !file.exists()) {
            if ((path = env.findInIncludePaths(path)) == null) {
                return Memory.FALSE;
            }
            file = new File(path);
        }
        try (RandomAccessFile accessFile = new RandomAccessFile(file, "r");){
            if (!stream.isNull()) {
                if (!stream.instanceOf("php\\io\\Stream")) {
                    env.warning(trace, "readfile(): Argument 3 must be stream, %s given", stream.getRealType().toString());
                    Memory memory = Memory.FALSE;
                    return memory;
                }
                byte[] buff = new byte[4096];
                int len = 0;
                int read = 0;
                while (true) {
                    if ((len = accessFile.read(buff)) == -1) {
                        Memory memory = LongMemory.valueOf(read);
                        return memory;
                    }
                    read += len;
                    ObjectInvokeHelper.invokeMethod(stream, "write", env, trace, new BinaryMemory(buff), LongMemory.valueOf(len));
                }
            }
            byte[] buff = new byte[4096];
            int len = 0;
            int read = 0;
            while ((len = accessFile.read(buff)) != -1) {
                read += len;
                env.echo(buff, len);
            }
            Memory memory = LongMemory.valueOf(read);
            return memory;
        }
        catch (FileNotFoundException e) {
            env.warning(trace, "readfile(): File not found - %s", path);
            return Memory.FALSE;
        }
        catch (IOException e) {
            env.warning(trace, "readfile(): %s", e.getMessage());
            return Memory.FALSE;
        }
    }

    public static Memory readfile(Environment env, TraceInfo trace, String path, boolean useIncludePaths) throws Throwable {
        return FileFunctions.readfile(env, trace, path, useIncludePaths, Memory.NULL);
    }

    public static Memory readfile(Environment env, TraceInfo trace, String path) throws Throwable {
        return FileFunctions.readfile(env, trace, path, false, Memory.NULL);
    }

    public static Memory fopen(Environment env, TraceInfo trace, String path, String mode) {
        try {
            return ObjectMemory.valueOf(Stream.create(env, path, mode));
        }
        catch (Throwable throwable) {
            env.warning(trace, "fopen(): failed to open stream, " + throwable.getMessage(), new Object[0]);
            return Memory.FALSE;
        }
    }

    public static Memory ftell(Environment env, TraceInfo trace, Memory stream) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                return env.invokeMethod(trace, stream, "getPosition", new Memory[0]);
            }
            catch (Throwable throwable) {
                env.warning(trace, "ftell(): " + throwable.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "ftell(): unable to get position from a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory feof(Environment env, TraceInfo trace, Memory stream) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                return env.invokeMethod(trace, stream, "eof", new Memory[0]);
            }
            catch (Throwable throwable) {
                env.warning(trace, "feof(): " + throwable.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "feof(): unable get eof from a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory fread(Environment env, TraceInfo trace, Memory stream, int length) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                return env.invokeMethod(trace, stream, "read", LongMemory.valueOf(length));
            }
            catch (Throwable throwable) {
                env.warning(trace, "fread(): " + throwable.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "fread(): unable to read from a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory fgetc(Environment env, TraceInfo trace, Memory stream) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                Memory memory = env.invokeMethod(trace, stream, "read", Memory.CONST_INT_1);
                return memory.isNull() ? Memory.FALSE : memory;
            }
            catch (Throwable throwable) {
                env.warning(trace, "fgetc(): " + throwable.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "fgetc(): unable to read from a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory fseek(Environment env, TraceInfo trace, Memory stream, long offset) {
        return FileFunctions.fseek(env, trace, stream, offset, 0);
    }

    public static Memory fseek(Environment env, TraceInfo trace, Memory stream, long offset, int whence) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                switch (whence) {
                    case 1: {
                        offset += env.invokeMethod(trace, stream, "getPosition", new Memory[0]).toLong();
                        break;
                    }
                    case 2: {
                        env.error(trace, "fseek(): flag SEEK_END is not supported.", new Object[0]);
                        break;
                    }
                }
                env.invokeMethod(trace, stream, "seek", LongMemory.valueOf(offset));
                return Memory.CONST_INT_0;
            }
            catch (Throwable throwable) {
                env.warning(trace, "fseek(): " + throwable.getMessage(), new Object[0]);
                return Memory.CONST_INT_M1;
            }
        }
        env.warning(trace, "fseek(): unable to seek in a non-stream", new Object[0]);
        return Memory.CONST_INT_M1;
    }

    public static Memory fputs(Environment env, TraceInfo trace, Memory stream, Memory value) {
        return FileFunctions.fwrite(env, trace, stream, value);
    }

    public static Memory fputs(Environment env, TraceInfo trace, Memory stream, Memory value, Memory length) {
        return FileFunctions.fwrite(env, trace, stream, value, length);
    }

    public static Memory fgets(Environment env, TraceInfo trace, Memory stream) {
        return FileFunctions.fgets(env, trace, stream, Memory.NULL);
    }

    public static Memory fgets(Environment env, TraceInfo trace, Memory stream, Memory length) {
        InputStream in;
        if (stream.instanceOf("php\\io\\Stream") && (in = Stream.getInputStream(env, stream)) != null) {
            StringBuilder sb = new StringBuilder();
            try {
                int read;
                while (!((read = in.read()) == -1 || length.isNotNull() && sb.length() >= length.toInteger() || read == 10 || read == 13)) {
                    sb.append((char)read);
                }
                return StringMemory.valueOf(sb.toString());
            }
            catch (IOException e) {
                env.warning(trace, "fgets(): " + e.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "fgets(): unable to get from a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory fwrite(Environment env, TraceInfo trace, Memory stream, Memory value) {
        return FileFunctions.fwrite(env, trace, stream, value, Memory.NULL);
    }

    public static Memory fwrite(Environment env, TraceInfo trace, Memory stream, Memory value, Memory length) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                return env.invokeMethod(trace, stream, "write", value, length);
            }
            catch (Throwable throwable) {
                env.warning(trace, "fwrite(): " + throwable.getMessage(), new Object[0]);
                return Memory.FALSE;
            }
        }
        env.warning(trace, "fwrite(): unable to write to a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static Memory fclose(Environment env, TraceInfo trace, Memory stream) {
        if (stream.instanceOf("php\\io\\Stream")) {
            try {
                env.invokeMethod(trace, stream, "close", new Memory[0]);
                return Memory.TRUE;
            }
            catch (Throwable throwable) {
                return Memory.FALSE;
            }
        }
        env.warning("fclose(): unable to close a non-stream", new Object[0]);
        return Memory.FALSE;
    }

    public static String getcwd() {
        Path currentRelativePath = Paths.get("", new String[0]);
        return currentRelativePath.toAbsolutePath().toString();
    }

    public static String getenv(Environment env, String name) {
        String s;
        Map zendEnv = env.getUserValue("env", Map.class);
        if (zendEnv != null && (s = (String)zendEnv.get(name)) != null) {
            return s;
        }
        return System.getenv(name);
    }

    public static synchronized void putenv(Environment env, String _value) {
        if (_value.isEmpty()) {
            return;
        }
        String[] strings = StringUtils.split(_value, "=", 2);
        String name = strings[0];
        String value = strings.length > 1 ? strings[1] : null;
        HashMap<String, String> zendEnv = env.getUserValue("env", Map.class);
        if (zendEnv == null) {
            zendEnv = new HashMap<String, String>();
            env.setUserValue("env", zendEnv);
        }
        if (value == null) {
            zendEnv.remove(name);
        } else {
            zendEnv.put(name, value);
        }
    }

    public static Memory scandir(String path, int order) {
        ArrayMemory r = new ArrayMemory();
        Object[] list = new File(path).list();
        switch (order) {
            case 1: {
                Arrays.sort(list, Collections.reverseOrder());
                for (Object s : list) {
                    r.add((String)s);
                }
                r.add("..");
                r.add(".");
                break;
            }
            case 0: {
                r.add(".");
                r.add("..");
                Arrays.sort(list);
                for (Object s : list) {
                    r.add((String)s);
                }
                break;
            }
            default: {
                r.add(".");
                r.add("..");
                for (Object s : list) {
                    r.add((String)s);
                }
            }
        }
        return r.toConstant();
    }

    public static Memory scandir(String path) {
        return FileFunctions.scandir(path, 0);
    }
}

