/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import org.develnext.jphp.json.gson.MemoryDeserializer;
import org.develnext.jphp.json.gson.MemorySerializer;
import org.develnext.jphp.zend.ext.json.JsonExtension;
import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.env.Environment;
import php.runtime.ext.support.compile.FunctionsContainer;
import php.runtime.memory.StringMemory;

public class JsonFunctions
extends FunctionsContainer {
    public static Memory json_decode(Environment env, String json, boolean assoc, int depth) {
        MemoryDeserializer memoryDeserializer = new MemoryDeserializer();
        memoryDeserializer.setEnv(env);
        GsonBuilder gsonBuilder = JsonExtension.createGsonBuilderForDecode(memoryDeserializer);
        memoryDeserializer.setAssoc(assoc);
        memoryDeserializer.setMaxDepth(depth);
        Gson gson = gsonBuilder.create();
        try {
            env.setUserValue(JsonFunctions.class.getName() + "#error", null);
            Memory r = gson.fromJson(json, Memory.class);
            if (r == null) {
                return Memory.NULL;
            }
            return assoc ? r.toImmutable() : r;
        }
        catch (MemoryDeserializer.MaxDepthException e) {
            env.setUserValue(JsonFunctions.class.getName() + "#error", 1);
        }
        catch (JsonSyntaxException e) {
            env.setUserValue(JsonFunctions.class.getName() + "#error", 4);
        }
        catch (JsonParseException e) {
            env.setUserValue(JsonFunctions.class.getName() + "#error", 2);
        }
        return Memory.NULL;
    }

    public static Memory json_decode(Environment env, String json, boolean assoc) {
        return JsonFunctions.json_decode(env, json, assoc, 512);
    }

    public static int json_last_error(Environment env) {
        Integer error = env.getUserValue(JsonFunctions.class.getName() + "#error", Integer.class);
        if (error == null) {
            return 0;
        }
        return error;
    }

    public static Memory json_last_error_msg(Environment env) {
        switch (JsonFunctions.json_last_error(env)) {
            case 0: {
                return Memory.NULL;
            }
            case 1: {
                return new StringMemory("Maximum stack depth exceeded");
            }
            case 2: {
                return new StringMemory("Underflow or the modes mismatch");
            }
            case 4: {
                return new StringMemory("Syntax error, malformed JSON");
            }
            case 5: {
                return new StringMemory("Malformed UTF-8 characters, possibly incorrectly encoded");
            }
            case 3: {
                return new StringMemory("Unexpected control character found");
            }
        }
        return Memory.NULL;
    }

    public static Memory json_decode(Environment env, String json) {
        return JsonFunctions.json_decode(env, json, false);
    }

    @Runtime.Immutable
    public static String json_encode(Memory memory, int options) {
        GsonBuilder builder;
        if (options != 0) {
            MemorySerializer serializer = new MemorySerializer();
            builder = JsonExtension.createGsonBuilder(serializer);
            if ((options & 0x80) == 128) {
                builder.setPrettyPrinting();
            }
            if ((options & 1) != 1) {
                builder.disableHtmlEscaping();
            }
            if ((options & 0x10) == 16) {
                serializer.setForceObject(true);
            }
            if ((options & 0x20) == 32) {
                serializer.setNumericCheck(true);
            }
        } else {
            builder = JsonExtension.DEFAULT_GSON_BUILDER;
        }
        Gson gson = builder.create();
        return gson.toJson(memory);
    }

    @Runtime.Immutable
    public static String json_encode(Memory memory) {
        return JsonFunctions.json_encode(memory, 0);
    }
}

