/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javafx.animation.AnimationTimer;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Window;

public class KeyboardManager {
    private static final KeyCombination.Modifier[] POSSIBLE_MODIFIERS = new KeyCombination.Modifier[]{KeyCombination.SHIFT_DOWN, KeyCombination.SHIFT_ANY, KeyCombination.CONTROL_DOWN, KeyCombination.CONTROL_ANY, KeyCombination.ALT_DOWN, KeyCombination.ALT_ANY, KeyCombination.META_DOWN, KeyCombination.META_ANY, KeyCombination.SHORTCUT_DOWN, KeyCombination.SHORTCUT_ANY};
    private final Window window;
    protected boolean altDown = false;
    protected boolean controlDown = false;
    protected boolean shiftDown = false;
    protected Map<KeyCode, KeyEvent> keys = new LinkedHashMap<KeyCode, KeyEvent>();
    protected Set<KeyCombination> keyHits = new HashSet<KeyCombination>();
    protected boolean keyGlobalHit = false;
    protected Map<KeyCombination, EventHandler<KeyEvent>> pressHandlers = new LinkedHashMap<KeyCombination, EventHandler<KeyEvent>>();
    protected Map<KeyCombination, EventHandler<KeyEvent>> downHandlers = new LinkedHashMap<KeyCombination, EventHandler<KeyEvent>>();
    protected Map<KeyCombination, EventHandler<KeyEvent>> upHandlers = new LinkedHashMap<KeyCombination, EventHandler<KeyEvent>>();
    private final EventHandler<KeyEvent> downEventFilter;
    private final EventHandler<KeyEvent> upEventFilter;
    protected AnimationTimer timer = new AnimationTimer(){

        public void handle(long now) {
            KeyboardManager.this.trigger(true);
        }
    };

    public KeyboardManager(Window window) {
        this.window = window;
        this.downEventFilter = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyboardManager.this.triggerDown(event);
            }
        };
        window.addEventFilter(KeyEvent.KEY_PRESSED, this.downEventFilter);
        this.upEventFilter = new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyboardManager.this.triggerUp(event);
            }
        };
        window.addEventFilter(KeyEvent.KEY_RELEASED, this.upEventFilter);
        this.timer.start();
    }

    public void free() {
        this.window.removeEventFilter(KeyEvent.KEY_PRESSED, this.downEventFilter);
        this.window.removeEventFilter(KeyEvent.KEY_RELEASED, this.upEventFilter);
    }

    public void setOnPress(KeyCombination keyCode, EventHandler<KeyEvent> handler) {
        this.pressHandlers.put(keyCode, handler);
    }

    public EventHandler<KeyEvent> getOnPress(KeyCombination keyCode) {
        return this.pressHandlers.get(keyCode);
    }

    public void setOnDown(KeyCombination keyCode, EventHandler<KeyEvent> handler) {
        this.downHandlers.put(keyCode, handler);
    }

    public EventHandler<KeyEvent> getOnDown(KeyCombination keyCode) {
        return this.downHandlers.get(keyCode);
    }

    public void setOnUp(KeyCombination keyCode, EventHandler<KeyEvent> handler) {
        this.upHandlers.put(keyCode, handler);
    }

    public EventHandler<KeyEvent> getOnUp(KeyCombination keyCode) {
        return this.upHandlers.get(keyCode);
    }

    protected void triggerDown(KeyEvent event) {
        if (event.isAltDown()) {
            this.altDown = true;
        }
        if (event.isControlDown()) {
            this.controlDown = true;
        }
        if (event.isShiftDown()) {
            this.shiftDown = true;
        }
        String name = event.getCode().getName();
        for (KeyCombination.Modifier modifier : POSSIBLE_MODIFIERS) {
            if (!modifier.toString().equals(name)) continue;
            return;
        }
        this.keys.put(event.getCode(), event);
    }

    protected void triggerUp(KeyEvent event) {
        this.trigger(false);
        if (event.isAltDown() || event.getCode() == KeyCode.ALT) {
            this.altDown = false;
        }
        if (event.isControlDown() || event.getCode() == KeyCode.CONTROL) {
            this.controlDown = false;
        }
        if (event.isShiftDown() || event.getCode() == KeyCode.SHIFT) {
            this.shiftDown = false;
        }
        this.keys.remove(event.getCode());
    }

    protected void trigger(boolean down) {
        ArrayList<KeyCombination.Modifier> modifiers = new ArrayList<KeyCombination.Modifier>();
        if (this.shiftDown) {
            modifiers.add(KeyCombination.SHIFT_DOWN);
        }
        if (this.controlDown) {
            modifiers.add(KeyCombination.CONTROL_DOWN);
        }
        if (this.altDown) {
            modifiers.add(KeyCombination.ALT_DOWN);
        }
        KeyCombination.Modifier[] modifiersArray = modifiers.toArray(new KeyCombination.Modifier[modifiers.size()]);
        for (Map.Entry<KeyCode, KeyEvent> entry : this.keys.entrySet()) {
            KeyCode code = entry.getKey();
            KeyCodeCombination keyCombination = new KeyCodeCombination(code, modifiersArray);
            this.trigger(keyCombination, down);
            if (modifiersArray.length <= 0) continue;
            keyCombination = new KeyCodeCombination(code, new KeyCombination.Modifier[0]);
            this.trigger(keyCombination, down);
        }
    }

    protected void trigger(KeyCodeCombination keyCombination, boolean down) {
        KeyCode code = keyCombination.getCode();
        if (down) {
            if (this.keyHits.add((KeyCombination)keyCombination)) {
                this.trigger((KeyCombination)keyCombination, code, this.downHandlers);
            }
            if (!this.keyGlobalHit) {
                this.keyGlobalHit = true;
                this.trigger(null, code, this.downHandlers);
            }
            this.trigger((KeyCombination)keyCombination, code, this.pressHandlers);
            this.trigger(null, code, this.pressHandlers);
        } else {
            this.keyHits.remove(keyCombination);
            this.trigger((KeyCombination)keyCombination, code, this.upHandlers);
            this.trigger(null, code, this.upHandlers);
        }
    }

    protected void trigger(KeyCombination keyCombination, KeyCode code, Map<KeyCombination, EventHandler<KeyEvent>> handlers) {
        EventHandler<KeyEvent> eventHandler = handlers.get(keyCombination);
        if (eventHandler != null) {
            KeyEvent event = new KeyEvent((Object)this.window, (EventTarget)this.window, KeyEvent.KEY_PRESSED, null, null, code, this.shiftDown, this.controlDown, this.altDown, false);
            eventHandler.handle((Event)event);
        }
    }
}

