/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes;

import java.util.ArrayList;
import javafx.collections.ObservableList;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseWrapper;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.ArrayAccess;
import php.runtime.lang.spl.Countable;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Abstract
@Reflection.Name(value="php\\gui\\UXList")
public class UXList<T>
extends BaseWrapper<ObservableList<T>>
implements Iterator,
Countable,
ArrayAccess {
    private int index = -1;

    public UXList(Environment env, ObservableList<T> wrappedObject) {
        super(env, wrappedObject);
    }

    public UXList(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        ForeachIterator iterator = this.getNewIterator(env);
        while (iterator.next()) {
            r.add(iterator.getValue().toImmutable());
        }
        return r.toConstant();
    }

    @Reflection.Signature
    public int indexOf(Environment env, Memory object) {
        return ((ObservableList)this.getWrappedObject()).indexOf(Memory.unwrap(env, object));
    }

    @Reflection.Signature
    public void replace(Environment env, Memory object, Memory newObject) {
        int index = this.indexOf(env, object);
        if (index != -1) {
            ((ObservableList)this.getWrappedObject()).add(index, Memory.unwrap(env, newObject));
            ((ObservableList)this.getWrappedObject()).remove(index + 1);
        }
    }

    @Reflection.Signature
    public boolean has(Environment env, Memory object) {
        for (Object t : (ObservableList)this.getWrappedObject()) {
            if (!Memory.wrap(env, t).equal(object)) continue;
            return true;
        }
        return false;
    }

    @Reflection.Signature
    public boolean add(Environment env, Memory object) {
        return ((ObservableList)this.getWrappedObject()).add(Memory.unwrap(env, object));
    }

    @Reflection.Signature
    public void insert(Environment env, int index, Memory object) {
        if (index >= 0) {
            ((ObservableList)this.getWrappedObject()).add(index, Memory.unwrap(env, object));
            return;
        }
        throw new IllegalArgumentException("index must be greater or equal to 0");
    }

    @Reflection.Signature
    public void addAll(Environment env, ForeachIterator iterator) throws Throwable {
        if (iterator == null) {
            return;
        }
        while (iterator.next()) {
            env.invokeMethod(this, "add", iterator.getValue());
        }
    }

    @Reflection.Signature
    public void setAll(Environment env, ForeachIterator iterator) throws Throwable {
        if (iterator == null) {
            return;
        }
        env.invokeMethod(this, "clear", new Memory[0]);
        while (iterator.next()) {
            env.invokeMethod(this, "add", iterator.getValue());
        }
    }

    @Reflection.Signature
    public void insertAll(Environment env, int index, ForeachIterator iterator) throws Throwable {
        ArrayList<Object> list = new ArrayList<Object>();
        while (iterator.next()) {
            list.add(Memory.unwrap(env, iterator.getValue()));
        }
        if (index < 0) {
            throw new IllegalArgumentException("index must be greater or equal to 0");
        }
        ((ObservableList)this.getWrappedObject()).addAll(index, list);
    }

    @Reflection.Signature
    public boolean remove(Environment env, Memory object) {
        return ((ObservableList)this.getWrappedObject()).remove(Memory.unwrap(env, object));
    }

    @Reflection.Signature
    public boolean removeByIndex(Environment env, int index) {
        return ((ObservableList)this.getWrappedObject()).remove(index) != null;
    }

    @Reflection.Signature
    public void clear() {
        ((ObservableList)this.getWrappedObject()).clear();
    }

    @Reflection.Signature
    public Memory last(Environment env) {
        ObservableList list = (ObservableList)this.getWrappedObject();
        if (list.isEmpty()) {
            return Memory.NULL;
        }
        return Memory.wrap(env, list.get(list.size() - 1));
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        if (this.index == -1) {
            return Memory.NULL;
        }
        return Memory.wrap(env, ((ObservableList)this.getWrappedObject()).get(this.index));
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        return this.index == -1 ? Memory.FALSE : LongMemory.valueOf(this.index);
    }

    @Override
    @Reflection.Signature
    public Memory next(Environment env, Memory ... args) {
        ++this.index;
        if (this.index >= ((ObservableList)this.getWrappedObject()).size()) {
            this.index = -1;
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        this.index = ((ObservableList)this.getWrappedObject()).isEmpty() ? -1 : 0;
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        return this.index >= 0 && this.index < ((ObservableList)this.getWrappedObject()).size() ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf(this).getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf(this).getNewIterator(env);
    }

    @Override
    public Memory count(Environment environment, Memory ... memories) {
        return LongMemory.valueOf(((ObservableList)this.getWrappedObject()).size());
    }

    @Reflection.Getter
    public int getCount() {
        return ((ObservableList)this.getWrappedObject()).size();
    }

    @Override
    public Memory offsetExists(Environment environment, Memory ... memories) {
        ObservableList list = (ObservableList)this.getWrappedObject();
        int index = memories[0].toInteger();
        return index >= 0 && index < list.size() ? Memory.TRUE : Memory.FALSE;
    }

    @Override
    public Memory offsetGet(Environment environment, Memory ... memories) {
        ObservableList list = (ObservableList)this.getWrappedObject();
        int index = memories[0].toInteger();
        return index >= 0 && index < list.size() ? Memory.wrap(environment, list.get(index)) : Memory.NULL;
    }

    @Override
    public Memory offsetSet(Environment environment, Memory ... memories) {
        if (memories[0].isNull()) {
            ((ObservableList)this.getWrappedObject()).add(Memory.unwrap(environment, memories[1]));
        } else {
            this.insert(environment, memories[0].toInteger(), memories[1]);
            this.removeByIndex(environment, memories[0].toInteger() + 1);
        }
        return Memory.NULL;
    }

    @Override
    public Memory offsetUnset(Environment environment, Memory ... memories) {
        ObservableList list = (ObservableList)this.getWrappedObject();
        int index = memories[0].toInteger();
        if (index >= 0 && index < list.size()) {
            list.remove(index);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public void addListener(Invoker invoker) {
        ((ObservableList)this.getWrappedObject()).addListener(c -> invoker.callAny(new Object[0]));
    }
}

