/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.operator.cast;

import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.ArrayCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.BinaryCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.BooleanCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.DoubleCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.IntCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.ObjectCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.StringCastExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.cast.UnsetCastExprToken;
import php.runtime.common.Association;

public abstract class CastExprToken
extends OperatorExprToken {
    public CastExprToken(TokenMeta meta, TokenType type) {
        super(meta, type);
    }

    @Override
    public boolean isBinary() {
        return false;
    }

    @Override
    public int getPriority() {
        return 21;
    }

    @Override
    public Association getOnlyAssociation() {
        return Association.RIGHT;
    }

    public static CastExprToken valueOf(String name, TokenMeta meta) {
        String word = name.toLowerCase();
        if (word.equals("int") || word.equals("integer")) {
            return new IntCastExprToken(meta);
        }
        if (word.equals("float") || word.equals("double") || word.equals("real")) {
            return new DoubleCastExprToken(meta);
        }
        if (word.equals("string")) {
            return new StringCastExprToken(meta);
        }
        if (word.equals("bool") || word.equals("boolean")) {
            return new BooleanCastExprToken(meta);
        }
        if (word.equals("array")) {
            return new ArrayCastExprToken(meta);
        }
        if (word.equals("object")) {
            return new ObjectCastExprToken(meta);
        }
        if (word.equals("unset")) {
            return new UnsetCastExprToken(meta);
        }
        if (word.equals("binary")) {
            return new BinaryCastExprToken(meta);
        }
        return null;
    }
}

