/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.operator;

import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.OperatorExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DecExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessAssignExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessEmptyExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessGetRefExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.DynamicAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.operator.IncExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import php.runtime.Memory;
import php.runtime.common.Association;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.PropertyCallCache;

public class DynamicAccessCompiler
extends BaseExprCompiler<DynamicAccessExprToken> {
    public DynamicAccessCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(DynamicAccessExprToken dynamic, boolean returnValue) {
        this.expr.writeDynamicAccessPrepare(dynamic, false);
        if (dynamic.getFieldExpr() == null && dynamic.getField() instanceof NameToken && !this.method.clazz.statement.isTrait()) {
            this.expr.writeGetStatic("$CALL_PROP_CACHE", PropertyCallCache.class);
            this.expr.writePushConstInt(this.method.clazz.getAndIncCallPropCount());
        } else {
            this.expr.writePushConstNull();
            this.expr.writePushConstInt(0);
        }
        if (dynamic instanceof DynamicAccessAssignExprToken) {
            OperatorExprToken operator = (OperatorExprToken)((DynamicAccessAssignExprToken)dynamic).getAssignOperator();
            String code = operator.getCode();
            if (operator instanceof IncExprToken || operator instanceof DecExprToken) {
                code = operator.getAssociation() == Association.RIGHT ? code + "AndGet" : "GetAnd" + code.substring(0, 1).toUpperCase() + code.substring(1);
                this.expr.writeSysStaticCall(ObjectInvokeHelper.class, code + "Property", Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
            } else {
                this.expr.writeSysStaticCall(ObjectInvokeHelper.class, code + "Property", Memory.class, Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
            }
        } else if (dynamic instanceof DynamicAccessUnsetExprToken) {
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "unsetProperty", Void.TYPE, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
            if (returnValue) {
                this.expr.writePushNull();
            }
        } else if (dynamic instanceof DynamicAccessEmptyExprToken) {
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "emptyProperty", Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
        } else if (dynamic instanceof DynamicAccessIssetExprToken) {
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "issetProperty", Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
        } else {
            this.expr.writeSysStaticCall(ObjectInvokeHelper.class, dynamic instanceof DynamicAccessGetRefExprToken ? "getRefProperty" : "getProperty", Memory.class, Memory.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
        }
    }
}

