/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr;

import org.develnext.jphp.core.compiler.jvm.misc.LocalVariable;
import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseStatementCompiler;
import org.develnext.jphp.core.tokenizer.token.stmt.StaticStmtToken;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.reflection.MethodEntity;

public class StaticDefinitionCompiler
extends BaseStatementCompiler<StaticStmtToken> {
    public StaticDefinitionCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    void writePushNameForStaticVariable(LocalVariable local) {
        String name;
        String string = name = this.method.clazz.isClosure() ? local.name : ((MethodEntity)this.method.getEntity()).getClazz().getInternalName() + "\u0000" + local.name + "\u0000" + this.method.getMethodId();
        if (((MethodEntity)this.method.getEntity()).getClazz().isTrait()) {
            this.expr.writePushSelf(false);
            this.expr.writePushConstString(name);
            this.expr.writeSysDynamicCall(String.class, "concat", String.class, String.class);
        } else {
            this.expr.writePushConstString(name);
        }
    }

    @Override
    public void write(StaticStmtToken token) {
        LocalVariable local = this.method.getLocalVariable(token.getVariable().getName());
        assert (local != null);
        LabelNode end = new LabelNode();
        boolean isClosure = this.method.clazz.isClosure();
        if (isClosure) {
            this.expr.writeVarLoad("~this");
        } else {
            this.expr.writePushEnv();
        }
        this.writePushNameForStaticVariable(local);
        this.expr.writeSysDynamicCall(isClosure ? null : Environment.class, "getStatic", Memory.class, String.class);
        this.expr.writePushDup();
        this.add(new JumpInsnNode(199, end));
        this.expr.stackPop();
        this.expr.writePopAll(1);
        if (isClosure) {
            this.expr.writeVarLoad("~this");
        } else {
            this.expr.writePushEnv();
        }
        this.writePushNameForStaticVariable(local);
        if (token.getInitValue() != null) {
            this.expr.writeExpression(token.getInitValue(), true, false, true);
        } else {
            this.expr.writePushNull();
        }
        this.expr.writePopBoxing(true);
        this.expr.writeSysDynamicCall(isClosure ? null : Environment.class, "getOrCreateStatic", Memory.class, String.class, Memory.class);
        this.add(end);
        this.expr.writeVarStore(local, false, false);
    }
}

