/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.sourcemap;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class SourceMap {
    protected final String moduleName;
    protected Map<Integer, Item> itemsByCompiled = new LinkedHashMap<Integer, Item>();
    protected Map<Integer, Item> itemsBySource = new LinkedHashMap<Integer, Item>();

    public SourceMap(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException("moduleName is null");
        }
        this.moduleName = moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void clear() {
        this.itemsByCompiled.clear();
        this.itemsBySource.clear();
    }

    public void insertLines(int[][] inserts, int allCountLines) {
        ArrayList<Item> lines = new ArrayList<Item>();
        if (this.itemsByCompiled != null && !this.itemsByCompiled.isEmpty()) {
            boolean addedCompiled = false;
            for (int i = 0; i < allCountLines; ++i) {
                Item item = this.itemsByCompiled.get(i + 1);
                if (item != null) {
                    addedCompiled = true;
                    lines.add(new Item(item.sourceLine, item.compiledLine));
                    continue;
                }
                if (addedCompiled) {
                    lines.add(new Item(-1, -1));
                    continue;
                }
                lines.add(new Item(1, 1));
            }
        } else {
            for (int i = 0; i < allCountLines; ++i) {
                lines.add(new Item(i + 1, i + 1));
            }
        }
        for (int[] insert : inserts) {
            int i;
            int line = insert[0];
            int count = insert[1];
            for (i = 0; i < count; ++i) {
                lines.add(line, new Item(-1, -1));
            }
            for (i = line + count; i < lines.size(); ++i) {
                Item item = (Item)lines.get(i);
                item.compiledLine += count;
            }
        }
        Object object = lines.iterator();
        while (object.hasNext()) {
            Item line = (Item)object.next();
            if (line.sourceLine <= -1 || line.sourceLine == line.compiledLine) continue;
            this.addLine(line.sourceLine, line.compiledLine);
        }
    }

    public void addLine(int sourceLine, int compiledLine) {
        Item item = new Item(sourceLine, compiledLine);
        this.itemsByCompiled.put(compiledLine, item);
        this.itemsBySource.put(sourceLine, item);
    }

    public int getCompiledLine(int sourceLine) {
        Item item = this.itemsBySource.get(sourceLine);
        if (item == null) {
            return -1;
        }
        return item.compiledLine;
    }

    public int getSourceLine(int compiledLine) {
        Item item = this.itemsByCompiled.get(compiledLine);
        if (item == null) {
            return -1;
        }
        return item.sourceLine;
    }

    public Map<Integer, Item> getItemsByCompiled() {
        return this.itemsByCompiled;
    }

    public Map<Integer, Item> getItemsBySource() {
        return this.itemsBySource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceMap sourceMap = (SourceMap)o;
        return this.moduleName.equals(sourceMap.moduleName);
    }

    public int hashCode() {
        return this.moduleName.hashCode();
    }

    public static class Item {
        public final int sourceLine;
        public int compiledLine;

        public Item(int sourceLine, int compiledLine) {
            this.sourceLine = sourceLine;
            this.compiledLine = compiledLine;
        }
    }
}

