/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import php.runtime.env.CompileScope;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.handler.EntityFetchHandler;
import php.runtime.exceptions.CriticalException;
import php.runtime.loader.dump.ModuleDumper;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.helper.ClosureEntity;
import php.runtime.reflection.helper.GeneratorEntity;

public class StandaloneLoader {
    protected final CompileScope scope = new CompileScope();
    protected final Environment env = new Environment(this.scope, (OutputStream)System.out);
    private ClassLoader classLoader;
    protected final Map<String, Module> classes;
    protected final Map<String, Module> functions;
    protected final Map<String, Module> constants;
    protected final Map<String, Module> modules;

    public StandaloneLoader() {
        this.env.getDefaultBuffer().setImplicitFlush(true);
        this.classes = new HashMap<String, Module>();
        this.functions = new HashMap<String, Module>();
        this.constants = new HashMap<String, Module>();
        this.modules = new HashMap<String, Module>();
        this.scope.addClassEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchClass(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
        this.scope.addFunctionEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchFunction(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
        this.scope.addConstantEntityFetchHandler(new EntityFetchHandler(){

            @Override
            public void fetch(CompileScope scope, String originName, String name) {
                ModuleEntity module = StandaloneLoader.this.fetchConstant(name);
                if (module != null) {
                    StandaloneLoader.this.loadModule(module);
                    scope.loadModule(module, false);
                    scope.registerModule(module);
                }
            }
        });
    }

    public StandaloneLoader(ClassLoader classLoader) {
        this();
        this.setClassLoader(classLoader);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.scope.setNativeClassLoader(classLoader);
    }

    public Collection<InputStream> getResources(String name) {
        ArrayList<InputStream> result = new ArrayList<InputStream>();
        try {
            Enumeration<URL> urls = this.classLoader.getResources(name);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                result.add(url.openStream());
            }
            return result;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    protected void loadExtension(InputStream stream) {
        if (stream != null) {
            Scanner scanner = new Scanner(stream);
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                if (line.isEmpty()) continue;
                this.scope.registerExtension(line);
            }
        }
    }

    public void loadExtensions() {
        if (this.classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        this.loadExtension(this.classLoader.getResourceAsStream("JPHP-INF/standalone.extensions.list"));
        for (InputStream stream : this.getResources("JPHP-INF/extensions.list")) {
            this.loadExtension(stream);
        }
    }

    public void loadLibrary() throws IOException {
        if (this.classLoader == null) {
            throw new NullPointerException("classLoader is null");
        }
        this.loadClassesDump(this.classLoader.getResourceAsStream("JPHP-INF/classes.dump"));
    }

    public void run() {
        this.run("JPHP-INF/.bootstrap");
    }

    public void run(String bootstrapScriptName) {
        this.loadExtensions();
        try {
            this.loadLibrary();
            ModuleEntity bootstrap = this.fetchModule(bootstrapScriptName);
            if (bootstrap != null) {
                bootstrap.includeNoThrow(this.env);
            } else {
                System.out.println("(!) Cannot find bootstrap script.");
            }
        }
        catch (IOException e) {
            throw new CriticalException(e);
        }
    }

    protected ModuleEntity _fetch(String name, Map<String, Module> source) {
        Module module = source.get(name);
        if (module == null) {
            return null;
        }
        InputStream input = this.classLoader.getResourceAsStream(module.internalName + ".dump");
        if (input == null) {
            return null;
        }
        ModuleDumper moduleDumper = new ModuleDumper(new Context(new File(module.name)), this.env, true);
        try {
            return moduleDumper.load(input);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ModuleEntity fetchModule(String name) {
        ModuleEntity entity = this._fetch(name.toLowerCase(), this.modules);
        if (entity != null) {
            this.loadModule(entity);
            this.scope.loadModule(entity, false);
            this.scope.addUserModule(entity);
        }
        return entity;
    }

    public ModuleEntity fetchClass(String name) {
        return this._fetch(name.toLowerCase(), this.classes);
    }

    public ModuleEntity fetchFunction(String name) {
        return this._fetch(name.toLowerCase(), this.functions);
    }

    public ModuleEntity fetchConstant(String name) {
        return this._fetch(name, this.constants);
    }

    public CompileScope getScope() {
        return this.scope;
    }

    protected void loadClassesDump(InputStream input) throws IOException {
        DataInputStream classesDump = new DataInputStream(input);
        int size = classesDump.readInt();
        for (int i = 0; i < size; ++i) {
            String name = classesDump.readUTF();
            String internalName = classesDump.readUTF();
            int classesSize = classesDump.readInt();
            HashSet<String> classes = new HashSet<String>();
            for (int j = 0; j < classesSize; ++j) {
                classes.add(classesDump.readUTF());
            }
            int functionsSize = classesDump.readInt();
            HashSet<String> functions = new HashSet<String>();
            for (int j = 0; j < functionsSize; ++j) {
                functions.add(classesDump.readUTF());
            }
            int constantSize = classesDump.readInt();
            HashSet<String> constants = new HashSet<String>();
            for (int j = 0; j < constantSize; ++j) {
                constants.add(classesDump.readUTF());
            }
            Module module = new Module(name, internalName, classes, functions, constants);
            this.registerModule(module);
        }
    }

    protected void loadModule(ModuleEntity moduleEntity) {
        try {
            moduleEntity.setNativeClazz(this.classLoader.loadClass(moduleEntity.getInternalName()));
            for (FunctionEntity functionEntity : moduleEntity.getFunctions()) {
                functionEntity.setNativeClazz(this.classLoader.loadClass(functionEntity.getInternalName()));
            }
            for (ClassEntity classEntity : moduleEntity.getClasses()) {
                classEntity.setNativeClazz(this.classLoader.loadClass(classEntity.getCompiledInternalName()));
            }
            for (ClosureEntity closureEntity : moduleEntity.getClosures()) {
                closureEntity.setNativeClazz(this.classLoader.loadClass(closureEntity.getInternalName()));
            }
            for (GeneratorEntity generatorEntity : moduleEntity.getGenerators()) {
                generatorEntity.setNativeClazz(this.classLoader.loadClass(generatorEntity.getInternalName()));
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void registerModule(Module module) {
        for (String name : module.classes) {
            this.classes.put(name.toLowerCase(), module);
        }
        for (String name : module.functions) {
            this.functions.put(name.toLowerCase(), module);
        }
        for (String name : module.constants) {
            this.constants.put(name, module);
        }
        String name = module.name;
        if (name.endsWith(".php")) {
            name = name.substring(0, name.lastIndexOf(".php"));
        }
        this.modules.put(name.toLowerCase(), module);
    }

    public Environment getScopeEnvironment() {
        return this.env;
    }

    protected static class Module {
        public final String name;
        public final String internalName;
        public final Set<String> classes;
        public final Set<String> functions;
        public final Set<String> constants;

        public Module(String name, String internalName, Set<String> classes, Set<String> functions, Set<String> constants) {
            this.name = name;
            this.internalName = internalName;
            this.classes = classes;
            this.functions = functions;
            this.constants = constants;
        }
    }
}

