/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.util;

import java.util.Locale;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.lang.BaseObject;
import php.runtime.lang.support.IComparableObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\util\\Locale")
public class WrapLocale
extends BaseObject
implements IComparableObject<WrapLocale> {
    protected Locale locale;

    public WrapLocale(Environment env, Locale locale) {
        super(env);
        this.locale = locale;
    }

    public WrapLocale(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="lang"), @Reflection.Arg(value="country", optional=@Reflection.Optional(value="")), @Reflection.Arg(value="variant", optional=@Reflection.Optional(value=""))})
    public Memory __construct(Environment env, Memory ... args) {
        this.locale = new Locale(args[0].toString(), args[1].toString(), args[2].toString());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*language").assign(this.locale.getLanguage());
        r.refOfIndex("*country").assign(this.locale.getCountry());
        r.refOfIndex("*variant").assign(this.locale.getVariant());
        return r.toConstant();
    }

    public static Locale getDefault(Environment env, Memory arg) {
        if (arg.isNull()) {
            return WrapLocale.getDefault(env);
        }
        return arg.toObject(WrapLocale.class).locale;
    }

    public static Locale getDefault(Environment env) {
        Locale locale1 = env.getUserValue(WrapLocale.class.getName() + "#default", Locale.class);
        if (locale1 == null) {
            return Locale.getDefault();
        }
        return locale1;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="globally", optional=@Reflection.Optional(value="false"))})
    public static Memory getDefault(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, args[0].toBoolean() ? Locale.getDefault() : WrapLocale.getDefault(env)));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class), @Reflection.Arg(value="globally", optional=@Reflection.Optional(value="false"))})
    public static Memory setDefault(Environment env, Memory ... args) {
        Locale locale = args[0].toObject(WrapLocale.class).locale;
        if (args[1].toBoolean()) {
            Locale.setDefault(locale);
        } else {
            env.setUserValue(WrapLocale.class.getName() + "#default", locale);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getLanguage(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.getLanguage());
    }

    @Reflection.Signature
    public Memory getCountry(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.getCountry());
    }

    @Reflection.Signature
    public Memory getVariant(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.getVariant());
    }

    @Reflection.Signature
    public Memory getISO3Country(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.getISO3Country());
    }

    @Reflection.Signature
    public Memory getISO3Language(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.getISO3Language());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public Memory getDisplayName(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].isNull() ? this.locale.getDisplayName() : this.locale.getDisplayName(args[0].toObject(WrapLocale.class).locale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public Memory getDisplayCountry(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].isNull() ? this.locale.getDisplayCountry() : this.locale.getDisplayCountry(args[0].toObject(WrapLocale.class).locale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public Memory getDisplayLanguage(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].isNull() ? this.locale.getDisplayLanguage() : this.locale.getDisplayLanguage(args[0].toObject(WrapLocale.class).locale));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="locale", nativeType=WrapLocale.class, optional=@Reflection.Optional(value="null"))})
    public Memory getDisplayVariant(Environment env, Memory ... args) {
        return StringMemory.valueOf(args[0].isNull() ? this.locale.getDisplayVariant() : this.locale.getDisplayVariant(args[0].toObject(WrapLocale.class).locale));
    }

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.locale.toString());
    }

    @Reflection.Signature
    public static Memory ENGLISH(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.ENGLISH));
    }

    @Reflection.Signature
    public static Memory GERMAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.GERMAN));
    }

    @Reflection.Signature
    public static Memory GERMANY(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.GERMANY));
    }

    @Reflection.Signature
    public static Memory CANADA(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.CANADA));
    }

    @Reflection.Signature
    public static Memory CANADA_FRENCH(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.CANADA_FRENCH));
    }

    @Reflection.Signature
    public static Memory CHINA(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.CHINA));
    }

    @Reflection.Signature
    public static Memory CHINESE(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.CHINESE));
    }

    @Reflection.Signature
    public static Memory FRANCE(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.FRANCE));
    }

    @Reflection.Signature
    public static Memory FRENCH(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.FRENCH));
    }

    @Reflection.Signature
    public static Memory US(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.US));
    }

    @Reflection.Signature
    public static Memory ITALIAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.ITALIAN));
    }

    @Reflection.Signature
    public static Memory ITALY(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.ITALY));
    }

    @Reflection.Signature
    public static Memory JAPAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.JAPAN));
    }

    @Reflection.Signature
    public static Memory JAPANESE(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.JAPANESE));
    }

    @Reflection.Signature
    public static Memory KOREA(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.KOREA));
    }

    @Reflection.Signature
    public static Memory KOREAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.KOREAN));
    }

    @Reflection.Signature
    public static Memory UK(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.UK));
    }

    @Reflection.Signature
    public static Memory TAIWAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.TAIWAN));
    }

    @Reflection.Signature
    public static Memory RUSSIAN(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, new Locale("ru")));
    }

    @Reflection.Signature
    public static Memory RUSSIA(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, new Locale("ru", "RU")));
    }

    @Reflection.Signature
    public static Memory ROOT(Environment env, Memory ... args) {
        return new ObjectMemory(new WrapLocale(env, Locale.ROOT));
    }

    @Reflection.Signature
    public static Memory getAvailableLocales(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        for (Locale el : Locale.getAvailableLocales()) {
            r.add(new WrapLocale(env, el));
        }
        return r.toConstant();
    }

    @Override
    public boolean __equal(WrapLocale iObject) {
        return this.locale.equals(iObject.getLocale());
    }

    @Override
    public boolean __identical(WrapLocale iObject) {
        return this.locale == iObject.getLocale();
    }

    @Override
    public boolean __greater(WrapLocale iObject) {
        return false;
    }

    @Override
    public boolean __greaterEq(WrapLocale iObject) {
        return false;
    }

    @Override
    public boolean __smaller(WrapLocale iObject) {
        return false;
    }

    @Override
    public boolean __smallerEq(WrapLocale iObject) {
        return false;
    }

    @Reflection.Signature
    private Memory __clone(Environment env, Memory ... args) {
        return Memory.NULL;
    }
}

