/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.stream;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.channels.FileLock;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.FileObject;
import php.runtime.ext.core.classes.stream.FileStream;
import php.runtime.ext.core.classes.stream.MiscStream;
import php.runtime.ext.core.classes.stream.ResourceStream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.IObject;
import php.runtime.lang.Resource;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.support.ReflectionUtils;

@Reflection.Name(value="php\\io\\Stream")
@Reflection.Signature(value={@Reflection.Arg(value="path", modifier=Modifier.PRIVATE, readOnly=true, type=HintType.STRING), @Reflection.Arg(value="mode", modifier=Modifier.PRIVATE, readOnly=true)})
public abstract class Stream
extends BaseObject
implements Resource {
    @Reflection.Ignore
    public static final String CLASS_NAME = "php\\io\\Stream";
    private String path;
    private String mode;
    private Memory context = Memory.NULL;

    public Stream(Environment env) {
        super(env);
    }

    public Stream(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="NULL"))})
    public Memory __construct(Environment env, Memory ... args) throws IOException {
        this.setPath(args[0].toString());
        this.setMode(args[1].isNull() ? null : args[1].toString());
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value")})
    public Memory setContext(Environment env, Memory ... args) {
        this.context = args[0];
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory getContext(Environment env, Memory ... args) {
        return this.context;
    }

    @Reflection.Signature
    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.__class__.setProperty(this, "path", new StringMemory(path));
        this.path = path;
    }

    @Reflection.Signature
    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.__class__.setProperty(this, "mode", mode == null ? null : new StringMemory(mode));
        this.mode = mode;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="value"), @Reflection.Arg(value="length", optional=@Reflection.Optional(value="NULL"))})
    public abstract Memory write(Environment var1, Memory ... var2) throws IOException;

    @Reflection.Signature(value={@Reflection.Arg(value="length")})
    public abstract Memory read(Environment var1, Memory ... var2) throws IOException;

    @Reflection.Signature
    public abstract Memory readFully(Environment var1, Memory ... var2) throws IOException;

    @Reflection.Signature
    public abstract Memory eof(Environment var1, Memory ... var2);

    @Reflection.Signature(value={@Reflection.Arg(value="position")})
    public abstract Memory seek(Environment var1, Memory ... var2) throws IOException;

    @Reflection.Signature
    public abstract Memory getPosition(Environment var1, Memory ... var2);

    @Reflection.Signature
    public abstract Memory close(Environment var1, Memory ... var2) throws IOException;

    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) throws Throwable {
        Memory memory = env.invokeMethod(this, "readFully", new Memory[0]);
        if (memory.isString()) {
            return memory;
        }
        return StringMemory.valueOf(memory.toString());
    }

    public static Stream create(Environment env, String path, String mode) throws Throwable {
        return Stream.of(env, StringMemory.valueOf(path), StringMemory.valueOf(mode)).toObject(Stream.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="r"))})
    public static Memory getContents(Environment env, Memory ... args) throws Throwable {
        Stream stream = Stream.create(env, args[0].toString(), args[1].toString());
        try {
            Memory memory = env.invokeMethod(stream, "readFully", new Memory[0]);
            return memory;
        }
        finally {
            env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="data"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="w+"))})
    public static Memory putContents(Environment env, Memory ... args) throws Throwable {
        Stream stream = Stream.create(env, args[0].toString(), args[2].toString());
        FileLock lock = null;
        try {
            Memory memory;
            block8: {
                if (stream instanceof FileStream) {
                    lock = ((FileStream)stream).getAccessFile().getChannel().lock();
                }
                try {
                    memory = env.invokeMethod(stream, "write", args[1]);
                    if (lock == null) break block8;
                }
                catch (Throwable throwable) {
                    if (lock != null) {
                        lock.release();
                    }
                    throw throwable;
                }
                lock.release();
            }
            return memory;
        }
        finally {
            env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="path")})
    public static Memory exists(Environment env, Memory ... args) throws Throwable {
        Stream stream = null;
        try {
            stream = Stream.create(env, args[0].toString(), "r");
            if (stream._isExternalResourceStream()) {
                env.exception("Unable to check external stream", new Object[0]);
            }
            Memory memory = Memory.TRUE;
            return memory;
        }
        catch (WrapIOException e) {
            Memory memory = Memory.FALSE;
            return memory;
        }
        finally {
            if (stream != null) {
                env.invokeMethod(stream, "close", new Memory[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="callback", type=HintType.CALLABLE), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="r"))})
    public static Memory tryAccess(Environment env, Memory ... args) throws Throwable {
        Stream stream = Stream.create(env, args[0].toString(), args[2].toString());
        try {
            Invoker invoker = Invoker.create(env, args[1]);
            Memory memory = invoker.call(ObjectMemory.valueOf(stream));
            return memory;
        }
        finally {
            env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="path"), @Reflection.Arg(value="mode", optional=@Reflection.Optional(value="r"))})
    public static Memory of(Environment env, Memory ... args) throws Throwable {
        String className;
        String path = args[0].toString();
        String protocol = "file";
        int pos = path.indexOf("://");
        if (pos > -1) {
            protocol = path.substring(0, pos);
            path = path.substring(pos + 3);
        }
        if ((className = env.getUserValue(Stream.class.getName() + "#" + protocol, String.class)) == null) {
            throw new IOException("Unregistered protocol - " + protocol + "://");
        }
        ClassEntity classEntity = env.fetchClass(className);
        if (classEntity.getNativeClass().getAnnotation(UsePathWithProtocols.class) != null) {
            path = protocol + "://" + path;
        }
        return new ObjectMemory((IObject)classEntity.newObject(env, env.trace(), true, new StringMemory(path), args[1]));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="protocol"), @Reflection.Arg(value="className")})
    public static Memory register(Environment env, Memory ... args) {
        String protocol = args[0].toString();
        String className = args[1].toString();
        if (protocol.isEmpty()) {
            throw new IllegalArgumentException("Argument 1 (protocol) must be not empty");
        }
        if (!protocol.matches("^[A-Za-z0-9]+$")) {
            throw new IllegalArgumentException("Invalid Argument 1 (protocol)");
        }
        ClassEntity classEntity = env.fetchClass(className, true);
        if (classEntity == null) {
            throw new IllegalArgumentException(Messages.ERR_CLASS_NOT_FOUND.fetch(className));
        }
        env.setUserValue(Stream.class.getName() + "#" + protocol, classEntity.getName());
        return Memory.TRUE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="protocol")})
    public static Memory unregister(Environment env, Memory ... args) {
        String protocol = args[0].toString();
        if (protocol.isEmpty()) {
            return Memory.FALSE;
        }
        return env.removeUserValue(Stream.class.getName() + "#" + protocol) ? Memory.TRUE : Memory.FALSE;
    }

    public static void initEnvironment(Environment env) {
        Stream.registerProtocol(env, "file", FileStream.class);
        Stream.registerProtocol(env, "php", MiscStream.class);
        Stream.registerProtocol(env, "res", ResourceStream.class);
    }

    @Override
    public String getResourceType() {
        return "stream";
    }

    @Reflection.Signature
    public Memory __destruct(Environment env, Memory ... args) throws IOException {
        this.close(env, args);
        return Memory.NULL;
    }

    public boolean _isExternalResourceStream() {
        return false;
    }

    public static void registerProtocol(Environment env, String protocol, Class<? extends Stream> clazz) {
        env.setUserValue(Stream.class.getName() + "#" + protocol, ReflectionUtils.getClassName(clazz));
    }

    public static OutputStream getOutputStream(Environment env, Memory arg) {
        try {
            if (arg.instanceOf(FileObject.class)) {
                return new FileOutputStream(arg.toObject(FileObject.class).file);
            }
            if (arg.instanceOf(Stream.class)) {
                return new StreamOutputStream(env, arg.toObject(Stream.class));
            }
            StreamOutputStream outputStream = new StreamOutputStream(env, Stream.create(env, arg.toString(), "w+"));
            outputStream.autoClose = true;
            return outputStream;
        }
        catch (IOException e) {
            env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
        }
        catch (Throwable throwable) {
            env.forwardThrow(throwable);
        }
        return null;
    }

    public static String getPath(Memory arg) {
        if (arg.instanceOf(FileObject.class)) {
            return arg.toObject(FileObject.class).file.getPath();
        }
        if (arg.instanceOf(Stream.class)) {
            return arg.toObject(Stream.class).getPath();
        }
        return arg.toString();
    }

    public static InputStream getInputStream(Environment env, Stream stream) {
        if (stream instanceof ResourceStream) {
            return ((ResourceStream)stream).getInputStream();
        }
        return new StreamInputStream(env, stream);
    }

    public static OutputStream getOutputStream(Environment env, Stream stream) {
        return new StreamOutputStream(env, stream);
    }

    public static InputStream getInputStream(Environment env, Memory arg) {
        try {
            if (arg.instanceOf(FileObject.class)) {
                return new FileInputStream(arg.toObject(FileObject.class).file);
            }
            if (arg.instanceOf(Stream.class)) {
                if (arg.instanceOf(ResourceStream.class)) {
                    return arg.toObject(ResourceStream.class).getInputStream();
                }
                return new StreamInputStream(env, arg.toObject(Stream.class));
            }
            StreamInputStream inputStream = new StreamInputStream(env, Stream.create(env, arg.toString(), "r"));
            inputStream.autoClose = true;
            return inputStream;
        }
        catch (IOException e) {
            env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
        }
        catch (Throwable throwable) {
            env.forwardThrow(throwable);
        }
        return null;
    }

    public static void closeStream(Environment env, InputStream inputStream) {
        if (inputStream instanceof FileInputStream || inputStream instanceof StreamInputStream && ((StreamInputStream)inputStream).autoClose) {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
            }
        }
    }

    public static void closeStream(Environment env, OutputStream outputStream) {
        if (outputStream instanceof FileOutputStream || outputStream instanceof StreamOutputStream && ((StreamOutputStream)outputStream).autoClose) {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                env.exception(WrapIOException.class, e.getMessage(), new Object[0]);
            }
        }
    }

    public static class StreamInputStream
    extends InputStream {
        protected final Stream stream;
        protected final Environment env;
        protected boolean autoClose = false;

        public StreamInputStream(Environment env, Stream stream) {
            this.stream = stream;
            this.env = env;
        }

        @Override
        public int read() throws IOException {
            Memory result = this.stream.read(this.env, Memory.CONST_INT_1);
            return result.isString() ? result.getBinaryBytes(this.env.getDefaultCharset())[0] & 0xFF : -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Memory result = this.stream.read(this.env, LongMemory.valueOf(len));
            if (!result.isString()) {
                return -1;
            }
            byte[] copy = result.getBinaryBytes(this.env.getDefaultCharset());
            System.arraycopy(copy, 0, b, off, copy.length);
            return copy.length;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.stream.close(this.env, new Memory[0]);
        }
    }

    public static class StreamOutputStream
    extends OutputStream {
        protected final Stream stream;
        protected final Environment env;
        protected boolean autoClose = false;

        public StreamOutputStream(Environment env, Stream stream) {
            this.stream = stream;
            this.env = env;
        }

        @Override
        public void write(int b) throws IOException {
            this.stream.write(this.env, new BinaryMemory((byte)b), Memory.NULL);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return;
            }
            if (off == 0 && len == b.length) {
                this.stream.write(this.env, new BinaryMemory(b), Memory.NULL);
            } else if (off == 0 && len != b.length) {
                this.stream.write(this.env, new BinaryMemory(Arrays.copyOf(b, len)), Memory.NULL);
            } else {
                this.stream.write(this.env, new BinaryMemory(Arrays.copyOfRange(b, off, off + len)), Memory.NULL);
            }
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.stream.close(this.env, new Memory[0]);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface UsePathWithProtocols {
    }
}

