/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.AbstractCompiler;
import php.runtime.common.HintType;
import php.runtime.env.CompileScope;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.lang.BaseObject;
import php.runtime.loader.dump.ModuleDumper;
import php.runtime.memory.ArrayMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ModuleEntity;

@Reflection.Name(value="php\\lang\\Module")
public class WrapModule
extends BaseObject {
    protected ModuleEntity module;
    protected boolean registered = false;

    public WrapModule(Environment env, ModuleEntity module) {
        super(env);
        this.module = module;
    }

    public WrapModule(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="source"), @Reflection.Arg(value="compiled", optional=@Reflection.Optional(value="false")), @Reflection.Arg(value="debugInformation", optional=@Reflection.Optional(value="true"))})
    public Memory __construct(Environment env, Memory ... args) throws Throwable {
        InputStream is = Stream.getInputStream(env, args[0]);
        try {
            Context context = new Context(is, Stream.getPath(args[0]), env.getDefaultCharset());
            if (args[1].toBoolean()) {
                ModuleDumper moduleDumper = new ModuleDumper(context, env, args[2].toBoolean());
                this.module = moduleDumper.load(context.getInputStream(env.getDefaultCharset()));
            } else {
                AbstractCompiler compiler = env.scope.createCompiler(env, context);
                this.module = compiler.compile(false);
            }
            this.register(env, new Memory[0]);
        }
        finally {
            Stream.closeStream(env, is);
        }
        return Memory.NULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadModule(Environment env) {
        if (!this.module.isLoaded()) {
            CompileScope compileScope = env.scope;
            synchronized (compileScope) {
                if (!this.module.isLoaded()) {
                    env.scope.loadModule(this.module);
                    env.scope.addUserModule(this.module);
                }
            }
        }
    }

    protected void register(Environment env, Memory ... args) {
        if (this.registered) {
            return;
        }
        this.loadModule(env);
        env.registerModule(this.module);
        this.registered = true;
    }

    @Reflection.Signature
    public String getName() {
        return this.module.getName();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="variables", type=HintType.ARRAY, optional=@Reflection.Optional(value="NULL"))})
    public Memory call(Environment env, Memory ... args) throws Throwable {
        if (!this.registered) {
            this.register(env, new Memory[0]);
        }
        if (args[0].isNull()) {
            return this.module.include(env);
        }
        return this.module.include(env, args[0].toImmutable().toValue(ArrayMemory.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reflection.Signature(value={@Reflection.Arg(value="target"), @Reflection.Arg(value="saveDebugInfo", optional=@Reflection.Optional(value="true"))})
    public Memory dump(Environment env, Memory ... args) throws IOException {
        ModuleDumper moduleDumper = new ModuleDumper(this.module.getContext(), env, args[1].toBoolean());
        OutputStream os = Stream.getOutputStream(env, args[0]);
        try {
            moduleDumper.save(this.module, os);
        }
        finally {
            Stream.closeStream(env, os);
        }
        return Memory.NULL;
    }
}

