/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import php.runtime.Memory;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.ext.core.classes.stream.Stream;
import php.runtime.ext.core.classes.stream.WrapIOException;
import php.runtime.reflection.ModuleEntity;

public class ModuleManager {
    protected final Environment env;
    protected final Map<String, ModuleEntity> modules = new LinkedHashMap<String, ModuleEntity>();

    public ModuleManager(Environment env) {
        this.env = env;
    }

    public void apply(ModuleManager parent) {
        this.modules.putAll(parent.modules);
    }

    public ModuleEntity fetchCachedModule(String path) throws Throwable {
        ModuleEntity moduleEntity = this.modules.get(path);
        if (moduleEntity != null) {
            return moduleEntity;
        }
        moduleEntity = this.fetchModule(path);
        if (moduleEntity == null) {
            return null;
        }
        this.modules.put(path, moduleEntity);
        return moduleEntity;
    }

    public ModuleEntity fetchModule(String path) throws Throwable {
        return this.fetchModule(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleEntity fetchModule(String path, boolean compiled) throws Throwable {
        Stream stream = this.fetchStream(path);
        if (stream == null) {
            return null;
        }
        try {
            if (stream._isExternalResourceStream()) {
                this.env.exception("Cannot import module form external stream: " + stream.getPath(), new Object[0]);
                ModuleEntity moduleEntity = null;
                return moduleEntity;
            }
            if (compiled) {
                ModuleEntity moduleEntity = this.env.importCompiledModule(this.fetchContext(stream), true);
                return moduleEntity;
            }
            ModuleEntity moduleEntity = this.env.importModule(this.fetchContext(stream));
            return moduleEntity;
        }
        finally {
            this.env.invokeMethod(stream, "close", new Memory[0]);
        }
    }

    public Context fetchContext(Stream stream) throws Throwable {
        return new Context(Stream.getInputStream(this.env, stream), stream.getPath(), this.env.getDefaultCharset());
    }

    protected Stream fetchStream(String path) throws Throwable {
        try {
            return Stream.create(this.env, path, "r");
        }
        catch (WrapIOException e) {
            return null;
        }
    }

    public boolean hasModule(String path) {
        return this.modules.containsKey(path);
    }

    public Collection<String> getCachedPaths() {
        return this.modules.keySet();
    }
}

