/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control.tabpane;

import java.util.HashSet;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import org.develnext.jphp.ext.javafx.support.control.tabpane.TabDraggedEvent;

public class DndTabPane
extends TabPane {
    private BooleanProperty draggingEnabled = new SimpleBooleanProperty(true);
    private ObjectProperty<EventHandler<TabDraggedEvent>> onTabDragged = new SimpleObjectProperty(null);
    private Set<Tab> undraggableTabs = new HashSet<Tab>();

    public void setDraggableTab(Tab tab, boolean value) {
        if (value) {
            this.undraggableTabs.remove(tab);
        } else {
            this.undraggableTabs.add(tab);
        }
    }

    public boolean isDraggableTab(Tab tab) {
        return !this.undraggableTabs.contains(tab);
    }

    public BooleanProperty draggingEnabledProperty() {
        return this.draggingEnabled;
    }

    public void fireTabDragged(Tab draggedTab, int fromIndex, int toIndex) {
        TabDraggedEvent event = new TabDraggedEvent(draggedTab, fromIndex, toIndex);
        if (this.onTabDragged.get() != null) {
            ((EventHandler)this.onTabDragged.get()).handle((Event)event);
        }
        this.fireEvent(event);
    }

    public EventHandler<TabDraggedEvent> getOnTabDragged() {
        return (EventHandler)this.onTabDragged.get();
    }

    public boolean isDraggingEnabled() {
        return this.draggingEnabled.get();
    }

    public ObjectProperty<EventHandler<TabDraggedEvent>> onTabDragged() {
        return this.onTabDragged;
    }

    public void setDraggingEnabled(boolean enabled) {
        this.draggingEnabled.set(enabled);
    }

    public void setOnTabDragged(EventHandler<TabDraggedEvent> value) {
        this.onTabDragged.setValue(value);
    }
}

