/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;

public class RadioGroupPane<T>
extends VBox {
    private ObjectProperty<ObservableList<T>> items;
    private Font font = Font.getDefault();
    private Color textColor = Color.BLACK;
    private List<RadioButton> buttons = new ArrayList<RadioButton>();
    protected EventHandler<Event> onAction = null;
    private Orientation orientation = Orientation.VERTICAL;
    private ToggleGroup group = new ToggleGroup();

    public final void setItems(ObservableList<T> value) {
        this.itemsProperty().set(value);
    }

    public final ObservableList<T> getItems() {
        return this.items == null ? null : (ObservableList)this.items.get();
    }

    public final ObjectProperty<ObservableList<T>> itemsProperty() {
        if (this.items == null) {
            this.items = new SimpleObjectProperty((Object)this, "items");
        }
        return this.items;
    }

    public RadioGroupPane() {
        this.setSpacing(5.0);
        this.setPrefHeight(-1.0);
        this.itemsProperty().addListener(new ChangeListener<ObservableList<T>>(){

            public void changed(ObservableValue<? extends ObservableList<T>> observable, ObservableList<T> oldValue, ObservableList<T> newValue) {
                RadioGroupPane.this.update();
                if (newValue != null) {
                    newValue.addListener(new ListChangeListener<T>(){

                        public void onChanged(ListChangeListener.Change<? extends T> c) {
                            RadioGroupPane.this.update();
                        }
                    });
                }
            }
        });
        this.setItems(FXCollections.observableArrayList());
        this.group.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> observable, Toggle oldValue, Toggle newValue) {
                if (RadioGroupPane.this.onAction != null) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            RadioGroupPane.this.onAction.handle(new Event((Object)RadioGroupPane.this, (EventTarget)RadioGroupPane.this, EventType.ROOT));
                        }
                    });
                }
            }
        });
    }

    public ToggleGroup getToggleGroup() {
        return this.group;
    }

    public T getSelected() {
        Toggle toggle = this.getToggleGroup().getSelectedToggle();
        Object selected = null;
        if (toggle != null) {
            selected = toggle.getUserData();
        }
        return (T)selected;
    }

    public void setSelected(T item) {
        if (item == null) {
            this.getToggleGroup().selectToggle(null);
        } else {
            for (RadioButton button : this.buttons) {
                if (!item.equals(button.getUserData())) continue;
                this.getToggleGroup().selectToggle((Toggle)button);
                break;
            }
        }
    }

    public int getSelectedIndex() {
        Toggle toggle = this.getToggleGroup().getSelectedToggle();
        return this.buttons.indexOf(toggle);
    }

    public void setSelectedIndex(int index) {
        if (index < 0 || index > this.buttons.size() - 1) {
            this.getToggleGroup().selectToggle(null);
        } else {
            this.getToggleGroup().selectToggle((Toggle)this.buttons.get(index));
        }
    }

    public Orientation getOrientation() {
        return this.orientation;
    }

    public void setOrientation(Orientation orientation) {
        this.orientation = orientation;
        this.update();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        for (RadioButton button : this.buttons) {
            button.setFont(font);
        }
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
        for (RadioButton button : this.buttons) {
            button.setTextFill((Paint)textColor);
        }
    }

    public void update() {
        this.updateUi(this.getItems());
    }

    public EventHandler<Event> getOnAction() {
        return this.onAction;
    }

    public void setOnAction(EventHandler<Event> onAction) {
        this.onAction = onAction;
    }

    protected void updateUi(ObservableList<? extends T> list) {
        T selected = this.getSelected();
        this.buttons.clear();
        this.getChildren().clear();
        ObservableList children = this.getChildren();
        if (this.orientation == Orientation.HORIZONTAL) {
            final HBox hBox = new HBox();
            hBox.setSpacing(this.getSpacing());
            hBox.setPrefWidth(-1.0);
            hBox.setPrefHeight(-1.0);
            hBox.setAlignment(Pos.BASELINE_LEFT);
            this.spacingProperty().addListener((ChangeListener)new ChangeListener<Number>(){

                public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                    hBox.setSpacing((double)newValue.intValue());
                }
            });
            children.add((Object)hBox);
            children = hBox.getChildren();
        }
        for (Object t : list) {
            String label = "" + t;
            RadioButton button = new RadioButton(label);
            button.setToggleGroup(this.group);
            button.setUserData(t);
            button.setFont(this.font);
            button.setTextFill((Paint)this.textColor);
            this.buttons.add(button);
            children.add((Object)button);
        }
        this.setSelected(selected);
    }
}

