/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.support.control;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.develnext.jphp.ext.javafx.support.control.LabelEx;

public class Panel
extends AnchorPane {
    protected Paint borderColor = Color.SILVER;
    protected BorderStrokeStyle borderStyle = BorderStrokeStyle.SOLID;
    protected CornerRadii borderRadius = new CornerRadii(0.0);
    protected BorderWidths borderWidths = new BorderWidths(1.0);
    protected String _borderStyle = "SOLID";
    protected LabelEx titleLabel = new LabelEx();

    public Panel() {
        this.titleLabel.setAutoSize(true);
        this.updateBorder();
        this.backgroundProperty().addListener((ChangeListener)new ChangeListener<Background>(){

            public void changed(ObservableValue<? extends Background> observable, Background oldValue, Background newValue) {
                Panel.this.updateBorder();
            }
        });
    }

    protected void updateBorder() {
        this.setBorder(new Border(new BorderStroke[]{new BorderStroke(this.borderColor, this.borderStyle, this.borderRadius, this.borderWidths)}));
        Background background = this.getBackground();
        if (background != null && background.getFills().size() == 1) {
            boolean update = false;
            for (BackgroundFill backgroundFill : background.getFills()) {
                if (backgroundFill.getRadii().equals((Object)this.borderRadius)) continue;
                update = true;
                break;
            }
            if (update) {
                BackgroundFill[] fills = new BackgroundFill[background.getFills().size()];
                int i = 0;
                for (BackgroundFill backgroundFill : background.getFills()) {
                    fills[i++] = new BackgroundFill(backgroundFill.getFill(), this.borderRadius, backgroundFill.getInsets());
                }
                this.setBackground(new Background(fills));
            }
        }
    }

    public void setBackgroundColor(Color color) {
        if (color == null) {
            this.setBackground(null);
        } else {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    public Color getBackgroundColor() {
        Paint fill;
        Background background = this.getBackground();
        if (background != null && background.getFills().size() > 0 && (fill = ((BackgroundFill)background.getFills().get(0)).getFill()) instanceof Color) {
            return (Color)fill;
        }
        return null;
    }

    public Color getBorderColor() {
        return this.borderColor instanceof Color ? (Color)this.borderColor : null;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        this.updateBorder();
    }

    public String getBorderStyle() {
        return this._borderStyle;
    }

    public void setBorderStyle(String borderStyle) {
        try {
            this.borderStyle = (BorderStrokeStyle)BorderStrokeStyle.class.getField(borderStyle.toUpperCase()).get(null);
            this._borderStyle = borderStyle;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IllegalArgumentException("Invalid borderStyle - " + borderStyle);
        }
        this.updateBorder();
    }

    public void setBorderRadius(double radius) {
        if (radius < 0.0) {
            radius = 0.0;
        }
        this.borderRadius = new CornerRadii(radius);
        this.updateBorder();
    }

    public double getBorderRadius() {
        return this.borderRadius.getTopLeftHorizontalRadius();
    }

    public double getBorderWidth() {
        return this.borderWidths.getTop();
    }

    public void setBorderWidth(double value) {
        if (value < 0.0) {
            value = 0.0;
        }
        this.borderWidths = new BorderWidths(value);
        this.updateBorder();
    }
}

