/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.ClassExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.ValueExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.ParentExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessIssetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticAccessUnsetExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.VariableExprToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.invoke.cache.ConstantCallCache;
import php.runtime.invoke.cache.PropertyCallCache;

public class StaticAccessValueCompiler
extends BaseExprCompiler<StaticAccessExprToken> {
    public StaticAccessValueCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(StaticAccessExprToken token, boolean returnValue) {
        boolean isConstant = token.getField() instanceof NameToken;
        if (token.getField() instanceof ClassExprToken) {
            if (token.getClazz() instanceof ParentExprToken) {
                this.expr.writePushParent(token.getClazz());
            } else if (token.getClazz() instanceof StaticExprToken) {
                this.expr.writePushStatic();
            } else if (token.getClazz() instanceof SelfExprToken) {
                this.expr.writePushSelf(false);
            } else {
                this.expr.unexpectedToken(token);
            }
        } else {
            ValueExprToken clazz = token.getClazz();
            if (clazz instanceof ParentExprToken) {
                this.expr.writePushParent(clazz);
            } else if (clazz instanceof NameToken) {
                this.expr.writePushConstString(((NameToken)clazz).getName());
                this.expr.writePushConstString(((NameToken)clazz).getName().toLowerCase());
            } else {
                if (clazz instanceof StaticExprToken) {
                    this.expr.writePushStatic();
                } else if (clazz != null) {
                    this.expr.writePush(clazz, true, false);
                }
                this.expr.writePopString();
                this.expr.writePushDupLowerCase();
            }
            if (isConstant) {
                this.expr.writePushConstString(((NameToken)token.getField()).getName());
                this.expr.writePushEnv();
                this.expr.writePushTraceInfo(token);
                int cacheIndex = this.method.clazz.getAndIncCallConstCount();
                this.expr.writeGetStatic("$CALL_CONST_CACHE", ConstantCallCache.class);
                this.expr.writePushConstInt(cacheIndex);
                this.expr.writeSysStaticCall(ObjectInvokeHelper.class, "getConstant", Memory.class, String.class, String.class, String.class, Environment.class, TraceInfo.class, ConstantCallCache.class, Integer.TYPE);
                this.expr.setStackPeekAsImmutable();
            } else {
                if (token.getFieldExpr() != null) {
                    this.expr.writeExpression(token.getFieldExpr(), true, false);
                    this.expr.writePopString();
                } else {
                    if (!(token.getField() instanceof VariableExprToken)) {
                        this.expr.unexpectedToken(token.getField());
                    }
                    this.expr.writePushConstString(((VariableExprToken)token.getField()).getName());
                }
                this.expr.writePushEnv();
                this.expr.writePushTraceInfo(token);
                String name = "get";
                if (token instanceof StaticAccessUnsetExprToken) {
                    name = "unset";
                } else if (token instanceof StaticAccessIssetExprToken) {
                    name = "isset";
                }
                if (token.getFieldExpr() == null && token.getField() instanceof NameToken) {
                    this.expr.writeGetStatic("$CALL_PROP_CACHE", PropertyCallCache.class);
                    this.expr.writePushConstInt(this.method.clazz.getAndIncCallPropCount());
                } else {
                    this.expr.writePushConstNull();
                    this.expr.writePushConstInt(0);
                }
                this.expr.writeSysStaticCall(ObjectInvokeHelper.class, name + "StaticProperty", Memory.class, String.class, String.class, String.class, Environment.class, TraceInfo.class, PropertyCallCache.class, Integer.TYPE);
            }
        }
        if (!returnValue) {
            this.expr.writePopAll(1);
        }
    }
}

