/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement;

import org.develnext.jphp.core.compiler.jvm.JvmCompiler;
import org.develnext.jphp.core.tokenizer.TokenType;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.objectweb.asm.Label;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodNode;
import php.runtime.common.Messages;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.reflection.support.Entity;

public abstract class StmtCompiler<T extends Entity> {
    protected final JvmCompiler compiler;
    protected T entity;

    public StmtCompiler(JvmCompiler compiler) {
        this.compiler = compiler;
    }

    public abstract T compile();

    public JvmCompiler getCompiler() {
        return this.compiler;
    }

    public LabelNode writeLabel(MethodNode mv, int lineNumber) {
        LabelNode node = new LabelNode(new Label());
        mv.instructions.add(node);
        if (lineNumber != -1) {
            mv.instructions.add(new LineNumberNode(lineNumber, node));
        }
        return node;
    }

    public LabelNode writeLabel(MethodNode mv) {
        return this.writeLabel(mv, -1);
    }

    public T getEntity() {
        return this.entity;
    }

    public void unexpectedToken(Token token) {
        String unexpected = token.getWord();
        if (token.getType() == TokenType.T_J_CUSTOM) {
            unexpected = token.getWord();
        }
        this.compiler.getEnvironment().error(token.toTraceInfo(this.compiler.getContext()), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_X, unexpected);
    }

    protected void unexpectedToken(Token token, Object expected) {
        String unexpected = token.getWord();
        if (token.getType() == TokenType.T_J_CUSTOM) {
            unexpected = token.getWord();
        }
        this.compiler.getEnvironment().error(token.toTraceInfo(this.compiler.getContext()), ErrorType.E_PARSE, Messages.ERR_PARSE_UNEXPECTED_X_EXPECTED_Y, unexpected, expected);
    }
}

