/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.CallbackW;
import php.runtime.common.Messages;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileFunction;
import php.runtime.lang.IObject;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.support.ReflectionUtils;

public class CompileMethodEntity
extends MethodEntity {
    protected CompileMethod function = new CompileMethod();

    public CompileMethodEntity(Extension extension) {
        super((Context)null);
        this.setExtension(extension);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.function.name = name + "()";
    }

    public boolean addMethod(Method method, boolean skipConflicts) {
        return this.addMethod(method, skipConflicts, null);
    }

    public boolean addMethod(Method method, boolean skipConflicts, CallbackW<MemoryOperation, Class<?>, Type> unknownTypeFetcher) {
        if (skipConflicts && this.function.find(method.getParameterTypes().length) != null) {
            return false;
        }
        method.setAccessible(true);
        CompileMethod.Method compileMethod = this.function.addMethod(method);
        compileMethod.setUnknownTypeFetcher(unknownTypeFetcher);
        int mods = method.getModifiers();
        String name = method.getName();
        if (method.isAnnotationPresent(Reflection.Name.class)) {
            name = method.getAnnotation(Reflection.Name.class).value();
        }
        this.setName(name);
        this.setStatic(Modifier.isStatic(mods));
        this.setDeprecated(method.getAnnotation(Deprecated.class) != null);
        if (Modifier.isProtected(mods)) {
            this.setModifier(php.runtime.common.Modifier.PROTECTED);
        } else if (Modifier.isPrivate(mods)) {
            this.setModifier(php.runtime.common.Modifier.PRIVATE);
        } else {
            this.setModifier(php.runtime.common.Modifier.PUBLIC);
        }
        this.setReturnReference(method.getAnnotation(Reflection.Reference.class) != null);
        this.setFinal(method.isAnnotationPresent(Reflection.Final.class));
        this.setAbstract(Modifier.isAbstract(mods));
        this.setInternalName(method.getName());
        ParameterEntity[] parameters = new ParameterEntity[method.getParameterTypes().length];
        Annotation[][] annotations = method.getParameterAnnotations();
        int i = 0;
        for (Class<?> el : method.getParameterTypes()) {
            if (el == Environment.class || el == TraceInfo.class) continue;
            ParameterEntity param = new ParameterEntity(this.context);
            param.setName("arg" + i);
            param.setTrace(TraceInfo.UNKNOWN);
            Annotation[] argAnnotations = annotations[i];
            if (ReflectionUtils.getAnnotation(argAnnotations, Reflection.Nullable.class) != null) {
                param.setNullable(true);
            }
            parameters[i++] = param;
        }
        if (i < parameters.length) {
            parameters = Arrays.copyOf(parameters, i);
        }
        if (this.parameters == null || this.parameters.length < parameters.length) {
            this.parameters = parameters;
        }
        try {
            compileMethod.setParameters(parameters);
        }
        catch (CriticalException e) {
            if (skipConflicts) {
                this.function.delete(parameters.length);
                return false;
            }
            throw e;
        }
        return true;
    }

    @Override
    public void unsetArguments(Memory[] arguments) {
        super.unsetArguments(arguments);
    }

    @Override
    public Memory invokeDynamic(IObject _this, Environment env, Memory ... arguments) throws Throwable {
        return this.invokeDynamic((Object)_this, env, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Memory invokeDynamic(Object _this, Environment env, Memory ... arguments) throws Throwable {
        try {
            Memory memory;
            block33: {
                CompileMethod.Method method;
                if (this.isAbstract) {
                    env.error(ErrorType.E_ERROR, "Cannot call abstract method %s", this.getSignatureString(false));
                    Memory memory2 = Memory.NULL;
                    return memory2;
                }
                if (_this == null && !this.isStatic && (_this = this.clazz.newMock(env)) == null) {
                    env.error(ErrorType.E_ERROR, Messages.ERR_STATIC_METHOD_CALLED_DYNAMICALLY.fetch(this.getClazz().getName() + "::" + this.getName()), new Object[0]);
                }
                if ((method = this.function.find(arguments == null ? 0 : arguments.length)) == null) {
                    env.warning(env.trace(), Messages.ERR_EXPECT_LEAST_PARAMS.fetch(this.name, this.function.getMinArgs(), arguments == null ? 0 : arguments.length), new Object[0]);
                    Memory memory3 = Memory.NULL;
                    return memory3;
                }
                if (arguments != null && arguments.length > method.argsCount && !method.isVarArg()) {
                    env.error(env.trace(), ErrorType.E_ERROR, Messages.ERR_EXPECT_EXACTLY_PARAMS, this.name, method.argsCount, arguments.length);
                    Memory memory4 = Memory.NULL;
                    return memory4;
                }
                Class[] types = method.parameterTypes;
                Object[] passed = new Object[types.length];
                int i = 0;
                int j = 0;
                for (Class clazz : types) {
                    boolean isRef = method.references[i];
                    boolean mutableValue = method.mutableValues[i];
                    MemoryOperation operation = method.argumentOperations[i];
                    if (clazz == Memory.class) {
                        passed[i] = isRef ? arguments[j] : (mutableValue ? arguments[j].toValue() : arguments[j].toImmutable());
                        ++j;
                    } else if (operation != null) {
                        if (operation instanceof InjectMemoryOperation) {
                            passed[i] = operation.convert(env, this.trace, null);
                        } else {
                            passed[i] = operation.convert(env, this.trace, arguments[j]);
                            ++j;
                        }
                    } else {
                        if (i == types.length - 1 && types[i] == Memory[].class) {
                            Memory[] arg = new Memory[arguments.length - i + 1];
                            if (!isRef) {
                                for (int k = 0; k < arg.length; ++k) {
                                    arg[i] = arguments[i].toImmutable();
                                }
                            } else {
                                System.arraycopy(arguments, j, arg, 0, arg.length);
                            }
                            passed[i] = arg;
                            break;
                        }
                        env.error(this.trace, ErrorType.E_CORE_ERROR, this.name + "(): Cannot call this method dynamically", new Object[0]);
                        passed[i] = Memory.NULL;
                    }
                    ++i;
                }
                try {
                    memory = method.returnOperation.unconvertNoThow(env, this.trace, method.method.invoke(_this, passed));
                    i = 0;
                    if (this == this.getClazz().methodConstruct) break block33;
                }
                catch (Throwable throwable) {
                    try {
                        i = 0;
                        if (this != this.getClazz().methodConstruct) {
                            for (Object o : passed) {
                                MemoryOperation operation = method.argumentOperations[i];
                                if (operation != null) {
                                    operation.releaseConverted(env, this.trace, o);
                                }
                                ++i;
                            }
                        }
                        throw throwable;
                    }
                    catch (InvocationTargetException e) {
                        Memory memory5 = env.__throwException(e);
                        return memory5;
                    }
                    catch (Throwable e) {
                        throw e;
                    }
                }
                for (Object o : passed) {
                    MemoryOperation operation = method.argumentOperations[i];
                    if (operation != null) {
                        operation.releaseConverted(env, this.trace, o);
                    }
                    ++i;
                }
            }
            return memory;
        }
        finally {
            this.unsetArguments(arguments);
        }
    }

    @Override
    public void setPrototype(MethodEntity prototype) {
        if (prototype instanceof CompileMethodEntity) {
            this.function.mergeFunction(((CompileMethodEntity)prototype).function);
        }
        super.setPrototype(prototype);
    }

    public ParameterEntity[] getParameters(int count) {
        CompileMethod.Method result = this.function.find(count);
        if (result == null) {
            return new ParameterEntity[0];
        }
        return result.parameters;
    }

    public static class CompileMethod
    extends CompileFunction {
        public CompileMethod() {
            super(null);
        }

        @Override
        public Method addMethod(java.lang.reflect.Method method) {
            return (Method)super.addMethod(method);
        }

        @Override
        public Method addMethod(java.lang.reflect.Method method, boolean asImmutable) {
            return (Method)super.addMethod(method, asImmutable);
        }

        @Override
        public Method find(int paramCount) {
            return (Method)super.find(paramCount);
        }

        @Override
        protected CompileFunction.Method createMethod(java.lang.reflect.Method method, int count, boolean asImmutable) {
            return new Method(method, count, asImmutable);
        }

        public class Method
        extends CompileFunction.Method {
            protected MemoryOperation[] argumentOperations;
            protected MemoryOperation returnOperation;
            protected CallbackW<MemoryOperation, Class<?>, Type> unknownTypeFetcher;
            protected ParameterEntity[] parameters;

            public Method(java.lang.reflect.Method method, int argsCount, boolean _asImmutable) {
                super(method, argsCount, _asImmutable);
            }

            public void setUnknownTypeFetcher(CallbackW<MemoryOperation, Class<?>, Type> unknownTypeFetcher) {
                this.unknownTypeFetcher = unknownTypeFetcher;
            }

            public void setParameters(ParameterEntity[] parameters) {
                this.parameters = parameters;
                this.returnOperation = MemoryOperation.get(this.resultType, this.method.getGenericReturnType());
                if (this.returnOperation == null && this.unknownTypeFetcher != null) {
                    this.returnOperation = this.unknownTypeFetcher.call(this.resultType, null);
                }
                if (this.returnOperation == null) {
                    throw new CriticalException("Unsupported type for binding - " + this.resultType + " in " + this.method.getDeclaringClass().getName() + "." + this.method.getName());
                }
                this.argumentOperations = new MemoryOperation[this.parameterTypes.length];
                for (int i = 0; i < this.argumentOperations.length; ++i) {
                    MemoryOperation op;
                    Class parameterType = this.parameterTypes[i];
                    Type genericTypes = this.method.getGenericParameterTypes()[i];
                    this.argumentOperations[i] = op = MemoryOperation.get(parameterType, genericTypes);
                    if (op != null) {
                        if (i > parameters.length - 1) continue;
                        op.applyTypeHinting(parameters[i]);
                        continue;
                    }
                    if (parameterType == Environment.class) {
                        this.argumentOperations[i] = new InjectMemoryOperation(){

                            public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
                                return env;
                            }
                        };
                        continue;
                    }
                    if (parameterType == TraceInfo.class) {
                        this.argumentOperations[i] = new InjectMemoryOperation(){

                            public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
                                return trace;
                            }
                        };
                        continue;
                    }
                    if (this.unknownTypeFetcher != null) {
                        this.argumentOperations[i] = op = this.unknownTypeFetcher.call(parameterType, genericTypes);
                        if (op != null) {
                            if (i > parameters.length - 1) continue;
                            op.applyTypeHinting(parameters[i]);
                            continue;
                        }
                    }
                    throw new CriticalException("Unsupported type for binding - " + parameterType);
                }
            }
        }
    }

    public static class ParameterEntity
    extends php.runtime.reflection.ParameterEntity {
        public ParameterEntity(Context context) {
            super(context);
        }
    }

    public static abstract class InjectMemoryOperation
    extends MemoryOperation {
        @Override
        public Class<?>[] getOperationClasses() {
            return new Class[0];
        }

        public Memory unconvert(Environment env, TraceInfo trace, Object arg) throws Throwable {
            throw new CriticalException("Unsupported unconvert");
        }
    }
}

