/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.lang.Closure;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.MethodDumper;
import php.runtime.loader.dump.ParameterDumper;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.helper.ClosureEntity;

public class ClosureDumper
extends Dumper<ClosureEntity> {
    protected ParameterDumper parameterDumper;
    protected final MethodDumper methodDumper;

    public ClosureDumper(Context context, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
        this.parameterDumper = new ParameterDumper(this.context, this.env, this.debugInformation);
        this.methodDumper = new MethodDumper(this.context, this.env, this.debugInformation);
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public void save(ClosureEntity entity, OutputStream output) throws IOException {
        if (!entity.isLoaded()) {
            throw new DumpException("Closure not loaded");
        }
        DumpOutputStream data = new DumpOutputStream(output);
        data.writeName(entity.getInternalName());
        data.writeBoolean(entity.isReturnReference());
        this.methodDumper.save(entity.methodMagicInvoke, output);
        data.writeInt(entity.parameters == null ? 0 : entity.parameters.length);
        if (entity.parameters != null) {
            for (ParameterEntity param : entity.parameters) {
                this.parameterDumper.save(param, output);
            }
        }
        data.writeInt(entity.uses == null ? 0 : entity.uses.length);
        if (entity.uses != null) {
            for (ParameterEntity param : entity.uses) {
                this.parameterDumper.save(param, output);
            }
        }
        if (this.includeData) {
            data.writeRawData(entity.getData(), Integer.MAX_VALUE);
        } else {
            data.writeRawData(null);
        }
    }

    @Override
    public ClosureEntity load(InputStream input) throws IOException {
        ParameterEntity param;
        int i;
        DumpInputStream data = new DumpInputStream(input);
        ClosureEntity entity = new ClosureEntity(this.context);
        entity.setParent(this.env.scope.fetchUserClass(Closure.class));
        entity.setInternalName(data.readName());
        entity.setReturnReference(data.readBoolean());
        entity.methodMagicInvoke = this.methodDumper.load(input);
        entity.methodMagicInvoke.setClazz(entity);
        entity.addMethod(entity.methodMagicInvoke, null);
        int paramCount = data.readInt();
        if (paramCount < 0) {
            throw new DumpException("Invalid param count");
        }
        entity.parameters = new ParameterEntity[paramCount];
        for (i = 0; i < paramCount; ++i) {
            param = this.parameterDumper.load(input);
            param.setTrace(entity.getTrace());
            entity.parameters[i] = param;
        }
        paramCount = data.readInt();
        if (paramCount < 0) {
            throw new DumpException("Invalid param count");
        }
        entity.uses = new ParameterEntity[paramCount];
        for (i = 0; i < paramCount; ++i) {
            param = this.parameterDumper.load(input);
            param.setTrace(entity.getTrace());
            entity.uses[i] = param;
        }
        entity.setData(data.readRawData(Integer.MAX_VALUE));
        return entity;
    }
}

