/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.Reflection;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.Reflector;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.PropertyEntity;

@Reflection.Name(value="ReflectionProperty")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true), @Reflection.Arg(value="class", type=HintType.STRING, readOnly=true)})
public class ReflectionProperty
extends Reflection
implements Reflector {
    public static final int IS_STATIC = 1;
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    protected PropertyEntity entity;
    protected boolean hackAccess = false;

    public ReflectionProperty(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setEntity(PropertyEntity entity) {
        this.entity = entity;
        this.getProperties().put("name", new StringMemory(entity.getName()));
        this.getProperties().put("class", new StringMemory(entity.getClazz().getName()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class"), @Reflection.Arg(value="name")})
    public Memory __construct(Environment env, Memory ... args) {
        Memory arg = args[0];
        ClassEntity classEntity = arg.isObject() ? arg.toValue(ObjectMemory.class).getReflection() : env.fetchClass(arg.toString());
        if (classEntity == null) {
            this.exception(env, Messages.ERR_CLASS_NOT_FOUND.fetch(arg), new Object[0]);
            return Memory.NULL;
        }
        String prop = args[1].toString();
        PropertyEntity entity = classEntity.findProperty(prop);
        if (entity == null) {
            entity = classEntity.findStaticProperty(prop);
        }
        if (entity == null) {
            this.exception(env, Messages.ERR_UNDEFINED_PROPERTY.fetch(classEntity.getName(), prop), new Object[0]);
            return Memory.NULL;
        }
        this.setEntity(entity);
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory __toString(Environment env, Memory ... args) {
        return new StringMemory("TODO");
    }

    @Reflection.Signature
    public Memory getDeclaringClass(Environment env, Memory ... args) {
        ReflectionClass clazz = new ReflectionClass(env, env.fetchClass("ReflectionClass"));
        clazz.setEntity(this.entity.getClazz());
        return new ObjectMemory(clazz);
    }

    @Reflection.Signature
    public Memory getDocComment(Environment env, Memory ... args) {
        if (this.entity.getDocComment() == null) {
            return Memory.FALSE;
        }
        return new StringMemory(this.entity.getDocComment().toString());
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        int mod = 0;
        if (this.entity.isStatic()) {
            ++mod;
        }
        if (this.entity.isPrivate()) {
            mod += 1024;
        }
        if (this.entity.isProtected()) {
            mod += 512;
        }
        if (this.entity.isPublic()) {
            mod += 256;
        }
        return LongMemory.valueOf(mod);
    }

    @Reflection.Signature
    public Memory getName(Environment env, Memory ... args) {
        return new StringMemory(this.entity.getName());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object", optional=@Reflection.Optional(value="NULL"))})
    public Memory getValue(Environment env, Memory ... args) throws Throwable {
        int access;
        if (!this.hackAccess && (access = this.entity.canAccess(env)) != 0) {
            this.exception(env, "Cannot access non-public member %s::$%s", this.entity.getClazz().getName(), this.entity.getName());
            return Memory.NULL;
        }
        Memory arg = args[0];
        if (arg.isNull()) {
            if (!this.entity.isStatic()) {
                this.exception(env, "Dynamic property %s::$%s cannot get a property value statically", this.entity.getClazz().getName(), this.entity.getName());
            }
            return this.entity.getClazz().getStaticProperty(env, env.trace(), this.entity.getName(), true, false, null, null, 0);
        }
        if (arg.isObject()) {
            if (this.entity.isStatic()) {
                this.exception(env, "Static property %s::$%s cannot get a property value dynamically", this.entity.getClazz().getName(), this.entity.getName());
            }
            return arg.toValue(ObjectMemory.class).getProperties().valueOfIndex(this.entity.getSpecificName());
        }
        this.exception(env, "Argument 1 must be object, given %s", arg.getRealType().toString());
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory isDefault(Environment env, Memory ... args) {
        return this.entity.isDefault() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPublic(Environment env, Memory ... args) {
        return this.entity.isPublic() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPrivate(Environment env, Memory ... args) {
        return this.entity.isPrivate() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isProtected(Environment env, Memory ... args) {
        return this.entity.isProtected() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isStatic(Environment env, Memory ... args) {
        return this.entity.isStatic() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="accessible")})
    public Memory setAccessible(Environment env, Memory ... args) {
        this.hackAccess = args[0].toBoolean();
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object"), @Reflection.Arg(value="value")})
    public Memory setValue(Environment env, Memory ... args) throws Throwable {
        int access;
        if (!this.hackAccess && (access = this.entity.canAccess(env)) != 0) {
            this.exception(env, "Cannot access non-public member %s::$%s", this.entity.getClazz().getName(), this.entity.getName());
        }
        Memory arg = args[0];
        if (this.entity.isStatic()) {
            if (!arg.isNull()) {
                this.exception(env, "Static property %s::$%s cannot get a property value dynamically", this.entity.getClazz().getName(), this.entity.getName());
            }
            this.entity.getClazz().getStaticProperty(env, env.trace(), this.entity.getName(), true, false, null, null, 0).assign(args[1]);
        } else if (arg.isObject()) {
            arg.toValue(ObjectMemory.class).getProperties().refOfIndex(this.entity.getSpecificName()).assign(args[1]);
        } else {
            this.exception(env, "Argument 1 must be object, given %s", arg.getRealType().toString());
        }
        return Memory.NULL;
    }
}

