/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.reflection;

import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.common.HintType;
import php.runtime.common.Messages;
import php.runtime.env.Environment;
import php.runtime.ext.core.reflection.ReflectionClass;
import php.runtime.ext.core.reflection.ReflectionFunctionAbstract;
import php.runtime.ext.core.reflection.ReflectionParameter;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ParameterEntity;
import php.runtime.reflection.support.AbstractFunctionEntity;

@Reflection.Name(value="ReflectionMethod")
@Reflection.Signature(value={@Reflection.Arg(value="name", type=HintType.STRING, readOnly=true), @Reflection.Arg(value="class", type=HintType.STRING, readOnly=true)})
public class ReflectionMethod
extends ReflectionFunctionAbstract {
    public static final int IS_STATIC = 1;
    public static final int IS_PUBLIC = 256;
    public static final int IS_PROTECTED = 512;
    public static final int IS_PRIVATE = 1024;
    public static final int IS_ABSTRACT = 2;
    public static final int IS_FINAL = 4;
    protected MethodEntity methodEntity;
    protected ArrayMemory cachedParameters;
    protected boolean hackAccess = false;

    public ReflectionMethod(Environment env, MethodEntity methodEntity) {
        super(env);
        this.setEntity(methodEntity);
    }

    public ReflectionMethod(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    public void setEntity(MethodEntity entity) {
        this.methodEntity = entity;
        this.getProperties().put("name", new StringMemory(entity.getName()));
        this.getProperties().put("class", new StringMemory(entity.getClazz().getName()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="class"), @Reflection.Arg(value="name")})
    public Memory __construct(Environment env, Memory ... args) {
        Memory _class = args[0];
        ClassEntity classEntity = _class.isObject() ? _class.toValue(ObjectMemory.class).getReflection() : env.fetchClass(_class.toString(), true);
        if (classEntity == null) {
            this.exception(env, Messages.ERR_CLASS_NOT_FOUND.fetch(_class), new Object[0]);
            return Memory.NULL;
        }
        MethodEntity entity = classEntity.findMethod(args[1].toString().toLowerCase());
        if (entity == null) {
            this.exception(env, Messages.ERR_METHOD_NOT_FOUND.fetch(_class, args[1]), new Object[0]);
            return Memory.NULL;
        }
        this.setEntity(entity);
        return Memory.NULL;
    }

    @Override
    protected AbstractFunctionEntity getEntity() {
        return this.methodEntity;
    }

    @Override
    @Reflection.Signature
    public Memory getParameters(Environment env, Memory ... args) {
        if (this.cachedParameters != null) {
            return this.cachedParameters;
        }
        ParameterEntity[] parameters = this.methodEntity.getParameters(Integer.MAX_VALUE);
        ClassEntity entity = env.fetchClass("ReflectionParameter");
        ArrayMemory result = new ArrayMemory();
        int i = 0;
        for (ParameterEntity param : parameters) {
            ReflectionParameter e = new ReflectionParameter(env, entity);
            e.setEntity(param);
            e.setFunctionEntity(this.methodEntity);
            e.setPosition(i);
            ++i;
            result.add(new ObjectMemory(e));
        }
        this.cachedParameters = result;
        return this.cachedParameters;
    }

    @Reflection.Signature
    public Memory getDeclaringClass(Environment env, Memory ... args) {
        ClassEntity entity = env.fetchClass("ReflectionClass");
        ReflectionClass r = new ReflectionClass(env, entity);
        r.setEntity(this.methodEntity.getClazz());
        return new ObjectMemory(r);
    }

    @Reflection.Signature
    public Memory getModifiers(Environment env, Memory ... args) {
        int mod = 0;
        if (this.methodEntity.isAbstract()) {
            mod |= 2;
        }
        if (this.methodEntity.isFinal()) {
            mod |= 4;
        }
        if (this.methodEntity.isPrivate()) {
            mod |= 0x400;
        } else if (this.methodEntity.isProtected()) {
            mod |= 0x200;
        } else if (this.methodEntity.isPublic()) {
            mod |= 0x100;
        }
        if (this.methodEntity.isStatic()) {
            mod |= 1;
        }
        return LongMemory.valueOf(mod);
    }

    @Reflection.Signature
    public Memory getPrototype(Environment env, Memory ... args) {
        if (this.methodEntity.getPrototype() == null) {
            return Memory.NULL;
        }
        ClassEntity classEntity = env.fetchClass("ReflectionMethod");
        ReflectionMethod r = new ReflectionMethod(env, classEntity);
        r.setEntity(this.methodEntity.getPrototype());
        return new ObjectMemory(r);
    }

    @Reflection.Signature
    public Memory isConstructor(Environment env, Memory ... args) {
        return this.methodEntity.getClazz().methodConstruct == this.methodEntity ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isDestruct(Environment env, Memory ... args) {
        return this.methodEntity.getClazz().methodDestruct == this.methodEntity ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isAbstract(Environment env, Memory ... args) {
        return this.methodEntity.isAbstract() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isFinal(Environment env, Memory ... args) {
        return this.methodEntity.isFinal() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isStatic(Environment env, Memory ... args) {
        return this.methodEntity.isStatic() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPublic(Environment env, Memory ... args) {
        return this.methodEntity.isPublic() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isProtected(Environment env, Memory ... args) {
        return this.methodEntity.isProtected() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory isPrivate(Environment env, Memory ... args) {
        return this.methodEntity.isPrivate() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="accessible")})
    public Memory setAccessible(Environment env, Memory ... args) {
        this.hackAccess = args[0].toBoolean();
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="object")})
    public Memory getClosure(Environment env, Memory ... args) throws Throwable {
        IObject object;
        if (args[0].isNull()) {
            object = null;
        } else if (args[0].isObject()) {
            object = args[0].toValue(ObjectMemory.class).value;
        } else {
            this.exception(env, "Argument 1 must be NULL or object, %s given", args[0].getRealType().toString());
            return Memory.NULL;
        }
        if (object == null && !this.methodEntity.isStatic()) {
            this.exception(env, "Cannot use method as static", new Object[0]);
            return Memory.NULL;
        }
        if (object != null && this.methodEntity.isStatic()) {
            this.exception(env, "Cannot use method as non static", new Object[0]);
            return Memory.NULL;
        }
        return new ObjectMemory(this.methodEntity.getClosure(env, object));
    }
}

