/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.ext.core.classes.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import php.runtime.Memory;
import php.runtime.annotation.Reflection;
import php.runtime.annotation.Runtime;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.ext.java.JavaException;
import php.runtime.invoke.Invoker;
import php.runtime.lang.BaseObject;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.spl.iterator.Iterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\util\\Regex")
public final class WrapRegex
extends BaseObject
implements Iterator {
    public static final int CANON_EQ = 128;
    public static final int CASE_INSENSITIVE = 2;
    public static final int UNICODE_CASE = 64;
    public static final int UNICODE_CHARACTER_CLASS = 256;
    public static final int COMMENTS = 4;
    public static final int DOTALL = 32;
    public static final int LITERAL = 16;
    public static final int MULTILINE = 8;
    public static final int UNIX_LINES = 1;
    protected Matcher matcher;
    protected String input;
    protected Memory current;
    protected Memory key;
    protected boolean valid = true;

    public WrapRegex(Environment env, Matcher matcher, String input) {
        super(env);
        this.matcher = matcher;
        this.input = input;
    }

    public WrapRegex(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern"), @Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0")), @Reflection.Arg(value="string", optional=@Reflection.Optional(value=""))})
    public Memory __construct(Environment env, Memory ... args) {
        int flags = WrapRegex.convertFlags(args[1]);
        Pattern pattern = Pattern.compile(args[0].toString(), flags);
        this.input = args[2].toString();
        this.matcher = pattern.matcher(this.input);
        return Memory.NULL;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public String getInput() {
        return this.input;
    }

    @Reflection.Signature
    public Memory __debugInfo(Environment env, Memory ... args) {
        ArrayMemory r = new ArrayMemory();
        r.refOfIndex("*pattern").assign(this.matcher.pattern().toString());
        r.refOfIndex("*flags").assign(this.matcher.pattern().flags());
        r.refOfIndex("*input").assign(this.input);
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public Memory with(Environment env, Memory ... args) {
        Matcher matcher1 = this.matcher.pattern().matcher(args[0].toString());
        return new ObjectMemory(new WrapRegex(env, matcher1, args[0].toString()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start", optional=@Reflection.Optional(value="null"))})
    public Memory find(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            return this.matcher.find() ? Memory.TRUE : Memory.FALSE;
        }
        return this.matcher.find(args[0].toInteger()) ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory matches(Environment env, Memory ... args) {
        return this.matcher.matches() ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public Memory test(Environment env, Memory ... args) {
        Matcher matcher1 = this.matcher.pattern().matcher(args[0].toString());
        return TrueMemory.valueOf(matcher1.matches());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="string", optional=@Reflection.Optional(value="null"))})
    public Memory reset(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            this.matcher.reset();
        } else {
            this.matcher.reset(args[0].toString());
        }
        return new ObjectMemory(this);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="group", optional=@Reflection.Optional(value="null"))})
    public Memory end(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            return LongMemory.valueOf(this.matcher.end());
        }
        return LongMemory.valueOf(this.matcher.end(args[0].toInteger()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="group", optional=@Reflection.Optional(value="null"))})
    public Memory start(Environment env, Memory ... args) {
        if (args[0].isNull()) {
            return LongMemory.valueOf(this.matcher.start());
        }
        return LongMemory.valueOf(this.matcher.start(args[0].toInteger()));
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public Memory getGroupCount(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.matcher.groupCount());
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public Memory hitEnd(Environment env, Memory ... args) {
        return this.matcher.hitEnd() ? Memory.TRUE : Memory.FALSE;
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public Memory requireEnd(Environment env, Memory ... args) {
        return this.matcher.requireEnd() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature
    public Memory lookingAt(Environment env, Memory ... args) {
        return this.matcher.lookingAt() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start"), @Reflection.Arg(value="end")})
    public Memory region(Environment env, Memory ... args) {
        this.matcher.region(args[0].toInteger(), args[1].toInteger());
        return new ObjectMemory(this);
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public Memory regionStart(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.matcher.regionStart());
    }

    @Runtime.FastMethod
    @Reflection.Signature
    public Memory regionEnd(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.matcher.regionEnd());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start", optional=@Reflection.Optional(value="null"))})
    public Memory all(Environment env, Memory ... args) {
        int start = args[0].toInteger();
        int count = 0;
        ArrayMemory r = new ArrayMemory();
        while (count == 0 ? this.matcher.find(start) : this.matcher.find()) {
            ++count;
            r.add(this.groups(env, new Memory[0]));
        }
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start", optional=@Reflection.Optional(value="null"))})
    public Memory last(Environment env, Memory ... args) {
        int count = 0;
        int index = args[0].toInteger();
        while (count == 0 ? this.matcher.find(index) : this.matcher.find()) {
            index = this.matcher.start();
            ++count;
        }
        if (count > 0) {
            this.matcher.find(index);
            return this.groups(env, new Memory[0]);
        }
        return Memory.NULL;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start", optional=@Reflection.Optional(value="null"))})
    public Memory first(Environment env, Memory ... args) {
        return this.one(env, args);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="start", optional=@Reflection.Optional(value="null"))})
    public Memory one(Environment env, Memory ... args) {
        int start = args[0].toInteger();
        if (this.matcher.find(start)) {
            return this.groups(env, new Memory[0]);
        }
        return Memory.NULL;
    }

    @Reflection.Signature
    public Memory groups(Environment env, Memory ... args) {
        int count = this.matcher.groupCount();
        ArrayMemory r = new ArrayMemory();
        r.add(this.matcher.group());
        for (int i = 0; i < count; ++i) {
            r.add(this.matcher.group(i + 1));
        }
        return r.toConstant();
    }

    @Reflection.Signature(value={@Reflection.Arg(value="group", optional=@Reflection.Optional(value="null"))})
    public Memory group(Environment env, Memory ... args) {
        Memory longMemory;
        Memory group = args[0];
        if (group.isNull()) {
            return StringMemory.valueOf(this.matcher.group());
        }
        if ((group.isString() || group.isObject()) && (longMemory = StringMemory.toLong(group.toString(), false)) == null) {
            return StringMemory.valueOf(this.matcher.group(group.toString()));
        }
        return StringMemory.valueOf(this.matcher.group(group.toInteger()));
    }

    @Reflection.Signature
    public Memory groupNames() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Map<String, Integer> namedGroups = WrapRegex.getNamedGroups(this.matcher.pattern());
        ArrayMemory r = new ArrayMemory();
        for (String s : namedGroups.keySet()) {
            r.put(s, StringMemory.valueOf(s));
        }
        return r.toConstant();
    }

    private static Map<String, Integer> getNamedGroups(Pattern regex) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Method namedGroupsMethod = Pattern.class.getDeclaredMethod("namedGroups", new Class[0]);
        namedGroupsMethod.setAccessible(true);
        Object namedGroups = null;
        return (Map)namedGroupsMethod.invoke((Object)regex, new Object[0]);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="replacement")})
    public Memory replace(Environment env, Memory ... args) {
        try {
            return StringMemory.valueOf(this.matcher.replaceAll(args[0].toString()));
        }
        catch (IllegalStateException | IndexOutOfBoundsException e) {
            throw new RegexException(env, (Throwable)e);
        }
    }

    @Reflection.Signature(value={@Reflection.Arg(value="replacement")})
    public Memory replaceFirst(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.matcher.replaceFirst(args[0].toString()));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="group"), @Reflection.Arg(value="replacement")})
    public Memory replaceGroup(Environment env, Memory ... args) {
        int group = args[0].toInteger();
        this.matcher.reset();
        if (this.matcher.find()) {
            String what = this.matcher.group(group);
            return StringMemory.valueOf(this.input.replace(what, args[1].toString()));
        }
        return StringMemory.valueOf(this.input);
    }

    @Reflection.Signature(value={@Reflection.Arg(value="callback", type=HintType.CALLABLE)})
    public Memory replaceWithCallback(Environment env, Memory ... args) {
        Memory r;
        Invoker invoker = Invoker.valueOf(env, null, args[0]);
        StringBuffer sb = new StringBuffer();
        ObjectMemory self = new ObjectMemory(this);
        while (this.matcher.find() && (r = invoker.callNoThrow(self)).toValue() != Memory.FALSE) {
            this.matcher.appendReplacement(sb, r.toString());
        }
        this.matcher.appendTail(sb);
        return StringMemory.valueOf(sb.toString());
    }

    @Reflection.Signature
    public Memory getPattern(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.matcher.pattern().pattern());
    }

    @Reflection.Signature
    public Memory getInput(Environment env, Memory ... args) {
        return StringMemory.valueOf(this.getInput());
    }

    @Reflection.Signature
    public Memory getFlags(Environment env, Memory ... args) {
        return LongMemory.valueOf(this.matcher.pattern().flags());
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern"), @Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0")), @Reflection.Arg(value="string", optional=@Reflection.Optional(value=""))})
    public static Memory of(Environment env, Memory ... args) {
        int flags = WrapRegex.convertFlags(args[1]);
        Pattern pattern = Pattern.compile(args[0].toString(), flags);
        Matcher matcher = pattern.matcher(args[2].toString());
        return ObjectMemory.valueOf(new WrapRegex(env, matcher, ""));
    }

    @Reflection.Signature(value={@Reflection.Arg(value="flags")})
    public Memory withFlags(Environment env, Memory ... args) {
        int flags = WrapRegex.convertFlags(args[0]);
        Pattern pattern = Pattern.compile(this.matcher.pattern().pattern(), flags);
        Matcher matcher1 = pattern.matcher(this.input);
        return ObjectMemory.valueOf(new WrapRegex(env, matcher1, this.input));
    }

    @Override
    @Reflection.Signature
    public Memory current(Environment env, Memory ... args) {
        return this.current == null ? Memory.NULL : this.current;
    }

    @Override
    @Reflection.Signature
    public Memory key(Environment env, Memory ... args) {
        return this.key == null ? Memory.NULL : this.key;
    }

    @Override
    @Reflection.Signature
    public Memory next(Environment env, Memory ... args) {
        this.valid = this.matcher.find();
        if (this.valid) {
            this.current = StringMemory.valueOf(this.matcher.group());
            this.key = this.key.inc();
        } else {
            this.key = Memory.NULL;
            this.current = Memory.NULL;
        }
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory rewind(Environment env, Memory ... args) {
        this.key = Memory.CONST_INT_M1;
        this.matcher.reset();
        this.next(env, new Memory[0]);
        return Memory.NULL;
    }

    @Override
    @Reflection.Signature
    public Memory valid(Environment env, Memory ... args) {
        return this.valid ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern"), @Reflection.Arg(value="string"), @Reflection.Arg(value="flags", optional=@Reflection.Optional(value="0"))})
    public static Memory match(Environment env, Memory ... args) {
        Pattern pattern = Pattern.compile(args[0].toString(), WrapRegex.convertFlags(args[2]));
        return pattern.matcher(args[1].toString()).find() ? Memory.TRUE : Memory.FALSE;
    }

    @Reflection.Signature(value={@Reflection.Arg(value="pattern"), @Reflection.Arg(value="string"), @Reflection.Arg(value="limit", optional=@Reflection.Optional(value="0"))})
    public static Memory split(Environment env, Memory ... args) {
        int limit = args[2].toInteger();
        String[] r = limit <= 0 ? args[1].toString().split(args[0].toString()) : args[1].toString().split(args[0].toString(), limit);
        return ArrayMemory.ofStrings(r).toConstant();
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory quote(Environment env, Memory ... args) {
        return StringMemory.valueOf(Pattern.quote(args[0].toString()));
    }

    @Runtime.FastMethod
    @Reflection.Signature(value={@Reflection.Arg(value="string")})
    public static Memory quoteReplacement(Environment env, Memory ... args) {
        return StringMemory.valueOf(Matcher.quoteReplacement(args[0].toString()));
    }

    @Reflection.Signature
    private Memory __clone(Environment env, Memory ... args) {
        return Memory.NULL;
    }

    @Override
    public ForeachIterator getNewIterator(Environment env, boolean getReferences, boolean getKeyReferences) {
        return ObjectMemory.valueOf(this).getNewIterator(env, getReferences, getKeyReferences);
    }

    @Override
    public ForeachIterator getNewIterator(Environment env) {
        return ObjectMemory.valueOf(this).getNewIterator(env);
    }

    private static int convertFlags(Memory _flags) {
        int result = 0;
        if (_flags.isNumber()) {
            return _flags.toInteger();
        }
        String flags = _flags.toString();
        if (StringMemory.toLong(flags) != null) {
            return _flags.toInteger();
        }
        block10: for (int i = 0; i < flags.length(); ++i) {
            char c = flags.charAt(i);
            switch (c) {
                case 'i': {
                    result |= 2;
                    continue block10;
                }
                case 'm': {
                    result |= 8;
                    continue block10;
                }
                case 'L': {
                    result |= 0x10;
                    continue block10;
                }
                case 'd': {
                    result |= 1;
                    continue block10;
                }
                case 'u': {
                    result |= 0x40;
                    continue block10;
                }
                case 'U': {
                    result |= 0x100;
                    continue block10;
                }
                case 'x': {
                    result |= 4;
                    continue block10;
                }
                case 's': {
                    result |= 0x20;
                }
            }
        }
        return result;
    }

    @Reflection.Name(value="php\\util\\RegexException")
    public static class RegexException
    extends JavaException {
        public RegexException(Environment env, Throwable throwable) {
            super(env, throwable);
        }

        public RegexException(Environment env, ClassEntity clazz) {
            super(env, clazz);
        }
    }
}

