/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.env;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import php.runtime.Memory;
import php.runtime.common.AbstractCompiler;
import php.runtime.common.Callback;
import php.runtime.common.Constants;
import php.runtime.common.LangMode;
import php.runtime.common.Messages;
import php.runtime.common.StringUtils;
import php.runtime.env.CallStack;
import php.runtime.env.CallStackItem;
import php.runtime.env.CompileScope;
import php.runtime.env.Context;
import php.runtime.env.DieException;
import php.runtime.env.ModuleManager;
import php.runtime.env.SourceMappedTraceInfo;
import php.runtime.env.SplClassLoader;
import php.runtime.env.TraceInfo;
import php.runtime.env.handler.ConfigChangeHandler;
import php.runtime.env.handler.ErrorHandler;
import php.runtime.env.handler.ErrorReportHandler;
import php.runtime.env.handler.ExceptionHandler;
import php.runtime.env.handler.ShellExecHandler;
import php.runtime.env.handler.ShutdownHandler;
import php.runtime.env.handler.TickHandler;
import php.runtime.env.message.CustomSystemMessage;
import php.runtime.env.message.NoticeMessage;
import php.runtime.env.message.SystemMessage;
import php.runtime.env.message.WarningMessage;
import php.runtime.exceptions.CriticalException;
import php.runtime.exceptions.CustomErrorException;
import php.runtime.exceptions.FatalException;
import php.runtime.exceptions.FinallyException;
import php.runtime.exceptions.JPHPException;
import php.runtime.exceptions.support.ErrorException;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.ext.core.classes.WrapEnvironmentVariables;
import php.runtime.ext.java.JavaReflection;
import php.runtime.ext.support.Extension;
import php.runtime.ext.support.compile.CompileConstant;
import php.runtime.invoke.Invoker;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.lang.BaseException;
import php.runtime.lang.Closure;
import php.runtime.lang.ForeachIterator;
import php.runtime.lang.IObject;
import php.runtime.lang.UncaughtException;
import php.runtime.lang.exception.BaseBaseException;
import php.runtime.lang.exception.BaseError;
import php.runtime.lang.exception.BaseParseError;
import php.runtime.loader.dump.ModuleDumper;
import php.runtime.loader.sourcemap.SourceMap;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.output.OutputBuffer;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.ConstantEntity;
import php.runtime.reflection.FunctionEntity;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.ModuleEntity;
import php.runtime.reflection.support.ReflectionUtils;
import php.runtime.util.JVMStackTracer;

public class Environment {
    public final int id;
    public final CompileScope scope;
    public final Map<String, Memory> configuration = new HashMap<String, Memory>();
    public static final Map<String, ConfigChangeHandler> configurationHandler;
    private CallStack callStack = new CallStack(this);
    private Set<String> includePaths;
    public SplClassLoader __autoload = null;
    public SplClassLoader defaultAutoLoader = null;
    protected final List<SplClassLoader> classLoaders = new LinkedList<SplClassLoader>();
    private int errorFlags;
    private Stack<Integer> silentFlags;
    private SystemMessage lastMessage;
    private ErrorReportHandler errorReportHandler;
    private ErrorHandler previousErrorHandler;
    private ErrorHandler errorHandler;
    private ShellExecHandler shellExecHandler;
    private ExceptionHandler previousExceptionHandler;
    private ExceptionHandler exceptionHandler;
    private OutputBuffer defaultBuffer;
    private Stack<OutputBuffer> outputBuffers;
    private List<ShutdownHandler> shutdownFunctions;
    protected Map<String, SourceMap> sourceMaps;
    private Locale locale;
    private Charset defaultCharset;
    protected final ArrayMemory globals;
    protected final Map<String, ReferenceMemory> statics;
    protected final Map<String, Object> userValues;
    public final Map<String, ClassEntity> classMap;
    protected final Map<String, FunctionEntity> functionMap;
    protected final Map<String, ConstantEntity> constantMap;
    protected final ModuleManager moduleManager;
    protected static final ThreadLocal<Environment> environment;
    private final ReferenceQueue<IObject> gcObjectRefQueue;
    private final Set<WeakReference<IObject>> gcObjects;
    private static final AtomicInteger ids;
    private static final Stack<Integer> freeIds;
    private final Set<String> autoloadLocks;
    private static ForeachIterator invalidIterator;

    @Deprecated
    public static Environment current() {
        return environment.get();
    }

    public static void catchThrowable(Throwable e, Environment environment) {
        Environment env;
        if (e instanceof BaseBaseException) {
            BaseBaseException baseException = (BaseBaseException)e;
            baseException.getEnvironment().catchUncaught(baseException);
            return;
        }
        if (e instanceof Exception) {
            Environment environment2 = env = environment == null ? null : environment;
            if (env != null) {
                try {
                    env.catchUncaught((Exception)e);
                }
                catch (RuntimeException e2) {
                    e2.getCause().printStackTrace(new PrintStream(env.getDefaultBuffer().getOutput()));
                }
                return;
            }
        }
        Environment environment3 = env = environment == null ? null : environment;
        if (env != null) {
            e.printStackTrace(new PrintStream(env.getDefaultBuffer().getOutput()));
        } else {
            e.printStackTrace();
        }
    }

    public static void addThreadSupport(Environment env) {
        Environment.addThreadSupport(Thread.currentThread(), env);
    }

    public static void addThreadSupport(Thread thread, final Environment env) {
        thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Environment.catchThrowable(e, env);
            }
        });
    }

    public Environment(Environment parent) {
        this(parent, parent.defaultBuffer.getOutput());
    }

    public Environment(Environment parent, OutputStream output) {
        this(parent.scope, parent.defaultBuffer.getOutput());
        this.configuration.putAll(parent.configuration);
        this.classMap.putAll(parent.classMap);
        for (ClassEntity e : this.classMap.values()) {
            try {
                e.initEnvironment(this);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        this.functionMap.putAll(parent.functionMap);
        this.constantMap.putAll(parent.constantMap);
        this.moduleManager.apply(parent.moduleManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Environment(CompileScope scope, OutputStream output) {
        this.errorFlags = ErrorType.E_ALL.value ^ (ErrorType.E_NOTICE.value | ErrorType.E_STRICT.value | ErrorType.E_DEPRECATED.value);
        this.silentFlags = new Stack();
        this.shellExecHandler = ShellExecHandler.DEFAULT;
        this.exceptionHandler = ExceptionHandler.DEFAULT;
        this.shutdownFunctions = new LinkedList<ShutdownHandler>();
        this.sourceMaps = new HashMap<String, SourceMap>();
        this.locale = Locale.getDefault();
        this.defaultCharset = Charset.forName("UTF-8");
        this.userValues = new HashMap<String, Object>();
        this.classMap = new LinkedHashMap<String, ClassEntity>();
        this.functionMap = new LinkedHashMap<String, FunctionEntity>();
        this.constantMap = new LinkedHashMap<String, ConstantEntity>();
        this.gcObjectRefQueue = new ReferenceQueue();
        this.gcObjects = new HashSet<WeakReference<IObject>>();
        this.autoloadLocks = new HashSet<String>();
        Environment.addThreadSupport(this);
        this.scope = scope;
        Stack<Integer> stack = freeIds;
        synchronized (stack) {
            this.id = freeIds.empty() ? ids.getAndIncrement() : freeIds.peek().intValue();
        }
        this.moduleManager = new ModuleManager(this);
        this.outputBuffers = new Stack();
        this.defaultBuffer = new OutputBuffer(this, null);
        this.defaultBuffer.setOutput(output);
        Stack<OutputBuffer> buffers = this.getOutputBuffers();
        if (buffers.isEmpty()) {
            buffers.push(this.defaultBuffer);
        }
        this.includePaths = new HashSet<String>();
        this.globals = new ArrayMemory();
        this.statics = new HashMap<String, ReferenceMemory>();
        this.setErrorReportHandler(new ErrorReportHandler(){

            @Override
            public boolean onError(SystemMessage error) {
                Environment.this.echo(error.getDebugMessage());
                Environment.this.echo("\n");
                return false;
            }

            @Override
            public boolean onFatal(ErrorException error) {
                Environment.this.echo("\n");
                Environment.this.echo(error.getType().getTypeName() + ": " + error.getMessage());
                if (error.getTraceInfo() != null) {
                    Environment.this.echo(" in " + error.getTraceInfo().getFileName() + " on line " + (error.getTraceInfo().getStartLine() + 1) + ", position " + (error.getTraceInfo().getStartPosition() + 1));
                }
                return false;
            }
        });
        this.globals.put("GLOBALS", this.globals);
        this.globals.put("_ENV", ObjectMemory.valueOf(new WrapEnvironmentVariables(this)));
        this.functionMap.putAll(scope.getFunctionMap());
        this.constantMap.putAll(scope.getConstantMap());
        StringMemory splAutoloader = new StringMemory("__$jphp_spl_autoload");
        Invoker invoker = Invoker.valueOf(this, null, splAutoloader);
        if (invoker != null) {
            this.defaultAutoLoader = new SplClassLoader(invoker, splAutoloader);
        }
        for (Extension e : scope.extensions.values()) {
            e.onLoad(this);
        }
        environment.set(this);
    }

    public void doFinal() throws Throwable {
        for (ShutdownHandler handler : this.shutdownFunctions) {
            try {
                handler.call();
            }
            catch (DieException e) {
                this.finalizeObjects();
                this.catchUncaught(e);
                break;
            }
            catch (BaseBaseException e) {
                this.catchUncaught(e);
                break;
            }
            catch (ErrorException e) {
                this.catchUncaught(e);
                break;
            }
            catch (Exception e) {
                this.catchUncaught(e);
                break;
            }
        }
        this.finalizeObjects();
        this.flushAll();
        this.lastMessage = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        freeIds.push(this.id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizeObjects() throws Throwable {
        this.cleanGcObjects();
        for (WeakReference<IObject> el : this.gcObjects) {
            IObject o = (IObject)el.get();
            if (o == null) continue;
            ClassEntity entity = o.getReflection();
            if (entity.methodDestruct == null || o.isFinalized()) continue;
            o.doFinalize();
            this.pushCall(o, entity.methodDestruct.getName(), new Memory[0]);
            try {
                entity.methodDestruct.invokeDynamic(o, this, new Memory[0]);
            }
            finally {
                this.popCall();
            }
        }
        this.gcObjects.clear();
    }

    private void cleanGcObjects() throws Throwable {
        Reference<IObject> object;
        while ((object = this.gcObjectRefQueue.poll()) != null) {
            this.gcObjects.remove(object);
        }
    }

    public void pushCall(CallStackItem stackItem) {
        this.getCallStack().push(stackItem);
    }

    public void pushCall(TraceInfo trace, IObject self, Memory[] args, String function, String clazz, String staticClazz) {
        this.getCallStack().push(trace, self, args, function, clazz, staticClazz);
    }

    public void pushCall(IObject self, String method, Memory ... args) {
        this.getCallStack().push(self, method, args);
    }

    public void pushCall(TraceInfo trace, IObject self, String method, Memory ... args) {
        this.getCallStack().push(trace, self, method, args);
    }

    public void popCall() {
        this.getCallStack().pop();
    }

    public CallStackItem peekCall(int depth) {
        return this.getCallStack().peekCall(depth);
    }

    public TraceInfo trace() {
        return this.getCallStack().trace();
    }

    public TraceInfo trace(int systemOffsetStackTrace) {
        return this.getCallStack().trace(systemOffsetStackTrace);
    }

    public int getCallStackTop() {
        return this.getCallStack().getTop();
    }

    public CallStackItem[] getCallStackSnapshot() {
        return this.getCallStack().getSnapshot();
    }

    public Environment(OutputStream output) {
        this(new CompileScope(), output);
    }

    public Environment(CompileScope scope) {
        this(scope, null);
    }

    public Environment() {
        this((OutputStream)null);
    }

    public Stack<OutputBuffer> getOutputBuffers() {
        return this.outputBuffers;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String findInIncludePaths(String path) {
        if (new File(path).exists()) {
            return path;
        }
        for (String e : this.includePaths) {
            if (!new File(e, path).exists()) continue;
            return e + path;
        }
        return null;
    }

    public ModuleManager getModuleManager() {
        return this.moduleManager;
    }

    public CompileScope getScope() {
        return this.scope;
    }

    public Collection<FunctionEntity> getFunctions() {
        return this.functionMap.values();
    }

    public Collection<ClassEntity> getClasses() {
        return this.classMap.values();
    }

    public ArrayMemory getGlobals() {
        return this.globals;
    }

    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    public Set<String> getIncludePaths() {
        return this.includePaths;
    }

    public void addIncludePath(String value) {
        this.includePaths.add(value);
    }

    public void setIncludePaths(Set<String> includePaths) {
        this.includePaths = includePaths;
    }

    public Map<String, ClassEntity> getLoadedClasses() {
        return this.classMap;
    }

    public Map<String, FunctionEntity> getLoadedFunctions() {
        return this.functionMap;
    }

    public boolean isLoadedClass(String lowerName) {
        return this.classMap.containsKey(lowerName);
    }

    public boolean isLoadedFunction(String lowerName) {
        return this.functionMap.containsKey(lowerName);
    }

    public boolean isLoadedConstant(String lowerName) {
        return this.constantMap.containsKey(lowerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassEntity autoloadCall(String name, String lowerName) {
        Set<String> set = this.autoloadLocks;
        synchronized (set) {
            if (StringUtils.isValidClassName(name) && this.autoloadLocks.add(lowerName)) {
                StringMemory tmp = new StringMemory(name);
                for (SplClassLoader loader : this.classLoaders) {
                    loader.load(tmp);
                    ClassEntity classEntity = this.fetchClass(name, false);
                    if (classEntity == null) continue;
                    this.autoloadLocks.remove(lowerName);
                    return classEntity;
                }
                if (this.defaultAutoLoader != null) {
                    this.defaultAutoLoader.load(tmp);
                }
                this.autoloadLocks.remove(lowerName);
                return this.fetchClass(name, false);
            }
            return null;
        }
    }

    public ClassEntity fetchClass(Class<?> clazz) {
        ClassEntity result = this.fetchClass(ReflectionUtils.getClassName(clazz), false);
        if (result == null) {
            throw new CriticalException("Native class is not registered - " + clazz.getName());
        }
        return result;
    }

    public ClassEntity fetchClass(String name) {
        return this.fetchClass(name, false);
    }

    public ClassEntity fetchClass(String name, boolean autoLoad) {
        return this.fetchClass(name, name.toLowerCase(), autoLoad);
    }

    public ClassEntity fetchMagicClass(String name) {
        return this.fetchMagicClass(name, name.toLowerCase());
    }

    public ClassEntity fetchMagicClass(String name, String nameL) {
        if ("self".equals(nameL)) {
            ClassEntity e = this.getContextClass();
            if (e == null) {
                e = this.getLateStaticClass();
            }
            return e;
        }
        if ("static".equals(nameL)) {
            return this.getLateStaticClass();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassEntity fetchClass(String name, String nameL, boolean autoLoad) {
        ClassEntity entity = this.classMap.get(nameL);
        if (entity != null) {
            return entity;
        }
        Map<String, ClassEntity> map = this.classMap;
        synchronized (map) {
            entity = this.classMap.get(nameL);
            if (entity == null) {
                entity = this.scope.fetchUserClass(name, nameL);
                if (entity != null) {
                    try {
                        entity.initEnvironment(this);
                    }
                    catch (Throwable throwable) {
                        throw new CriticalException(throwable);
                    }
                    this.classMap.put(entity.getLowerName(), entity);
                    return entity;
                }
                ClassEntity classEntity = autoLoad ? this.autoloadCall(name, nameL) : null;
                return classEntity;
            }
            return entity;
        }
    }

    public FunctionEntity fetchFunction(String name) {
        return this.fetchFunction(name, name.toLowerCase());
    }

    public FunctionEntity fetchFunction(String name, String nameL) {
        FunctionEntity r = this.functionMap.get(nameL);
        if (r == null) {
            r = this.scope.findUserFunction(name);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerFunction(FunctionEntity entity) {
        Map<String, FunctionEntity> map = this.functionMap;
        synchronized (map) {
            if (this.functionMap.containsKey(entity.getLowerName())) {
                this.exception("Function '%s' already registered", entity.getName());
            }
            this.functionMap.put(entity.getLowerName(), entity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerClass(ClassEntity entity) {
        Map<String, ClassEntity> map = this.classMap;
        synchronized (map) {
            if (this.classMap.containsKey(entity.getLowerName())) {
                this.exception("Class '%s' already registered", entity.getName());
            }
            this.classMap.put(entity.getLowerName(), entity);
            entity.initEnvironment(this);
        }
    }

    public Map<String, ConstantEntity> getConstants() {
        return this.constantMap;
    }

    public Memory findConstant(String name, String nameLower) {
        ConstantEntity entity = this.constantMap.get(nameLower);
        if (entity != null && (!entity.caseSensitise || name.equals(entity.getName()))) {
            return entity.getValue();
        }
        CompileConstant constant = this.scope.findCompileConstant(name);
        if (constant != null) {
            return constant.value;
        }
        return null;
    }

    public Memory findConstant(String name) {
        return this.findConstant(name, name.toLowerCase());
    }

    public boolean defineConstant(String name, Memory value, boolean caseSensitise) {
        Memory constant = this.findConstant(name);
        if (constant != null) {
            return false;
        }
        this.constantMap.put(name.toLowerCase(), new ConstantEntity(name, value, caseSensitise));
        return true;
    }

    public Memory getConfigValue(String name, Memory defaultValue) {
        Memory result = null;
        if (this.scope.configuration == null || (result = this.configuration.get(name)) != null) {
            if (result == null) {
                result = this.configuration.get(name);
            }
            if (result == null) {
                return defaultValue;
            }
            return result;
        }
        result = this.scope.configuration.get(name);
        return result == null ? defaultValue : result;
    }

    public Memory getConfigValue(String name) {
        return this.getConfigValue(name, null);
    }

    public ArrayMemory getConfigValues(String prefix, boolean includingGlobal) {
        String key;
        if (prefix != null) {
            prefix = prefix + ".";
        }
        ArrayMemory result = new ArrayMemory();
        if (includingGlobal && this.scope.configuration != null) {
            for (Map.Entry<String, Memory> entry : this.scope.configuration.entrySet()) {
                key = entry.getKey();
                if (prefix != null && !key.startsWith(prefix)) continue;
                result.put(key, entry.getValue().toImmutable());
            }
        }
        for (Map.Entry<String, Memory> entry : this.configuration.entrySet()) {
            key = entry.getKey();
            if (prefix != null && !key.startsWith(prefix)) continue;
            result.put(key, entry.getValue().toImmutable());
        }
        return result;
    }

    public Memory setConfigValue(String name, Memory value) {
        ConfigChangeHandler handler;
        if (!(value = value.toValue()).isString()) {
            value = new StringMemory(value.toString());
        }
        if ((handler = configurationHandler.get(name)) != null) {
            handler.onChange(this, value);
        }
        return this.configuration.put(name, value);
    }

    public void restoreConfigValue(String name) {
        this.configuration.remove(name);
        ConfigChangeHandler handler = configurationHandler.get(name);
        if (handler != null) {
            handler.onChange(this, this.getConfigValue(name));
        }
    }

    public Memory getOrCreateGlobal(String name) {
        return this.globals.refOfIndex(name);
    }

    public Memory getOrCreateStatic(String name, Memory initValue) {
        ReferenceMemory result = this.statics.get(name);
        if (result == null) {
            result = new ReferenceMemory(initValue);
            this.statics.put(name, result);
        }
        return result;
    }

    public Memory getStatic(String name) {
        return this.statics.get(name);
    }

    public <T> T getUserValue(String name, Class<T> clazz) {
        return (T)this.userValues.get(name);
    }

    public void setUserValue(String name, Object value) {
        this.userValues.put(name, value);
    }

    public <T> T getUserValue(Class<T> clazz) {
        Objects.requireNonNull(clazz);
        return this.getUserValue(clazz.getName(), clazz);
    }

    public <T> void setUserValue(T object) {
        Objects.requireNonNull(object);
        this.setUserValue(object.getClass().getName(), object);
    }

    public boolean removeUserValue(String name) {
        return this.userValues.remove(name) != null;
    }

    public int getErrorFlags() {
        return this.errorFlags;
    }

    public void setErrorFlags(int errorFlags) {
        this.errorFlags = errorFlags;
    }

    public SystemMessage getLastMessage() {
        return this.lastMessage;
    }

    public ShellExecHandler getShellExecHandler() {
        return this.shellExecHandler;
    }

    public void setShellExecHandler(ShellExecHandler shellExecHandler) {
        this.shellExecHandler = shellExecHandler;
    }

    public ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        this.previousExceptionHandler = this.exceptionHandler;
        this.exceptionHandler = exceptionHandler == null ? ExceptionHandler.DEFAULT : exceptionHandler;
    }

    public ErrorReportHandler getErrorReportHandler() {
        return this.errorReportHandler;
    }

    public void setErrorReportHandler(ErrorReportHandler errorReportHandler) {
        this.errorReportHandler = errorReportHandler;
    }

    public ExceptionHandler getPreviousExceptionHandler() {
        return this.previousExceptionHandler;
    }

    public ErrorHandler getPreviousErrorHandler() {
        return this.previousErrorHandler;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void triggerError(ErrorException err) {
        ErrorType type = err.getType();
        if (type.isFatal() || this.isHandleErrors(type)) {
            this.lastMessage = new CustomSystemMessage(err.getType(), new CallStackItem(err.getTraceInfo()), new Messages.Item(err.getMessage()), new Object[0]);
            throw err;
        }
    }

    public void forwardThrow(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    public void wrapThrow(Throwable throwable) {
        if (!(throwable instanceof Exception)) {
            throw new RuntimeException(throwable);
        }
        this.catchUncaught((Exception)throwable);
    }

    public boolean catchUncaught(Exception e) {
        return this.catchUncaught(e, false);
    }

    public boolean catchUncaught(Exception e, boolean retry) {
        if (e instanceof UncaughtException) {
            return this.catchUncaught((UncaughtException)e);
        }
        if (e instanceof DieException) {
            System.exit(((DieException)e).getExitCode());
            return true;
        }
        if (e instanceof ErrorException) {
            ErrorException er = (ErrorException)e;
            this.getErrorReportHandler().onFatal(er);
            JVMStackTracer tracer = this.scope.getStackTracer(e);
            int i = 0;
            for (JVMStackTracer.Item el : tracer) {
                if (el.isInternal()) continue;
                this.echo("\n\t #" + i++ + " " + el);
            }
            this.echo("\n");
            for (JVMStackTracer.Item el : tracer) {
                if (el.isSystem()) continue;
                this.echo("\n\t " + (el.isInternal() ? "" : "->") + " " + el);
            }
            return true;
        }
        if (e instanceof FinallyException) {
            return true;
        }
        if (e instanceof BaseBaseException) {
            BaseBaseException be = (BaseBaseException)e;
            if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.onException(this, be);
                }
                catch (BaseBaseException _e) {
                    if (retry) {
                        throw new RuntimeException(_e);
                    }
                    this.catchUncaught(_e, true);
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                return true;
            }
            try {
                ExceptionHandler.DEFAULT.onException(this, be);
                return true;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
        throw new RuntimeException(e);
    }

    public boolean catchUncaught(UncaughtException e) {
        if (this.exceptionHandler != null) {
            try {
                if (!(e.getException() instanceof FinallyException)) {
                    this.exceptionHandler.onException(this, e.getException());
                }
            }
            catch (BaseBaseException _e) {
                this.catchUncaught(_e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            return true;
        }
        return false;
    }

    public void error(TraceInfo trace, ErrorType type, String message, Object ... args) {
        this.error(trace, type, new Messages.Item(message), args);
    }

    public void error(TraceInfo trace, ErrorType type, Messages.Item message, Object ... args) {
        if (type.isFatal()) {
            if (this.scope.getLangMode() == LangMode.MODERN) {
                if (type == ErrorType.E_PARSE) {
                    this.exception(trace, new BaseParseError(this), message.fetch(args), new Object[0]);
                } else {
                    this.exception(trace, new BaseError(this, type), message.fetch(args), new Object[0]);
                }
            }
            if (type.isHandled() && this.errorHandler != null && ErrorType.check(this.errorHandler.errorHandlerFlags, type)) {
                this.triggerMessage(new CustomSystemMessage(type, new CallStackItem(trace), message, args));
            } else {
                this.triggerError(new CustomErrorException(type, message.fetch(args), trace));
            }
        } else {
            this.triggerMessage(new CustomSystemMessage(type, new CallStackItem(trace), message, args));
        }
    }

    public void error(ErrorType type, String message, Object ... args) {
        this.error(this.trace(), type, message, args);
    }

    public void error(TraceInfo trace, String message, Object ... args) {
        this.error(trace, ErrorType.E_ERROR, message, args);
    }

    public void triggerMessage(SystemMessage message) {
        this.lastMessage = message;
        if (this.errorHandler != null && this.errorHandler.onError(this, message)) {
            return;
        }
        if (this.errorReportHandler != null && this.isHandleErrors(message.getType())) {
            this.errorReportHandler.onError(message);
        }
    }

    public void exception(TraceInfo trace, String message, Object ... args) {
        BaseException e = new BaseException(this);
        this.exception(trace, e, message, args);
    }

    public void exception(String message, Object ... args) {
        this.exception(this.trace(), message, args);
    }

    public void exception(TraceInfo trace, BaseError e, String message, Object ... args) {
        this.__clearSilent();
        if (args == null || args.length == 0) {
            e.__construct(this, new StringMemory(message));
        } else {
            e.__construct(this, new StringMemory(String.format(message, args)));
        }
        e.setTraceInfo(this, trace);
        throw e;
    }

    public void exception(TraceInfo trace, BaseException e, String message, Object ... args) {
        this.__clearSilent();
        if (args == null || args.length == 0) {
            e.__construct(this, new StringMemory(message));
        } else {
            e.__construct(this, new StringMemory(String.format(message, args)));
        }
        e.setTraceInfo(this, trace);
        throw e;
    }

    public void exception(BaseException e, String message, Object ... args) {
        this.exception(this.trace(), e, message, args);
    }

    public void exception(BaseError e, String message, Object ... args) {
        this.exception(this.trace(), e, message, args);
    }

    public void exception(Class<? extends BaseBaseException> e, String message, Object ... args) {
        this.exception(this.trace(), e, message, args);
    }

    public void exception(TraceInfo trace, Class<? extends BaseBaseException> e, String message, Object ... args) {
        ClassEntity entity = this.fetchClass(e);
        Object object = entity.newObjectWithoutConstruct(this);
        if (object instanceof BaseException) {
            this.exception(trace, (BaseException)object, message, args);
        } else if (object instanceof BaseError) {
            this.exception(trace, (BaseError)object, message, args);
        } else {
            throw new CriticalException("Unable to create extension object from class " + e.getName());
        }
    }

    public boolean isHandleErrors(ErrorType type) {
        return ErrorType.check(this.errorFlags, type);
    }

    public void warning(String message, Object ... args) {
        this.triggerMessage(new WarningMessage(this.peekCall(0), new Messages.Item(message), args));
    }

    public void warning(TraceInfo trace, String message, Object ... args) {
        this.error(trace, ErrorType.E_WARNING, message, args);
    }

    public void warning(TraceInfo trace, Messages.Item message, Object ... args) {
        this.error(trace, ErrorType.E_WARNING, message, args);
    }

    public void notice(String message, Object ... args) {
        this.triggerMessage(new NoticeMessage(this.peekCall(0), new Messages.Item(message), args));
    }

    public OutputBuffer getDefaultBuffer() {
        return this.defaultBuffer;
    }

    public OutputBuffer pushOutputBuffer(Memory callback, int chunkSize, boolean erase) {
        Stack<OutputBuffer> outputBuffers = this.getOutputBuffers();
        OutputBuffer buffer = new OutputBuffer(this, this.peekOutputBuffer(), callback, chunkSize, erase);
        buffer.setLevel(outputBuffers.size());
        buffer.setType(OutputBuffer.Type.USER);
        outputBuffers.push(buffer);
        return buffer;
    }

    public OutputBuffer popOutputBuffer() throws Throwable {
        Stack<OutputBuffer> outputBuffers = this.getOutputBuffers();
        if (outputBuffers.empty()) {
            return null;
        }
        if (outputBuffers.peek().isRoot()) {
            return null;
        }
        OutputBuffer result = outputBuffers.pop();
        result.close();
        return result;
    }

    public List<OutputBuffer> allOutputBuffers() {
        Stack<OutputBuffer> outputBuffers = this.getOutputBuffers();
        ArrayList<OutputBuffer> result = new ArrayList<OutputBuffer>();
        for (OutputBuffer el : outputBuffers) {
            result.add(el);
        }
        return result;
    }

    public OutputBuffer peekOutputBuffer() {
        Stack<OutputBuffer> outputBuffers = this.getOutputBuffers();
        return outputBuffers.empty() ? null : outputBuffers.peek();
    }

    public void echo(byte[] bytes, int length) {
        OutputBuffer buffer = this.peekOutputBuffer();
        if (buffer != null) {
            try {
                buffer.write(bytes, length);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public void echo(Memory value) {
        OutputBuffer buffer = this.peekOutputBuffer();
        if (buffer != null) {
            try {
                buffer.write(value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public void echo(String value) {
        OutputBuffer buffer = this.peekOutputBuffer();
        if (buffer != null) {
            try {
                buffer.write(value);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        }
    }

    public void flushAll() throws Throwable {
        while (this.popOutputBuffer() != null) {
        }
        this.defaultBuffer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleEntity importCompiledModule(Context context, boolean debugInformation) throws Throwable {
        ModuleEntity module;
        String moduleName = context.getModuleName();
        ModuleEntity moduleEntity = module = moduleName == null ? null : this.scope.findUserModule(moduleName);
        if (module == null) {
            ModuleDumper moduleDumper = new ModuleDumper(context, this, debugInformation);
            module = moduleDumper.load(context.getInputStream(this.getDefaultCharset()));
            CompileScope compileScope = this.scope;
            synchronized (compileScope) {
                this.scope.loadModule(module);
            }
        }
        this.registerModule(module);
        this.scope.addUserModule(module);
        return module;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleEntity importModule(Context context) throws Throwable {
        ModuleEntity module;
        String moduleName = context.getModuleName();
        ModuleEntity moduleEntity = module = moduleName == null ? null : this.scope.findUserModule(moduleName);
        if (module == null) {
            AbstractCompiler compiler = this.scope.createCompiler(this, context);
            module = compiler.compile(true);
            CompileScope compileScope = this.scope;
            synchronized (compileScope) {
                this.scope.loadModule(module);
            }
        }
        this.registerModule(module);
        return module;
    }

    public void registerSourceMap(SourceMap sourceMap) {
        this.sourceMaps.put(sourceMap.getModuleName(), sourceMap);
    }

    public void unregisterSourceMap(SourceMap sourceMap) {
        this.sourceMaps.remove(sourceMap.getModuleName());
    }

    public void registerModule(ModuleEntity module) {
        this.registerModule(module, false);
    }

    public void registerModule(ModuleEntity module, boolean ignoreErrors) {
        for (ClassEntity classEntity : module.getClasses()) {
            if (!classEntity.isStatic()) continue;
            classEntity.setModule(module);
            if (this.classMap.put(classEntity.getLowerName(), classEntity) == null || ignoreErrors) continue;
            this.error(classEntity.getTrace(), Messages.ERR_CANNOT_REDECLARE_CLASS.fetch(classEntity.getName()), new Object[0]);
        }
        for (FunctionEntity functionEntity : module.getFunctions()) {
            if (!functionEntity.isStatic()) continue;
            functionEntity.setModule(module);
            if (this.functionMap.put(functionEntity.getLowerName(), functionEntity) == null || ignoreErrors) continue;
            this.error(functionEntity.getTrace(), Messages.ERR_CANNOT_REDECLARE_FUNCTION.fetch(functionEntity.getName()), new Object[0]);
        }
        for (ConstantEntity constantEntity : module.getConstants()) {
            constantEntity.setModule(module);
            if (this.constantMap.put(constantEntity.getLowerName(), constantEntity) == null || ignoreErrors) continue;
            this.error(constantEntity.getTrace(), Messages.ERR_CANNOT_REDECLARE_CONSTANT.fetch(constantEntity.getName()), new Object[0]);
        }
    }

    public void __tick(TraceInfo trace, ArrayMemory locals) {
        TickHandler tickHandler = this.scope.getTickHandler();
        if (tickHandler != null) {
            IObject $this = this.getLateObject();
            if ($this != null) {
                Memory value = ObjectMemory.valueOf($this);
                if ($this instanceof Closure) {
                    value = ((Closure)$this).getSelf();
                }
                if (value.isObject()) {
                    locals.putAsKeyString("this", value);
                }
            }
            tickHandler.onTick(this, trace, locals);
        }
    }

    public Memory __getConstant(String name, String lowerName, TraceInfo trace) {
        int p;
        Memory constant = this.findConstant(name, lowerName);
        if (constant == null && (p = name.lastIndexOf(92)) > -1) {
            name = name.substring(p + 1);
            lowerName = lowerName.substring(p + 1);
            constant = this.findConstant(name, lowerName);
        }
        if (constant == null) {
            this.error(trace, ErrorType.E_NOTICE, Messages.ERR_USE_UNDEFINED_CONSTANT, name, name);
            return StringMemory.valueOf(name);
        }
        return constant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Memory __import(String path, ArrayMemory locals, TraceInfo trace, String funcName, boolean once, Callback<Void, Void> callback) throws Throwable {
        ModuleManager moduleManager = this.moduleManager;
        synchronized (moduleManager) {
            Memory memory;
            if (once && this.moduleManager.hasModule(path)) {
                return Memory.TRUE;
            }
            ModuleEntity module = this.moduleManager.fetchCachedModule(path);
            if (module == null) {
                callback.call(null);
                return Memory.FALSE;
            }
            this.pushCall(trace, null, new Memory[]{StringMemory.valueOf(path)}, funcName, null, null);
            try {
                memory = module.include(this, locals);
                this.popCall();
            }
            catch (Throwable throwable) {
                this.popCall();
                throw throwable;
            }
            return memory;
        }
    }

    public Memory __include(String path) throws Throwable {
        return this.__include(path, this.globals, null);
    }

    public Memory __includeOnce(String path, ArrayMemory locals, final TraceInfo trace) throws Throwable {
        return this.__import(path, locals, trace, "include_once", true, new Callback<Void, Void>(){

            @Override
            public Void call(Void param) {
                Environment.this.warning(trace, Messages.ERR_INCLUDE_FAILED, "include_once");
                return null;
            }
        });
    }

    public Memory __include(String fileName, ArrayMemory locals, final TraceInfo trace) throws Throwable {
        return this.__import(fileName, locals, trace, "include", false, new Callback<Void, Void>(){

            @Override
            public Void call(Void param) {
                Environment.this.warning(trace, Messages.ERR_INCLUDE_FAILED, "include");
                return null;
            }
        });
    }

    public Memory __require(final String fileName, ArrayMemory locals, final TraceInfo trace) throws Throwable {
        return this.__import(fileName, locals, trace, "require", false, new Callback<Void, Void>(){

            @Override
            public Void call(Void param) {
                Environment.this.error(trace, Messages.ERR_REQUIRE_FAILED.fetch("require", fileName), new Object[0]);
                return null;
            }
        });
    }

    public Memory __requireOnce(final String fileName, ArrayMemory locals, final TraceInfo trace) throws Throwable {
        return this.__import(fileName, locals, trace, "require_once", true, new Callback<Void, Void>(){

            @Override
            public Void call(Void param) {
                Environment.this.error(trace, Messages.ERR_REQUIRE_FAILED.fetch("require_once", fileName), new Object[0]);
                return null;
            }
        });
    }

    public void registerObjectInGC(IObject object) {
        ClassEntity entity = object.getReflection();
        if (entity != null && entity.methodDestruct != null) {
            try {
                this.cleanGcObjects();
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
            WeakReference<IObject> wr = new WeakReference<IObject>(object, this.gcObjectRefQueue);
            this.gcObjects.add(wr);
        }
    }

    public Memory __newObject(String originName, String lowerName, TraceInfo trace, Memory[] args) throws Throwable {
        ClassEntity entity = this.fetchClass(originName, lowerName, true);
        if (entity == null) {
            this.error(trace, ErrorType.E_ERROR, Messages.ERR_CLASS_NOT_FOUND.fetch(originName), new Object[0]);
            return Memory.NULL;
        }
        Object object = entity.newObject(this, trace, true, args);
        this.registerObjectInGC((IObject)object);
        return new ObjectMemory((IObject)object);
    }

    public ForeachIterator __getIterator(TraceInfo trace, Memory memory, boolean getReferences, boolean getKeyReferences) {
        ForeachIterator iterator = memory.getNewIterator(this, getReferences, getKeyReferences);
        if (iterator == null) {
            this.warning(trace, "Invalid argument supplied for foreach()", new Object[0]);
            return invalidIterator;
        }
        iterator.setTrace(trace);
        return iterator;
    }

    public ClassEntity __getGenerator(String moduleIndex, int index) {
        ModuleEntity moduleEntity = this.scope.moduleIndexMap.get(moduleIndex);
        if (moduleEntity == null) {
            throw new CriticalException("Cannot find the module (" + moduleIndex + ") for getting a generator object");
        }
        return moduleEntity.findGenerator(index);
    }

    public ClassEntity __getClosure(String moduleIndex, int index) {
        ModuleEntity moduleEntity = this.scope.moduleIndexMap.get(moduleIndex);
        if (moduleEntity == null) {
            throw new CriticalException("Cannot find the module (" + moduleIndex + ") for getting a closure object");
        }
        return moduleEntity.findClosure(index);
    }

    public Memory __getSingletonClosure(String moduleIndex, int index) {
        ObjectMemory result = this.scope.moduleIndexMap.get(moduleIndex).findClosure(index).getSingleton();
        assert (result != null);
        return result;
    }

    public Memory __throwException(InvocationTargetException e) {
        Throwable throwable = e.getTargetException();
        if (throwable instanceof FinallyException) {
            return Memory.NULL;
        }
        if (throwable instanceof JPHPException) {
            throw (RuntimeException)throwable;
        }
        JavaReflection.exception(this, throwable);
        return Memory.NULL;
    }

    public void __throwException(BaseBaseException e) {
        this.__throwException(e, true);
    }

    public void __throwException(BaseBaseException e, boolean clearSilent) {
        if (clearSilent) {
            this.__clearSilent();
        }
        e.setTraceInfo(this, this.trace());
        throw e;
    }

    public void __throwException(TraceInfo trace, Memory exception) {
        if (exception.isObject()) {
            IObject object = exception.toValue(ObjectMemory.class).value;
            if (object instanceof BaseBaseException) {
                this.__clearSilent();
                BaseBaseException e = (BaseBaseException)object;
                e.setTraceInfo(this, trace);
                throw e;
            }
            this.triggerError(new FatalException("Exceptions must be valid objects derived from the Exception base class", trace));
        } else {
            this.triggerError(new FatalException("Can only throw objects", trace));
        }
    }

    public void __throwFailedCatch(BaseBaseException e) {
        if (e instanceof FinallyException) {
            return;
        }
        throw e;
    }

    public Memory __throwCatch(BaseBaseException e, String className, String lowerClassName) {
        ClassEntity origin = e.getReflection();
        ClassEntity cause = this.fetchClass(className, lowerClassName, false);
        if (cause != null && origin.isInstanceOf(cause)) {
            return new ObjectMemory(e);
        }
        if (origin.isInstanceOfLower(lowerClassName)) {
            return new ObjectMemory(e);
        }
        return Memory.NULL;
    }

    public void __pushSilent() {
        this.silentFlags.push(this.errorFlags);
        this.setErrorFlags(0);
    }

    public void __popSilent() {
        Integer flags = this.silentFlags.pop();
        this.setErrorFlags(flags);
    }

    public void __clearSilent() {
        Stack<Integer> silents = this.silentFlags;
        Integer flags = null;
        while (!silents.empty()) {
            flags = silents.pop();
        }
        if (flags != null) {
            this.setErrorFlags(flags);
        }
    }

    public Memory __getMacroClass() {
        CallStackItem item = this.peekCall(0);
        if (item != null && item.clazz != null) {
            if (item.classEntity == null) {
                item.classEntity = this.fetchClass(item.clazz, false);
            }
            if (item.classEntity == null) {
                return Memory.CONST_EMPTY_STRING;
            }
            MethodEntity method = item.classEntity.findMethod(item.function);
            if (method == null) {
                return Memory.CONST_EMPTY_STRING;
            }
            return new StringMemory(method.getClazz().getName());
        }
        return Memory.CONST_EMPTY_STRING;
    }

    public void __defineFunction(TraceInfo trace, String moduleInternalName, int index) {
        ModuleEntity module = this.scope.moduleIndexMap.get(moduleInternalName);
        if (module == null) {
            throw new CriticalException("Cannot find module: " + moduleInternalName);
        }
        FunctionEntity function = module.findFunction(index);
        if (this.functionMap.put(function.getLowerName(), function) != null) {
            this.triggerError(new FatalException(Messages.ERR_CANNOT_REDECLARE_FUNCTION.fetch(function.getName()), trace));
        }
    }

    public String __shellExecute(String s) {
        if (this.shellExecHandler != null) {
            return this.shellExecHandler.onExecute(s);
        }
        return "";
    }

    public void die(Memory value) {
        if (value != null) {
            if (!value.isNumber()) {
                this.echo(value.toString());
            }
            throw new DieException(value);
        }
        throw new DieException(Memory.NULL);
    }

    public Memory invokeMethod(TraceInfo trace, IObject object, String name, Memory ... args) throws Throwable {
        return ObjectInvokeHelper.invokeMethod((Memory)new ObjectMemory(object), name, name.toLowerCase(), this, trace, args);
    }

    public Memory invokeMethod(IObject object, String name, Memory ... args) throws Throwable {
        return ObjectInvokeHelper.invokeMethod((Memory)new ObjectMemory(object), name, name.toLowerCase(), this, this.trace(), args);
    }

    public Memory invokeMethodNoThrow(IObject object, String name, Memory ... args) {
        try {
            return this.invokeMethod(object, name, args);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            this.catchUncaught(e);
            return Memory.NULL;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Memory invokeMethod(TraceInfo trace, Memory object, String name, Memory ... args) throws Throwable {
        return ObjectInvokeHelper.invokeMethod(object, name, name.toLowerCase(), this, trace, args);
    }

    public Memory invokeMethod(Memory object, String name, Memory ... args) throws Throwable {
        return ObjectInvokeHelper.invokeMethod(object, name, name.toLowerCase(), this, this.trace(), args);
    }

    public String getLateStatic() {
        CallStackItem item = this.peekCall(0);
        if (item == null || item.clazz == null) {
            return "";
        }
        return item.staticClazz != null ? item.staticClazz : item.clazz;
    }

    public IObject getLateObject() {
        CallStackItem item = this.peekCall(0);
        if (item == null) {
            return null;
        }
        return item.object;
    }

    public ClassEntity getLateStaticClass() {
        CallStackItem item = this.peekCall(0);
        if (item == null || item.clazz == null) {
            return null;
        }
        if (item.staticClassEntity != null) {
            return item.staticClassEntity;
        }
        if (item.object instanceof Closure) {
            Memory self = ((Closure)item.object).getSelf();
            if (self.isObject()) {
                return self.toValue(ObjectMemory.class).getReflection();
            }
            return null;
        }
        item.staticClassEntity = this.fetchClass(item.staticClazz != null ? item.staticClazz : item.clazz, false);
        return item.staticClassEntity;
    }

    public String getContext() {
        CallStackItem item = this.peekCall(1);
        return item == null ? "" : (item.clazz == null ? "" : item.clazz);
    }

    public ClassEntity __getContextClass(int offset) {
        CallStackItem item = this.peekCall(offset);
        if (item == null || item.clazz == null) {
            return null;
        }
        if (item.classEntity != null) {
            return item.classEntity;
        }
        item.classEntity = this.fetchClass(item.clazz, false);
        ClassEntity e = item.classEntity;
        if (e == null) {
            throw new IllegalStateException("Cannot find '" + item.clazz + "' in the current environment");
        }
        return e;
    }

    public ClassEntity getContextClass() {
        return this.__getContextClass(1);
    }

    public ClassEntity getLastClassOnStack() {
        return this.getLastClassOnStack(false);
    }

    public ClassEntity getLastClassOnStack(boolean includeClosures) {
        int N = this.getCallStackTop();
        for (int i = 0; i < N; ++i) {
            CallStackItem item = this.peekCall(i);
            if (item == null || item.clazz == null) continue;
            if (item.classEntity != null) {
                if (item.object instanceof Closure) {
                    Memory self = ((Closure)item.object).getSelf();
                    if (self.isObject()) {
                        return self.toValue(ObjectMemory.class).getReflection();
                    }
                    return null;
                }
                return item.classEntity;
            }
            item.classEntity = this.fetchClass(item.clazz, false);
            ClassEntity e = item.classEntity;
            if (e == null) {
                throw new IllegalStateException("Cannot find '" + item.clazz + "' in the current environment");
            }
            return e;
        }
        return null;
    }

    public ClassEntity __getParentClass(TraceInfo trace) {
        ClassEntity context = this.getLastClassOnStack(false);
        if (context == null) {
            this.error(trace, "Cannot access parent:: when no class scope is active", new Object[0]);
            return null;
        }
        ClassEntity parent = context.getParent();
        if (parent == null) {
            this.error(trace, "Cannot access parent:: when current class scope has no parent", new Object[0]);
            return null;
        }
        return parent;
    }

    public String __getParent(TraceInfo trace) {
        return this.__getParentClass(trace).getName();
    }

    public String __getParent(TraceInfo trace, String className) {
        ClassEntity o = this.fetchClass(className, true);
        if (o == null) {
            this.error(trace, ErrorType.E_ERROR, Messages.ERR_CLASS_NOT_FOUND, className);
            return null;
        }
        if (o.getParent() == null) {
            this.error(trace, "Cannot access parent:: when current class scope has no parent", new Object[0]);
            return null;
        }
        return o.getParent().getName();
    }

    public void registerAutoloader(SplClassLoader classLoader, boolean prepend) {
        for (SplClassLoader loader : this.classLoaders) {
            if (!loader.equals(classLoader)) continue;
            return;
        }
        if (prepend) {
            this.classLoaders.add(0, classLoader);
        } else {
            this.classLoaders.add(classLoader);
        }
    }

    public List<SplClassLoader> getClassLoaders() {
        return this.classLoaders;
    }

    public boolean unRegisterAutoloader(SplClassLoader classLoader) {
        boolean result = false;
        Iterator<SplClassLoader> iterator = this.classLoaders.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(classLoader)) continue;
            result = true;
            iterator.remove();
        }
        return result;
    }

    public void setErrorHandler(ErrorHandler handler) {
        this.previousErrorHandler = this.errorHandler;
        this.errorHandler = handler;
    }

    public TraceInfo getTraceAppliedSourceMap(TraceInfo trace) {
        int sourceLine;
        if (trace == null) {
            return null;
        }
        if (trace.getFile() == null) {
            return trace;
        }
        if (trace instanceof SourceMappedTraceInfo) {
            return trace;
        }
        SourceMap sourceMap = this.sourceMaps.get(trace.getFileName());
        if (sourceMap != null && (sourceLine = sourceMap.getSourceLine(trace.getStartLine() + 1)) != trace.getStartLine() && sourceLine != -1) {
            trace = new SourceMappedTraceInfo(trace.getContext(), sourceLine - 1, trace.getEndLine(), trace.getStartPosition(), trace.getEndPosition());
        }
        return trace;
    }

    public void applySourceMap(CallStackItem[] callStack) {
        if (this.sourceMaps.isEmpty()) {
            return;
        }
        for (CallStackItem stackItem : callStack) {
            stackItem.trace = this.getTraceAppliedSourceMap(stackItem.trace);
        }
    }

    public CallStack getCallStack() {
        return this.callStack;
    }

    public void __replaceCallStack(CallStack stack) {
        this.callStack = stack;
    }

    public void registerShutdownFunction(ShutdownHandler handler) {
        this.shutdownFunctions.add(handler);
    }

    static {
        environment = new ThreadLocal();
        ids = new AtomicInteger();
        freeIds = new Stack();
        invalidIterator = new ForeachIterator(false, false, false){

            @Override
            protected boolean init() {
                return false;
            }

            @Override
            protected boolean nextValue() {
                return false;
            }

            @Override
            protected boolean prevValue() {
                return false;
            }

            @Override
            public void reset() {
            }
        };
        configurationHandler = new HashMap<String, ConfigChangeHandler>();
        configurationHandler.put("include_path", new ConfigChangeHandler(){

            @Override
            public void onChange(Environment env, Memory value) {
                if (value == null) {
                    env.setIncludePaths(Collections.emptySet());
                } else {
                    String[] files = StringUtils.split(value.toString(), Constants.PATH_SEPARATOR, 255);
                    HashSet<String> paths = new HashSet<String>();
                    Collections.addAll(paths, files);
                    env.setIncludePaths(paths);
                }
            }
        });
    }
}

