/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.zend.ext.standard;

import php.runtime.Memory;
import php.runtime.annotation.Runtime;
import php.runtime.ext.support.compile.FunctionsContainer;

public class CTypeFunctions
extends FunctionsContainer {
    private static final char CHAR_UNDEFINED = '\uffff';

    private static int tryGetChar(Memory value) {
        int val;
        if (value.type == Memory.Type.INT && (val = (int)value.toLong()) > -128 && val <= 0x10FFFF) {
            if (val < 0) {
                val += 256;
            }
            return val;
        }
        return -1;
    }

    private static boolean isPrintableChar(char c) {
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return !Character.isISOControl(c) && c != '\uffff' && block != null && block != Character.UnicodeBlock.SPECIALS;
    }

    public static boolean ctype_apply(Memory value, Checker checker) {
        int c = CTypeFunctions.tryGetChar(value);
        if (c > -1) {
            return checker.check((char)c);
        }
        String str = value.toString();
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (checker.check(ch)) continue;
            return false;
        }
        return true;
    }

    @Runtime.Immutable
    public static boolean ctype_alnum(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isLetter(ch) || Character.isDigit(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_alpha(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isLetter(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_cntrl(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isISOControl(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_digit(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isDigit(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_graph(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isSpaceChar(ch) || CTypeFunctions.isPrintableChar(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_lower(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isLowerCase(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_print(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return CTypeFunctions.isPrintableChar(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_punct(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return !Character.isDigit(ch) && !Character.isLetter(ch) && !Character.isSpaceChar(ch) && CTypeFunctions.isPrintableChar(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_space(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isSpaceChar(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_upper(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isUpperCase(ch);
            }
        });
    }

    @Runtime.Immutable
    public static boolean ctype_xdigit(Memory value) {
        return CTypeFunctions.ctype_apply(value, new Checker(){

            @Override
            boolean check(char ch) {
                return Character.isDigit(ch) || ch >= 'a' && ch <= 'f' || ch >= 'A' && ch <= 'F';
            }
        });
    }

    private static abstract class Checker {
        private Checker() {
        }

        abstract boolean check(char var1);
    }
}

