/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.ext.javafx.classes.layout;

import javafx.geometry.Insets;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.develnext.jphp.ext.javafx.classes.UXParent;
import php.runtime.annotation.Reflection;
import php.runtime.env.Environment;
import php.runtime.reflection.ClassEntity;

@Reflection.Name(value="php\\gui\\layout\\UXRegion")
public class UXRegion<T extends Region>
extends UXParent<Region> {
    public UXRegion(Environment env, T wrappedObject) {
        super(env, wrappedObject);
    }

    public UXRegion(Environment env, ClassEntity clazz) {
        super(env, clazz);
    }

    @Override
    public T getWrappedObject() {
        return (T)((Region)super.getWrappedObject());
    }

    @Reflection.Signature
    public void __construct() {
        this.__wrappedObject = new Region();
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    public double[] getMinSize() {
        return new double[]{this.getWrappedObject().getMinWidth(), this.getWrappedObject().getMinHeight()};
    }

    @Reflection.Setter
    public void setMinSize(double[] args) {
        if (args.length >= 2) {
            this.getWrappedObject().setMinSize(args[0], args[1]);
        }
    }

    @Reflection.Getter
    public double getPaddingLeft() {
        return this.getWrappedObject().getPadding().getLeft();
    }

    @Reflection.Setter
    public void setPaddingLeft(double value) {
        this.getWrappedObject().setPadding(new Insets(this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom(), value));
    }

    @Reflection.Getter
    public double getPaddingRight() {
        return this.getWrappedObject().getPadding().getRight();
    }

    @Reflection.Setter
    public void setPaddingRight(double value) {
        this.getWrappedObject().setPadding(new Insets(this.getPaddingTop(), value, this.getPaddingBottom(), this.getPaddingLeft()));
    }

    @Reflection.Getter
    public double getPaddingTop() {
        return this.getWrappedObject().getPadding().getTop();
    }

    @Reflection.Setter
    public void setPaddingTop(double value) {
        this.getWrappedObject().setPadding(new Insets(value, this.getPaddingRight(), this.getPaddingBottom(), this.getPaddingLeft()));
    }

    @Reflection.Getter
    public double getPaddingBottom() {
        return this.getWrappedObject().getPadding().getBottom();
    }

    @Reflection.Setter
    public void setPaddingBottom(double value) {
        this.getWrappedObject().setPadding(new Insets(this.getPaddingTop(), this.getPaddingRight(), value, this.getPaddingLeft()));
    }

    @Override
    @Reflection.Signature
    public void setSize(double[] args) {
        if (args.length >= 2) {
            this.getWrappedObject().setPrefWidth(args[0]);
            this.getWrappedObject().setPrefHeight(args[1]);
        }
    }

    @Reflection.Getter(hiddenInDebugInfo=true)
    public double[] getMaxSize() {
        return new double[]{this.getWrappedObject().getMaxWidth(), this.getWrappedObject().getMaxHeight()};
    }

    @Reflection.Setter
    public void setMaxSize(double[] args) {
        if (args.length >= 2) {
            this.getWrappedObject().setMaxSize(args[0], args[1]);
        }
    }

    @Reflection.Setter
    public void setBackgroundColor(@Reflection.Nullable Color color) {
        if (color == null) {
            this.getWrappedObject().setBackground(null);
        } else {
            this.getWrappedObject().setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)color, CornerRadii.EMPTY, Insets.EMPTY)}));
        }
    }

    @Reflection.Getter
    public Color getBackgroundColor() {
        Paint fill;
        Background background = this.getWrappedObject().getBackground();
        if (background != null && background.getFills().size() > 0 && (fill = ((BackgroundFill)background.getFills().get(0)).getFill()) instanceof Color) {
            return (Color)fill;
        }
        return null;
    }

    static interface WrappedInterface {
        @Reflection.Property
        public double maxWidth();

        @Reflection.Property
        public double maxHeight();

        @Reflection.Property
        public double minWidth();

        @Reflection.Property
        public double minHeight();

        @Reflection.Property(hiddenInDebugInfo=true)
        public Insets padding();
    }
}

