/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.tokenizer.token.expr.value;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;
import org.develnext.jphp.core.tokenizer.token.stmt.NamespaceUseStmtToken;
import php.runtime.common.StringUtils;

public class FulledNameToken
extends NameToken {
    private List<NameToken> names;
    private boolean absolutely;
    private boolean processed;
    private Set<NamespaceUseStmtToken.UseType> useProcessed = new HashSet<NamespaceUseStmtToken.UseType>();

    public FulledNameToken(FulledNameToken token) {
        this(token.meta, '\\');
        this.names = token.names;
        this.absolutely = token.absolutely;
    }

    public FulledNameToken(TokenMeta meta) {
        this(meta, '\\');
    }

    public FulledNameToken(TokenMeta meta, char sep) {
        super(meta);
        this.names = new ArrayList<NameToken>();
        String word = meta.getWord();
        this.absolutely = word.startsWith(String.valueOf(sep));
        if (this.absolutely) {
            word = word.substring(1);
        }
        for (String name : StringUtils.split(word, sep)) {
            this.names.add(new NameToken(TokenMeta.of(name, (Token)this)));
        }
    }

    public FulledNameToken(TokenMeta meta, List<? extends Token> names) {
        super(meta);
        this.names = new ArrayList<NameToken>();
        for (Token token : names) {
            if (!(token instanceof NameToken)) continue;
            this.names.add((NameToken)token);
        }
    }

    public List<NameToken> getNames() {
        return this.names;
    }

    public NameToken getLastName() {
        return this.names.get(this.names.size() - 1);
    }

    public boolean isAbsolutely() {
        return this.absolutely;
    }

    public String toName(char delimiter) {
        StringBuilder builder = new StringBuilder();
        ListIterator<NameToken> iterator = this.names.listIterator();
        while (iterator.hasNext()) {
            NameToken tk = iterator.next();
            builder.append(tk.getName());
            if (!iterator.hasNext()) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public String toName() {
        return this.toName('\\');
    }

    @Override
    public String getName() {
        return this.toName();
    }

    public boolean isSingle() {
        return this.names.size() == 1;
    }

    public boolean isAnyProcessed() {
        return this.isProcessed(NamespaceUseStmtToken.UseType.CLASS) || this.isProcessed(NamespaceUseStmtToken.UseType.FUNCTION) || this.isProcessed(NamespaceUseStmtToken.UseType.CONSTANT);
    }

    public boolean isProcessed(NamespaceUseStmtToken.UseType useType) {
        return this.isAbsolutely() || this.useProcessed.contains((Object)useType);
    }

    public void setProcessed(NamespaceUseStmtToken.UseType useType) {
        this.useProcessed.add(useType);
    }

    public static FulledNameToken valueOf(String ... names) {
        ArrayList<NameToken> tmp = new ArrayList<NameToken>();
        for (String value : names) {
            tmp.add(NameToken.valueOf(value));
        }
        return new FulledNameToken(TokenMeta.empty(), tmp);
    }
}

