/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.syntax.generators;

import java.util.Arrays;
import java.util.ListIterator;
import org.develnext.jphp.core.syntax.SyntaxAnalyzer;
import org.develnext.jphp.core.syntax.generators.Generator;
import org.develnext.jphp.core.tokenizer.TokenMeta;
import org.develnext.jphp.core.tokenizer.token.Token;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NameToken;

public class NameGenerator
extends Generator<FulledNameToken> {
    public NameGenerator(SyntaxAnalyzer analyzer) {
        super(analyzer);
    }

    protected void checkFullName(FulledNameToken name) {
        for (NameToken one : name.getNames()) {
            if (!one.getName().isEmpty()) continue;
            this.unexpectedToken(one);
        }
    }

    @Override
    public FulledNameToken getToken(Token current, ListIterator<Token> iterator) {
        if (current instanceof NameToken) {
            if (current instanceof FulledNameToken) {
                this.checkFullName((FulledNameToken)current);
                return (FulledNameToken)current;
            }
            return new FulledNameToken(TokenMeta.of(current), Arrays.asList((NameToken)current));
        }
        return null;
    }

    @Override
    public boolean isAutomatic() {
        return false;
    }
}

