/*
 * Decompiled with CFR 0.152.
 */
package org.develnext.jphp.core.compiler.jvm.statement.expr.value;

import org.develnext.jphp.core.compiler.jvm.statement.ExpressionStmtCompiler;
import org.develnext.jphp.core.compiler.jvm.statement.expr.BaseExprCompiler;
import org.develnext.jphp.core.tokenizer.token.expr.value.FulledNameToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.NewExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.SelfExprToken;
import org.develnext.jphp.core.tokenizer.token.expr.value.StaticExprToken;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.reflection.MethodEntity;

public class NewValueCompiler
extends BaseExprCompiler<NewExprToken> {
    public NewValueCompiler(ExpressionStmtCompiler exprCompiler) {
        super(exprCompiler);
    }

    @Override
    public void write(NewExprToken token, boolean returnValue) {
        ((MethodEntity)this.method.getEntity()).setImmutable(false);
        this.expr.writeLineNumber(token);
        this.expr.writePushEnv();
        if (token.isDynamic()) {
            Memory className = this.expr.writeExpression(token.getExprName(), true, true, false);
            if (className != null) {
                this.expr.writePushConstString(className.toString());
                this.expr.writePushConstString(className.toString().toLowerCase());
            } else {
                this.expr.writeExpression(token.getExprName(), true, false);
                this.expr.writePopString();
                this.expr.writePushDupLowerCase();
            }
        } else if (token.getName() instanceof StaticExprToken) {
            this.expr.writePushStatic();
            this.expr.writePushDupLowerCase();
        } else if (token.getName() instanceof SelfExprToken) {
            this.expr.writePushEnv();
            this.expr.writeSysDynamicCall(Environment.class, "__getMacroClass", Memory.class, new Class[0]);
            this.expr.writePopString();
            this.expr.writePushDupLowerCase();
        } else {
            FulledNameToken name = (FulledNameToken)token.getName();
            this.expr.writePushString(name.getName());
            this.expr.writePushString(name.getName().toLowerCase());
        }
        this.expr.writePushTraceInfo(token);
        this.expr.writePushParameters(token.getParameters(), new Memory[0]);
        this.expr.writeSysDynamicCall(Environment.class, "__newObject", Memory.class, String.class, String.class, TraceInfo.class, Memory[].class);
        this.expr.setStackPeekAsImmutable();
        if (!returnValue) {
            this.expr.writePopAll(1);
        }
    }
}

