/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.util.generator;

import php.runtime.util.generator.CollectionAbortedException;
import php.runtime.util.generator.Collector;
import php.runtime.util.generator.ResultHandler;
import php.runtime.util.generator.ThreadedYieldAdapter;
import php.runtime.util.generator.YieldAdapterIterator;

public abstract class Generator<T>
implements Iterable<T> {
    private ResultHandler<T> resultHandler;

    public final T yield(T t) {
        try {
            return this.resultHandler.handleResult(t);
        }
        catch (CollectionAbortedException ex) {
            return null;
        }
    }

    public final T yield() {
        return this.yield(null);
    }

    protected abstract void run(YieldAdapterIterator<T> var1);

    @Override
    public final YieldAdapterIterator<T> iterator() {
        ThreadedYieldAdapter yieldAdapter = new ThreadedYieldAdapter();
        Collector collector = new Collector<T>(){
            protected YieldAdapterIterator iterator;

            @Override
            public void collect(ResultHandler<T> handler) throws CollectionAbortedException {
                Generator.this.resultHandler = handler;
                Generator.this.run(this.iterator);
            }

            @Override
            public void setIterator(YieldAdapterIterator iterator) {
                this.iterator = iterator;
            }
        };
        YieldAdapterIterator iterator = yieldAdapter.adapt(collector).iterator();
        collector.setIterator(iterator);
        return iterator;
    }
}

