/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;

public final class SScanF {
    private SScanF() {
    }

    private static void addConstant(List<Segment> segmentList, StringBuilder sb) {
        if (sb.length() == 0) {
            return;
        }
        segmentList.add(new ConstantSegment(sb.toString()));
        sb.setLength(0);
    }

    public static Segment[] parse(Environment env, TraceInfo trace, String format) {
        int fmtLen = format.length();
        int fIndex = 0;
        ArrayList<Segment> segmentList = new ArrayList<Segment>();
        StringBuilder sb = new StringBuilder();
        block13: while (fIndex < fmtLen) {
            char ch;
            if (SScanF.isWhitespace(ch = format.charAt(fIndex++))) {
                StringBuilder whiteSpaceValue = new StringBuilder();
                whiteSpaceValue.append(ch);
                while (fIndex < fmtLen && SScanF.isWhitespace(ch = format.charAt(fIndex))) {
                    whiteSpaceValue.append(ch);
                    ++fIndex;
                }
                SScanF.addConstant(segmentList, sb);
                segmentList.add(new WhitespaceSegment(whiteSpaceValue.toString()));
                continue;
            }
            if (ch == '%') {
                int maxLen = -1;
                block15: while (fIndex < fmtLen) {
                    ch = format.charAt(fIndex++);
                    block0 : switch (ch) {
                        case '%': {
                            sb.append('%');
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            if (maxLen < 0) {
                                maxLen = 0;
                            }
                            maxLen = 10 * maxLen + ch - 48;
                            continue block15;
                        }
                        case 's': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new StringSegment(maxLen, ch));
                            break;
                        }
                        case 'c': {
                            if (maxLen < 0) {
                                maxLen = 1;
                            }
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new StringSegment(maxLen, ch));
                            break;
                        }
                        case 'n': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(StringLengthSegment.SEGMENT);
                            break;
                        }
                        case 'd': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new IntegerSegment(maxLen, 10, false));
                            break;
                        }
                        case 'u': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new IntegerSegment(maxLen, 10, true));
                            break;
                        }
                        case 'o': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new IntegerSegment(maxLen, 8, false));
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new HexSegment(maxLen));
                            break;
                        }
                        case 'e': 
                        case 'f': {
                            SScanF.addConstant(segmentList, sb);
                            segmentList.add(new ScientificSegment(maxLen, ch));
                            break;
                        }
                        case '[': {
                            SScanF.addConstant(segmentList, sb);
                            if (fmtLen <= fIndex) {
                                if (env == null) continue block13;
                                env.warning(trace, "expected ']', saw end of string", new Object[0]);
                                break;
                            }
                            boolean isNegated = false;
                            if (fIndex < fmtLen && format.charAt(fIndex) == '^') {
                                isNegated = true;
                                ++fIndex;
                            }
                            HashSet<Integer> set = new HashSet<Integer>();
                            while (true) {
                                char ch2;
                                if (fIndex == fmtLen) {
                                    if (env == null) continue block13;
                                    env.warning(trace, "expected ']', saw end of string", new Object[0]);
                                    break block0;
                                }
                                if ((ch2 = format.charAt(fIndex++)) == ']') break;
                                set.add(Integer.valueOf(ch2));
                            }
                            if (isNegated) {
                                segmentList.add(new SetNegatedSegment(set));
                                break;
                            }
                            segmentList.add(new SetSegment(set));
                            break;
                        }
                        default: {
                            env.warning(trace, "'%s' is a bad sscanf string", format);
                            break;
                        }
                    }
                    continue block13;
                }
                continue;
            }
            sb.append(ch);
        }
        SScanF.addConstant(segmentList, sb);
        Segment[] segmentArray = new Segment[segmentList.size()];
        return segmentList.toArray(segmentArray);
    }

    protected static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    static class StringSegment
    extends Segment {
        private final int _maxLen;
        private final char _ch;

        StringSegment(int maxLen, char ch) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
            this._ch = ch;
        }

        @Override
        public String getFormatString() {
            return "%" + String.valueOf(this._ch);
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            char ch;
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.refOfPush().assign(Memory.NULL);
                }
                return sIndex;
            }
            StringBuilder sb = new StringBuilder();
            int maxLen = this._maxLen;
            while (sIndex < strlen && maxLen-- > 0 && !SScanF.isWhitespace(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            this.sscanfPut(var, new StringMemory(sb.toString()), isReturnArray);
            return sIndex;
        }
    }

    static class IntegerSegment
    extends Segment {
        private final int _maxLen;
        private final int _base;
        private final boolean _isUnsigned;

        IntegerSegment(int maxLen, int base, boolean isUnsigned) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
            this._base = base;
            this._isUnsigned = isUnsigned;
        }

        @Override
        public String getFormatString() {
            switch (this._base) {
                case 10: {
                    return this._isUnsigned ? "%u" : "%d";
                }
                case 8: {
                    return "%o";
                }
            }
            return "%d";
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.refOfPush().assign(Memory.NULL);
                }
                return sIndex;
            }
            int val = 0;
            int sign = 1;
            boolean isNotMatched = true;
            int maxLen = this._maxLen;
            if (sIndex < strlen) {
                char ch = string.charAt(sIndex);
                if (ch == '+') {
                    ++sIndex;
                    --maxLen;
                } else if (ch == '-') {
                    sign = -1;
                    ++sIndex;
                    --maxLen;
                }
            }
            int base = this._base;
            int topRange = base + 48;
            while (sIndex < strlen && maxLen-- > 0) {
                char ch = string.charAt(sIndex);
                if ('0' > ch || ch >= topRange) {
                    if (!isNotMatched) break;
                    this.sscanfPut(var, Memory.NULL, isReturnArray);
                    return sIndex;
                }
                val = val * base + ch - 48;
                isNotMatched = false;
                ++sIndex;
            }
            if (this._isUnsigned) {
                if (sign == -1 && val != 0) {
                    this.sscanfPut(var, new StringMemory((char)(0xFFFFFFFFL - (long)val + 1L)), isReturnArray);
                } else {
                    this.sscanfPut(var, LongMemory.valueOf(val), isReturnArray);
                }
            } else {
                this.sscanfPut(var, LongMemory.valueOf(val * sign), isReturnArray);
            }
            return sIndex;
        }
    }

    static class HexSegment
    extends Segment {
        private final int _maxLen;

        HexSegment(int maxLen) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
        }

        @Override
        public String getFormatString() {
            return "%x";
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            char ch;
            if (sIndex == strlen) {
                if (isReturnArray) {
                    var.refOfPush().assign(Memory.NULL);
                }
                return sIndex;
            }
            int val = 0;
            int sign = 1;
            boolean isMatched = false;
            int maxLen = this._maxLen;
            if (sIndex < strlen) {
                ch = string.charAt(sIndex);
                if (ch == '+') {
                    ++sIndex;
                    --maxLen;
                } else if (ch == '-') {
                    sign = -1;
                    ++sIndex;
                    --maxLen;
                }
            }
            while (sIndex < strlen && maxLen-- > 0) {
                ch = string.charAt(sIndex);
                if ('0' <= ch && ch <= '9') {
                    val = val * 16 + ch - 48;
                    isMatched = true;
                } else if ('a' <= ch && ch <= 'f') {
                    val = val * 16 + ch - 97 + 10;
                    isMatched = true;
                } else if ('A' <= ch && ch <= 'F') {
                    val = val * 16 + ch - 65 + 10;
                    isMatched = true;
                } else {
                    if (isMatched) break;
                    this.sscanfPut(var, Memory.NULL, isReturnArray);
                    return sIndex;
                }
                ++sIndex;
            }
            this.sscanfPut(var, LongMemory.valueOf(val * sign), isReturnArray);
            return sIndex;
        }
    }

    static class ScientificSegment
    extends Segment {
        private final int _maxLen;
        private final char _ch;

        ScientificSegment(int maxLen, char ch) {
            if (maxLen < 0) {
                maxLen = Integer.MAX_VALUE;
            }
            this._maxLen = maxLen;
            this._ch = ch;
        }

        @Override
        public String getFormatString() {
            return "%" + String.valueOf(this._ch);
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String s, int strlen, int i, ReferenceMemory var, boolean isReturnArray) {
            int start;
            block13: {
                int e;
                int maxLen;
                int ch;
                int len;
                block16: {
                    block15: {
                        block14: {
                            if (i == strlen) {
                                if (isReturnArray) {
                                    var.refOfPush().assign(Memory.NULL);
                                }
                                return i;
                            }
                            start = i;
                            len = strlen;
                            ch = 0;
                            maxLen = this._maxLen;
                            if (i < len && maxLen > 0) {
                                char c = s.charAt(i);
                                ch = c;
                                if (c == '+' || ch == 45) {
                                    ++i;
                                    --maxLen;
                                }
                            }
                            while (i < len && maxLen > 0) {
                                char c = s.charAt(i);
                                ch = c;
                                if ('0' > c || ch > 57) break;
                                --maxLen;
                                ++i;
                            }
                            if (ch == 46) {
                                --maxLen;
                                ++i;
                                while (i < len && maxLen > 0) {
                                    char c = s.charAt(i);
                                    ch = c;
                                    if ('0' > c || ch > 57) break;
                                    --maxLen;
                                    ++i;
                                }
                            }
                            if (ch != 101 && ch != 69) break block13;
                            --maxLen;
                            if (start == (e = i++)) {
                                this.sscanfPut(var, Memory.NULL, isReturnArray);
                                return start;
                            }
                            if (i >= len || maxLen <= 0) break block14;
                            char c = s.charAt(i);
                            ch = c;
                            if (c == '+') break block15;
                        }
                        if (ch != 45) break block16;
                    }
                    ++i;
                    --maxLen;
                }
                while (i < len && maxLen > 0) {
                    char c = s.charAt(i);
                    ch = c;
                    if ('0' > c || ch > 57) break;
                    --maxLen;
                    ++i;
                }
                if (i == e + 1) {
                    i = e;
                }
            }
            double val = i == 0 ? 0.0 : Double.parseDouble(s.substring(start, i));
            this.sscanfPut(var, new DoubleMemory(val), isReturnArray);
            return i;
        }
    }

    static class SetNegatedSegment
    extends Segment {
        private Set<Integer> _set;

        private SetNegatedSegment(Set<Integer> set) {
            this._set = set;
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            char ch;
            StringBuilder sb = new StringBuilder();
            while (sIndex < strlen && !this._set.contains(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            if (sb.length() > 0) {
                this.sscanfPut(var, new StringMemory(sb.toString()), isReturnArray);
            } else if (isReturnArray) {
                var.refOfPush().assign(Memory.NULL);
            }
            return sIndex;
        }
    }

    static class SetSegment
    extends Segment {
        private Set<Integer> _set;

        private SetSegment(Set<Integer> set) {
            this._set = set;
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            char ch;
            StringBuilder sb = new StringBuilder();
            while (sIndex < strlen && this._set.contains(ch = string.charAt(sIndex))) {
                sb.append(ch);
                ++sIndex;
            }
            if (sb.length() > 0) {
                this.sscanfPut(var, new StringMemory(sb.toString()), isReturnArray);
            } else if (isReturnArray) {
                var.refOfPush().assign(Memory.NULL);
            }
            return sIndex;
        }
    }

    static class StringLengthSegment
    extends Segment {
        static final StringLengthSegment SEGMENT = new StringLengthSegment();

        private StringLengthSegment() {
        }

        @Override
        public String getFormatString() {
            return "%n";
        }

        @Override
        public boolean isAssigned() {
            return true;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            this.sscanfPut(var, LongMemory.valueOf(sIndex), isReturnArray);
            return sIndex;
        }
    }

    static class WhitespaceSegment
    extends Segment {
        private String originValue = " ";

        private WhitespaceSegment(String originValue) {
            this.originValue = originValue;
        }

        @Override
        public String getFormatString() {
            return this.originValue;
        }

        @Override
        public boolean isAssigned() {
            return false;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            while (sIndex < strlen && SScanF.isWhitespace(string.charAt(sIndex))) {
                ++sIndex;
            }
            return sIndex;
        }
    }

    static class ConstantSegment
    extends Segment {
        private final String _string;
        private final int _strlen;

        private ConstantSegment(String string) {
            this._string = string;
            this._strlen = string.length();
        }

        @Override
        public boolean isAssigned() {
            return false;
        }

        @Override
        public String getFormatString() {
            return this._string;
        }

        @Override
        public int apply(String string, int strlen, int sIndex, ReferenceMemory var, boolean isReturnArray) {
            int fStrlen = this._strlen;
            String fString = this._string;
            if (strlen - sIndex < fStrlen) {
                return -1;
            }
            for (int i = 0; i < fStrlen; ++i) {
                char ch2;
                char ch;
                if ((ch = string.charAt(sIndex++)) == (ch2 = fString.charAt(i))) continue;
                return -1;
            }
            return sIndex;
        }
    }

    public static abstract class Segment {
        public abstract boolean isAssigned();

        public abstract int apply(String var1, int var2, int var3, ReferenceMemory var4, boolean var5);

        void sscanfPut(Memory var, Memory val, boolean isReturnArray) {
            if (isReturnArray) {
                var.refOfPush().assign(val);
            } else {
                var.assign(val);
            }
        }

        public String getFormatString() {
            return "";
        }
    }
}

