/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.reflection;

import java.lang.reflect.Field;
import php.runtime.Memory;
import php.runtime.common.Messages;
import php.runtime.common.Modifier;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.exceptions.support.ErrorType;
import php.runtime.invoke.ObjectInvokeHelper;
import php.runtime.lang.IObject;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.reflection.ClassEntity;
import php.runtime.reflection.DocumentComment;
import php.runtime.reflection.MethodEntity;
import php.runtime.reflection.support.Entity;

public class PropertyEntity
extends Entity {
    protected ClassEntity clazz;
    protected ClassEntity trait;
    protected Modifier modifier = Modifier.PUBLIC;
    private Memory defaultValue;
    protected DocumentComment docComment;
    protected boolean isStatic;
    protected Field field;
    protected String specificName;
    protected PropertyEntity prototype;
    protected boolean isDefault;
    protected MethodEntity getter;
    protected MethodEntity setter;
    protected boolean hiddenInDebugInfo = false;

    public PropertyEntity(Context context) {
        super(context);
    }

    public PropertyEntity getPrototype() {
        return this.prototype;
    }

    public void setPrototype(PropertyEntity prototype) {
        this.prototype = prototype;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean aDefault) {
        this.isDefault = aDefault;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        field.setAccessible(true);
        this.field = field;
    }

    public DocumentComment getDocComment() {
        return this.docComment;
    }

    public void setDocComment(DocumentComment docComment) {
        this.docComment = docComment;
    }

    public boolean isHiddenInDebugInfo() {
        return this.hiddenInDebugInfo;
    }

    public void setHiddenInDebugInfo(boolean hiddenInDebugInfo) {
        this.hiddenInDebugInfo = hiddenInDebugInfo;
    }

    public Memory getDefaultValue() {
        return this.defaultValue;
    }

    public Memory getDefaultValue(Environment env) {
        if (this.defaultValue == null) {
            Memory r = env.getStatic(this.isStatic ? this.specificName : this.internalName);
            return r == null ? Memory.NULL : r;
        }
        return this.defaultValue;
    }

    public void setDefaultValue(Memory defaultValue) {
        this.defaultValue = defaultValue;
    }

    public Modifier getModifier() {
        return this.modifier;
    }

    public boolean isPrivate() {
        return this.modifier == Modifier.PRIVATE;
    }

    public boolean isProtected() {
        return this.modifier == Modifier.PROTECTED;
    }

    public boolean isPublic() {
        return this.modifier == Modifier.PUBLIC;
    }

    public void setModifier(Modifier modifier) {
        this.modifier = modifier;
        this.updateSpecificName();
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean aStatic) {
        this.isStatic = aStatic;
    }

    public ClassEntity getClazz() {
        return this.clazz;
    }

    public void setClazz(ClassEntity clazz) {
        this.clazz = clazz;
        this.updateSpecificName();
    }

    public boolean isDeprecated() {
        return false;
    }

    public void updateSpecificName() {
        switch (this.modifier) {
            case PRIVATE: {
                if (this.clazz == null) break;
                this.specificName = "\u0000" + this.clazz.getName() + "\u0000" + this.name;
                break;
            }
            case PROTECTED: {
                this.specificName = "\u0000*\u0000" + this.name;
                break;
            }
            default: {
                this.specificName = this.name;
            }
        }
        if (this.isStatic && this.clazz != null) {
            this.specificName = "\u0000" + this.clazz.getLowerName() + "#" + this.specificName;
        }
        if (this.clazz != null) {
            this.internalName = "\u0000" + this.clazz.getLowerName() + "\u0000#" + this.name;
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.updateSpecificName();
    }

    public String getSpecificName() {
        return this.specificName;
    }

    public ClassEntity getTrait() {
        return this.trait;
    }

    public void setTrait(ClassEntity trait) {
        this.trait = trait;
    }

    public boolean isOwned(ClassEntity entity) {
        return this.clazz.getId() == entity.getId();
    }

    public int canAccess(Environment env) {
        return this.canAccess(env, null);
    }

    public MethodEntity getGetter() {
        return this.getter;
    }

    public void setGetter(MethodEntity getter) {
        this.getter = getter;
    }

    public MethodEntity getSetter() {
        return this.setter;
    }

    public void setSetter(MethodEntity setter) {
        this.setter = setter;
    }

    public int canAccess(Environment env, ClassEntity context) {
        switch (this.modifier) {
            case PUBLIC: {
                return 0;
            }
            case PRIVATE: {
                ClassEntity cl = context == null ? env.getLastClassOnStack(true) : context;
                return cl != null && cl.getId() == this.clazz.getId() ? 0 : 2;
            }
            case PROTECTED: {
                ClassEntity clazz;
                ClassEntity classEntity = clazz = context == null ? env.getLastClassOnStack(true) : context;
                if (clazz == null) {
                    return 1;
                }
                long id = this.clazz.getId();
                do {
                    if (clazz.getId() != id) continue;
                    return 0;
                } while ((clazz = clazz.parent) != null);
            }
        }
        return 2;
    }

    public boolean canAccessAsNonStatic(Environment env, TraceInfo trace) {
        if (this.isStatic) {
            env.error(trace, ErrorType.E_STRICT, Messages.ERR_ACCESSING_STATIC_PROPERTY_AS_NON_STATIC, this.getClazz().getName(), this.name);
            return false;
        }
        return true;
    }

    public boolean isReadOnly() {
        return this.getter == null && this.setter != null;
    }

    public PropertyEntity duplicate() {
        PropertyEntity propertyEntity = new PropertyEntity(this.context);
        propertyEntity.setStatic(this.isStatic);
        propertyEntity.setDocComment(this.docComment);
        propertyEntity.setName(this.name);
        propertyEntity.setDefault(this.isDefault);
        propertyEntity.setDefaultValue(this.defaultValue);
        propertyEntity.setModifier(this.modifier);
        propertyEntity.setPrototype(propertyEntity);
        propertyEntity.setTrace(this.trace);
        propertyEntity.setGetter(this.getter);
        propertyEntity.setSetter(this.setter);
        return propertyEntity;
    }

    public Memory assignValue(Environment env, TraceInfo trace, Object object, String name, Memory value) {
        return ((IObject)object).getProperties().refOfIndex(name).assign(value);
    }

    public Memory getStaticValue(Environment env, TraceInfo trace) {
        return env.getOrCreateStatic(this.specificName, this.getDefaultValue(env).toImmutable());
    }

    public Memory getValue(Environment env, TraceInfo trace, Object object) throws Throwable {
        if (this.getter != null && object instanceof IObject) {
            return ObjectInvokeHelper.invokeMethod((IObject)object, this.getter, env, trace, null, false);
        }
        ArrayMemory props = ((IObject)object).getProperties();
        ReferenceMemory result = props.getByScalar(this.specificName);
        if (result == null) {
            result = props.getByScalar(this.name);
        }
        return result;
    }
}

