/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.output;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.invoke.Invoker;
import php.runtime.memory.BinaryMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.StringMemory;

public class OutputBuffer {
    public static final int HANDLER_START = 1;
    public static final int HANDLER_WRITE = 0;
    public static final int HANDLER_FLUSH = 4;
    public static final int HANDLER_CLEAN = 2;
    public static final int HANDLER_FINAL = 8;
    private OutputStream output;
    private ByteArrayOutputStream buffer;
    private boolean binaryInBuffer;
    private Memory callback;
    private Invoker invoker;
    private int chunkSize;
    private boolean erase;
    private final Environment environment;
    private final OutputBuffer parentOutput;
    private int level;
    private Type type;
    private String name = "default output handler";
    private boolean implicitFlush;
    private int lock = 0;
    private boolean isFlushed = false;
    private TraceInfo trace;
    private int status;

    public OutputBuffer(Environment environment, OutputBuffer parent, Memory callback, int chunkSize, boolean erase) {
        this.environment = environment;
        this.buffer = new ByteArrayOutputStream(4098);
        this.callback = callback;
        if (callback != null) {
            this.invoker = Invoker.valueOf(environment, null, callback);
        }
        this.chunkSize = chunkSize;
        this.erase = erase;
        this.parentOutput = parent;
        this.type = Type.INTERNAL;
        this.implicitFlush = false;
        this.status = 1;
    }

    public OutputBuffer(Environment environment, OutputBuffer parent, Memory callback, int chunkSize) {
        this(environment, parent, callback, chunkSize, true);
    }

    public OutputBuffer(Environment environment, OutputBuffer parent, Memory callback) {
        this(environment, parent, callback, 4096);
    }

    public OutputBuffer(Environment environment, OutputBuffer parent) {
        this(environment, parent, null);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public String getName() {
        return this.invoker != null ? this.invoker.getName() : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setImplicitFlush(boolean implicitFlush) {
        this.implicitFlush = implicitFlush;
    }

    public Memory getCallback() {
        return this.callback;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setCallback(Memory callback, Invoker invoker) {
        this.callback = callback;
        this.invoker = invoker;
    }

    public void setCallback(Memory callback) {
        this.callback = callback;
        this.invoker = callback != null ? Invoker.valueOf(this.environment, null, callback) : null;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public boolean isErase() {
        return this.erase;
    }

    public void setErase(boolean erase) {
        this.erase = erase;
    }

    public Memory getContents() throws UnsupportedEncodingException {
        if (!this.binaryInBuffer) {
            return new StringMemory(this.buffer.toString(this.environment.getDefaultCharset().name()));
        }
        return new BinaryMemory(this.buffer.toByteArray());
    }

    protected void reset() {
        this.buffer.reset();
        this.binaryInBuffer = false;
    }

    public void clean() throws Throwable {
        if (this.invoker != null) {
            this.doFlush(false);
        }
        this.status = 2;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFlush(boolean flush) throws Throwable {
        if (flush) {
            this.isFlushed = true;
            if (this.status != 1 && this.status != 4) {
                this.status = 0;
            }
        } else {
            this.status = this.status == 8 ? (this.status |= 2) : 2;
        }
        if (this.invoker != null) {
            Memory result;
            this.invoker.setTrace(this.trace == null ? TraceInfo.UNKNOWN : this.trace);
            Memory[] args = !this.binaryInBuffer ? new Memory[]{new StringMemory(this.buffer.toString(this.environment.getDefaultCharset().name())), null} : new Memory[]{new BinaryMemory(this.buffer.toByteArray()), null};
            args[1] = LongMemory.valueOf(this.status);
            this.invoker.setTrace(this.trace == null ? TraceInfo.UNKNOWN : this.trace);
            this.incLock();
            try {
                result = this.invoker.call(args).toValue();
            }
            finally {
                this.decLock();
            }
            if (result != Memory.FALSE) {
                byte[] data;
                byte[] byArray = data = result instanceof BinaryMemory ? result.getBinaryBytes(this.environment.getDefaultCharset()) : result.toString().getBytes(this.environment.getDefaultCharset());
                if (flush) {
                    if (this.output == null) {
                        this.parentOutput.write(data);
                    } else {
                        this.output.write(data);
                    }
                    this.reset();
                    this.status = 4;
                }
                return;
            }
        }
        if (flush) {
            this.status |= 4;
            if (this.output == null) {
                this.parentOutput.write(this.buffer.toByteArray());
            } else {
                this.buffer.writeTo(this.output);
            }
            this.reset();
        }
    }

    public void write(String content) throws Throwable {
        if (!this.isLock()) {
            this._write(content.getBytes(this.environment.getDefaultCharset()));
        }
    }

    public void write(Memory content) throws Throwable {
        if (!this.isLock()) {
            if ((content = content.toValue()) instanceof BinaryMemory) {
                this.write(content.getBinaryBytes(this.environment.getDefaultCharset()));
            } else {
                this.write(content.toString());
            }
        }
    }

    protected void _write(byte[] bytes) throws Throwable {
        this._write(bytes, bytes.length);
    }

    protected void _write(byte[] bytes, int length) throws Throwable {
        boolean needFlush;
        if (this.isLock()) {
            return;
        }
        boolean bl = needFlush = this.implicitFlush || this.chunkSize > 0 && length + this.buffer.size() >= this.chunkSize;
        if (needFlush) {
            if (this.chunkSize > 0) {
                int cutLength = length + this.buffer.size() - this.chunkSize;
                if (cutLength > 0) {
                    this.buffer.write(bytes, 0, length);
                    this.doFlush(true);
                } else {
                    this.buffer.write(bytes, 0, length);
                    this.doFlush(true);
                }
            } else {
                this.buffer.write(bytes, 0, length);
                this.doFlush(true);
            }
        } else {
            this.buffer.write(bytes, 0, length);
        }
    }

    public void write(byte[] bytes, int length) throws Throwable {
        if (!this.isLock()) {
            this.binaryInBuffer = true;
            this._write(bytes, length);
        }
    }

    public void write(byte[] bytes) throws Throwable {
        this.write(bytes, bytes.length);
    }

    public void flush() throws Throwable {
        if (!this.isLock()) {
            this.status = 4;
            this.doFlush(true);
            if (this.output != null) {
                this.output.flush();
            }
        }
    }

    public void close() throws Throwable {
        if (!this.isBufferEmpty()) {
            this.doFlush(true);
        }
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public boolean isRoot() {
        return this.level == 0;
    }

    public void decLock() {
        if (this.isRoot()) {
            --this.lock;
        } else {
            this.environment.getDefaultBuffer().decLock();
        }
    }

    public void incLock() {
        if (this.isRoot()) {
            ++this.lock;
        } else {
            this.environment.getDefaultBuffer().incLock();
        }
    }

    public boolean isLock() {
        return this.isRoot() ? this.lock > 0 : this.environment.getDefaultBuffer().isLock();
    }

    public boolean isFlushed() {
        return this.isFlushed;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public OutputBuffer getParentOutput() {
        return this.parentOutput;
    }

    public void setTrace(TraceInfo trace) {
        this.trace = trace;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isBufferEmpty() {
        return this.buffer.size() == 0;
    }

    public static enum Type {
        INTERNAL,
        USER;

    }
}

