/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.support.operation.array;

import java.lang.reflect.Array;
import java.util.ArrayList;
import php.runtime.Memory;
import php.runtime.common.HintType;
import php.runtime.env.Environment;
import php.runtime.env.TraceInfo;
import php.runtime.lang.ForeachIterator;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.support.MemoryOperation;
import php.runtime.reflection.ParameterEntity;

public class ArrayMemoryOperation
extends MemoryOperation {
    protected final MemoryOperation operation;
    protected final Class<?> arrayElementClass;
    protected final Class<?> arrayClass;

    public ArrayMemoryOperation(Class<?> arrayClass) {
        this.arrayElementClass = arrayClass.getComponentType();
        this.operation = MemoryOperation.get(this.arrayElementClass, null);
        this.arrayClass = arrayClass;
    }

    @Override
    public Class<?>[] getOperationClasses() {
        return new Class[]{this.arrayClass};
    }

    public Object convert(Environment env, TraceInfo trace, Memory arg) throws Throwable {
        ForeachIterator iterator = arg.getNewIterator(env);
        if (iterator == null) {
            return null;
        }
        ArrayList tmp = new ArrayList();
        while (iterator.next()) {
            tmp.add(this.operation.convert(env, trace, iterator.getValue()));
        }
        Object[] r = (Object[])Array.newInstance(this.arrayElementClass, tmp.size());
        for (int i = 0; i < r.length; ++i) {
            r[i] = tmp.get(i);
        }
        return r;
    }

    public Memory unconvert(Environment env, TraceInfo trace, Object arg) throws Throwable {
        ArrayMemory r = new ArrayMemory();
        for (Object el : (Object[])arg) {
            r.add(this.operation.unconvert(env, trace, el));
        }
        return r.toConstant();
    }

    @Override
    public void applyTypeHinting(ParameterEntity parameter) {
        parameter.setType(HintType.TRAVERSABLE);
    }
}

