/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.memory.output;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import php.runtime.Memory;
import php.runtime.env.Environment;
import php.runtime.lang.Closure;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.DoubleMemory;
import php.runtime.memory.LongMemory;
import php.runtime.memory.ObjectMemory;
import php.runtime.memory.ReferenceMemory;
import php.runtime.memory.StringMemory;
import php.runtime.memory.TrueMemory;

public abstract class Printer {
    protected boolean recursionExists = false;
    protected PrintWriter printer;
    protected final Environment env;

    public Printer(Environment env, Writer writer) {
        this.printer = new PrintWriter(writer);
        this.env = env;
    }

    public boolean isRecursionExists() {
        return this.recursionExists;
    }

    protected abstract void printNull();

    protected abstract void printFalse();

    protected abstract void printTrue();

    protected abstract void printLong(LongMemory var1);

    protected abstract void printDouble(DoubleMemory var1);

    protected abstract void printString(StringMemory var1);

    protected abstract void printArray(ArrayMemory var1, int var2, Set<Integer> var3);

    protected abstract void printObject(ObjectMemory var1, int var2, Set<Integer> var3);

    protected abstract void printClosure(Closure var1, int var2, Set<Integer> var3);

    protected void printReference(ReferenceMemory reference, int level, Set<Integer> used) {
        Memory value = reference.toValue();
        this.print(reference.toValue(), level, used);
    }

    protected void print(Memory value, int level, Set<Integer> used) {
        if (used == null) {
            used = new HashSet<Integer>();
        }
        switch (value.type) {
            case NULL: {
                this.printNull();
                break;
            }
            case BOOL: {
                if (value instanceof TrueMemory) {
                    this.printTrue();
                    break;
                }
                this.printFalse();
                break;
            }
            case INT: {
                this.printLong((LongMemory)value);
                break;
            }
            case DOUBLE: {
                this.printDouble((DoubleMemory)value);
                break;
            }
            case STRING: {
                this.printString((StringMemory)value);
                break;
            }
            case ARRAY: {
                this.printArray((ArrayMemory)value, level, used);
                break;
            }
            case OBJECT: {
                ObjectMemory tmp = (ObjectMemory)value;
                if (tmp.value instanceof Closure) {
                    this.printClosure((Closure)tmp.value, level, used);
                    break;
                }
                this.printObject((ObjectMemory)value, level, used);
                break;
            }
            case REFERENCE: {
                this.printReference((ReferenceMemory)value, level, used);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type for printing: " + (Object)((Object)value.type));
            }
        }
    }

    public void print(Memory value) {
        this.print(value, 0, null);
    }

    public static class UnsupportedValue
    extends RuntimeException {
    }
}

