/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump.io;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import php.runtime.Memory;
import php.runtime.env.TraceInfo;
import php.runtime.lang.ForeachIterator;
import php.runtime.loader.dump.io.DumpException;
import php.runtime.memory.ArrayMemory;
import php.runtime.memory.helper.ClassConstantMemory;
import php.runtime.memory.helper.ConstantMemory;

public class DumpOutputStream
extends DataOutputStream {
    public static final int MAX_LENGTH_OF_RAW_DATA = 204800;

    public DumpOutputStream(OutputStream out) {
        super(out);
    }

    public void writeName(String value) throws IOException {
        if (value == null) {
            this.writeInt(-1);
        } else {
            this.writeInt(value.length());
            this.writeUTF(value);
        }
    }

    public void writeTrace(TraceInfo trace) throws IOException {
        this.writeBoolean(trace != null);
        if (trace != null) {
            this.writeInt(trace.getStartLine());
            this.writeInt(trace.getStartPosition());
            this.writeUTF(trace.getFileName());
        }
    }

    public void writeMemory(Memory memory) throws IOException {
        if (memory == null) {
            this.writeInt(-1);
            return;
        }
        if ((memory = memory.toValue()) instanceof ConstantMemory) {
            this.writeInt(-2);
            this.writeUTF(((ConstantMemory)memory).getName());
            return;
        }
        if (memory instanceof ClassConstantMemory) {
            this.writeInt(-3);
            this.writeUTF(((ClassConstantMemory)memory).getClassName());
            this.writeUTF(((ClassConstantMemory)memory).getName());
            return;
        }
        Memory.Type type = memory.getRealType();
        this.writeInt(type.ordinal());
        switch (type) {
            case NULL: {
                break;
            }
            case INT: {
                this.writeLong(memory.toLong());
                break;
            }
            case STRING: {
                this.writeUTF(memory.toString());
                break;
            }
            case DOUBLE: {
                this.writeDouble(memory.toDouble());
                break;
            }
            case BOOL: {
                this.writeBoolean(memory.toBoolean());
                break;
            }
            case ARRAY: {
                ArrayMemory array = memory.toValue(ArrayMemory.class);
                if (array.size() > Short.MAX_VALUE) {
                    throw new DumpException("Array is too big");
                }
                this.writeInt(array.size());
                ForeachIterator foreachIterator = array.foreachIterator(false, false);
                while (foreachIterator.next()) {
                    Memory key = foreachIterator.getMemoryKey();
                    Memory value = foreachIterator.getValue();
                    if (value.isShortcut()) {
                        throw new DumpException("Cannot dump references");
                    }
                    if (value.toValue() == Memory.UNDEFINED) continue;
                    this.writeMemory(key);
                    this.writeMemory(value.toValue());
                }
                break;
            }
            default: {
                throw new DumpException("Cannot dump " + type.toString() + " memory");
            }
        }
    }

    public void writeRawData(byte[] bytes, int max) throws IOException {
        if (bytes == null || bytes.length == 0) {
            this.writeInt(0);
        } else {
            if (bytes.length > max) {
                throw new DumpException("Raw-size is too big, max 204800");
            }
            this.writeInt(bytes.length);
            this.write(bytes);
        }
    }

    public void writeRawData(byte[] bytes) throws IOException {
        this.writeRawData(bytes, 204800);
    }

    public void writeEnum(Enum _enum) throws IOException {
        this.writeInt(_enum == null ? -1 : _enum.ordinal());
    }
}

