/*
 * Decompiled with CFR 0.152.
 */
package php.runtime.loader.dump;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import php.runtime.env.Context;
import php.runtime.env.Environment;
import php.runtime.loader.dump.Dumper;
import php.runtime.loader.dump.io.DumpInputStream;
import php.runtime.loader.dump.io.DumpOutputStream;
import php.runtime.reflection.ParameterEntity;

public class ParameterDumper
extends Dumper<ParameterEntity> {
    public ParameterDumper(Context context, Environment env, boolean debugInformation) {
        super(context, env, debugInformation);
    }

    @Override
    public int getType() {
        return 100;
    }

    @Override
    public void save(ParameterEntity entity, OutputStream output) throws IOException {
        DumpOutputStream print = new DumpOutputStream(output);
        print.writeEnum(entity.getType());
        print.writeName(entity.getTypeClass());
        print.writeBoolean(entity.isReference());
        print.writeBoolean(entity.isMutable());
        print.writeBoolean(entity.isUsed());
        print.writeBoolean(entity.isVariadic());
        print.writeBoolean(entity.isNullable());
        print.writeName(entity.getName());
        print.writeTrace(this.debugInformation ? entity.getTrace() : null);
        print.writeMemory(entity.getDefaultValue());
        print.writeName(entity.getDefaultValueConstName());
        print.writeRawData(null);
    }

    @Override
    public ParameterEntity load(InputStream input) throws IOException {
        DumpInputStream data = new DumpInputStream(input);
        ParameterEntity entity = new ParameterEntity(this.context);
        entity.setType(data.readHintType());
        String typeClass = data.readName();
        if (typeClass != null && !typeClass.isEmpty()) {
            entity.setTypeClass(typeClass);
        }
        entity.setReference(data.readBoolean());
        entity.setMutable(data.readBoolean());
        entity.setUsed(data.readBoolean());
        entity.setVariadic(data.readBoolean());
        entity.setNullable(data.readBoolean());
        entity.setName(data.readName());
        entity.setTrace(data.readTrace(this.context));
        entity.setDefaultValue(data.readMemory());
        entity.setDefaultValueConstName(data.readName());
        byte[] raw = data.readRawData();
        return entity;
    }
}

